/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.jorm.lib;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.objectweb.jorm.api.PException;
import org.objectweb.jorm.api.PMapCluster;

public abstract class AbstractPMapcluster
implements PMapCluster {
    protected Set jcNames = new HashSet(1);
    protected Set unresolvedDependencies = new HashSet(1);
    protected boolean structuresActive = false;

    public Collection getClusterClasses() {
        if (this.unresolvedDependencies.isEmpty()) {
            return this.jcNames;
        }
        HashSet res = new HashSet(this.jcNames);
        res.addAll(this.unresolvedDependencies);
        return res;
    }

    public boolean isDefined() {
        return this.unresolvedDependencies.isEmpty();
    }

    public Set getUnResolvedDependencies() {
        return this.unresolvedDependencies;
    }

    public void addDependency(String jcname) {
        if (!this.jcNames.contains(jcname) && !this.unresolvedDependencies.contains(jcname)) {
            this.unresolvedDependencies.add(jcname);
        }
    }

    public void classDefined(String jcname) {
        if (!this.jcNames.contains(jcname)) {
            this.jcNames.add(jcname);
            this.unresolvedDependencies.remove(jcname);
        }
    }

    public boolean containClass(String jcname) {
        return this.jcNames.contains(jcname);
    }

    public void start() throws PException {
        if (!this.structuresActive) {
            throw new PException("Cannot start map cluster: not yet inactive");
        }
        if (!this.isDefined()) {
            throw new PException("Cannot start map cluster: the following dependencies have not been resolved: " + this.unresolvedDependencies);
        }
        this.structuresActive = true;
    }

    public void stop() throws PException {
        if (this.structuresActive) {
            throw new PException("Cannot stop map cluster: not yet active");
        }
        this.structuresActive = false;
    }

    public void updateMappingStructures() throws PException, UnsupportedOperationException {
        if (this.structuresActive) {
            throw new PException("Cannot change mapping structures while they are under use");
        }
        throw new UnsupportedOperationException();
    }
}

