/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.jorm.mapper.rdb.adapter;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.objectweb.jorm.mapper.rdb.adapter.BasicRdbAdapter;
import org.objectweb.jorm.mapper.rdb.adapter.api.RdbAdapterException;

public class HsqlAdapter
extends BasicRdbAdapter {
    public HsqlAdapter() {
        super("hsql");
    }

    public boolean supportBatchPreparedStatement() {
        return false;
    }

    public String getIndexedLocateExpression(String instring, String substring, String fromIndex) {
        StringBuffer sb = new StringBuffer();
        sb.append("locate(").append(substring).append(", ");
        sb.append(instring).append(", ").append(fromIndex).append(")");
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean existRelation(Connection connection, String tableName, String[] relationTypes) throws SQLException {
        boolean existtable = false;
        ResultSet rs = null;
        if (relationTypes == null) {
            relationTypes = new String[]{"TABLE", "VIEW"};
        }
        String schema = null;
        if (tableName.indexOf(46) != -1) {
            schema = tableName.substring(0, tableName.indexOf(46));
            tableName = tableName.substring(tableName.indexOf(46) + 1);
        }
        try {
            rs = connection.getMetaData().getTables(null, schema, null, relationTypes);
            while (rs.next() && !existtable) {
                existtable = tableName.equalsIgnoreCase(rs.getString(3));
            }
        }
        finally {
            if (rs != null) {
                rs.close();
            }
        }
        return existtable;
    }

    public boolean existSequence(Connection connection, String seqName) throws SQLException {
        ResultSet rs = null;
        PreparedStatement ps = connection.prepareStatement("SELECT * FROM SYSTEM_SEQUENCES WHERE SEQUENCE_NAME='" + seqName.toUpperCase() + "'");
        rs = ps.executeQuery();
        return rs.next();
    }

    public String getNextValInSequence(String seqName) {
        return "SELECT NEXT VALUE FOR " + seqName + " FROM SYSTEM_SEQUENCES WHERE SEQUENCE_NAME='" + seqName.toUpperCase() + "'";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void getManyNextValInSequence(Connection conn, String seqName, int numberOfNextVal) throws RdbAdapterException {
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT ");
        for (int i = 0; i < numberOfNextVal - 1; ++i) {
            sb.append("NEXT VALUE FOR " + seqName + ", ");
        }
        sb.append("NEXT VALUE FOR " + seqName + " FROM SYSTEM_SEQUENCES WHERE SEQUENCE_NAME='" + seqName.toUpperCase() + "'");
        PreparedStatement ps = null;
        try {
            try {
                ps = conn.prepareStatement(sb.toString());
                ps.executeQuery();
            }
            catch (SQLException e) {
                throw new RdbAdapterException(e, "Impossible to allocate " + numberOfNextVal + " identifier" + " on the sequence: " + seqName);
            }
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            try {
                if (ps == null) throw throwable;
                ps.close();
                throw throwable;
            }
            catch (SQLException e) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (SQLException e) {}
        if (ps == null) return;
        ps.close();
        return;
    }

    protected void modifySelectClauseWithRange(StringBuffer sb, boolean rangeStart, boolean rangeSize) {
        if (rangeSize || rangeStart) {
            if (rangeStart) {
                sb.append(" LIMIT ? ");
            } else {
                sb.append(" LIMIT 0 ");
            }
            if (rangeSize) {
                sb.append(" ? ");
            } else {
                sb.append(" 0 ");
            }
        }
    }

    protected void modifyQueryWithRange(StringBuffer sb, boolean rangeStart, boolean rangeSize) {
    }

    public int getRangeParametersAtStart() {
        return 0;
    }
}

