/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.jorm.mapper.rdb.lib;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.objectweb.jorm.api.PException;
import org.objectweb.jorm.api.PExceptionProtocol;
import org.objectweb.jorm.api.PMapCluster;
import org.objectweb.jorm.api.PMapper;
import org.objectweb.jorm.api.PMappingStructuresManager;
import org.objectweb.jorm.mapper.rdb.lib.RdbPMapCluster;
import org.objectweb.util.monolog.api.Logger;

public class RdbPMappingStructuresManager
implements PMappingStructuresManager {
    private PMapper pMapper = null;
    private ArrayList clusterList = new ArrayList();
    protected Logger logger = null;

    void closeConnection(Object conn) throws PException {
        this.pMapper.closeConnection(conn);
    }

    Object getConnection() throws PException {
        Object conn = this.pMapper.getConnection();
        if (conn == null) {
            throw new PExceptionProtocol("Impossible to initialize the mapping structures without connection");
        }
        return conn;
    }

    private RdbPMapCluster getAlwaysPMapCluster(String jcname, String tname) throws PException {
        RdbPMapCluster cl = null;
        Iterator it = this.clusterList.iterator();
        while (it.hasNext() && !(cl = (RdbPMapCluster)it.next()).containTable(tname)) {
            cl = null;
        }
        if (cl == null) {
            cl = (RdbPMapCluster)this.getPMapCluster(jcname);
            if (cl == null) {
                cl = new RdbPMapCluster(jcname, tname, this);
                this.clusterList.add(cl);
            }
        } else {
            RdbPMapCluster cl2 = (RdbPMapCluster)this.getPMapCluster(jcname);
            if (cl != cl2 && cl2 != null) {
                cl.merge(cl2);
                this.clusterList.remove(cl2);
            } else {
                cl.classDefined(jcname);
            }
        }
        return cl;
    }

    public synchronized void addTableColumn(String jcname, String tname, String cname, String type, boolean notnull, boolean ispkcol, boolean isMaster) throws PException {
        RdbPMapCluster cl = this.getAlwaysPMapCluster(jcname, tname);
        cl.addTableColumn(tname, cname, type, notnull, ispkcol, isMaster);
    }

    public synchronized void declareClass(String jcname) {
        RdbPMapCluster cl;
        Iterator it = this.clusterList.iterator();
        while (it.hasNext()) {
            cl = (RdbPMapCluster)it.next();
            if (!cl.containClass(jcname)) continue;
            return;
        }
        cl = new RdbPMapCluster(jcname, this);
        this.clusterList.add(cl);
    }

    public PMapper getPMapper() {
        return this.pMapper;
    }

    public synchronized PMapCluster getPMapCluster(String jcname) throws PException {
        Iterator it = this.clusterList.iterator();
        while (it.hasNext()) {
            RdbPMapCluster cl = (RdbPMapCluster)it.next();
            if (!cl.containClass(jcname) && !cl.getUnResolvedDependencies().contains(jcname)) continue;
            return cl;
        }
        return null;
    }

    public Collection getPMapClusters() {
        return this.clusterList;
    }

    public synchronized void addDependency(String jcname1, String jcname2) throws PException {
        RdbPMapCluster cl1 = (RdbPMapCluster)this.getPMapCluster(jcname1);
        if (cl1 == null) {
            throw new PException("You must define the class " + jcname1 + " before adding its dependcies (no cluster found).");
        }
        RdbPMapCluster cl2 = (RdbPMapCluster)this.getPMapCluster(jcname2);
        if (cl2 == null) {
            cl1.addDependency(jcname2);
        } else if (cl2 != cl1) {
            cl1.merge(cl2);
            this.clusterList.remove(cl2);
        }
    }

    public void classDefined(String jcname) throws PException {
        RdbPMapCluster cl = (RdbPMapCluster)this.getPMapCluster(jcname);
        if (cl == null) {
            throw new PException("No cluster found for the class " + jcname);
        }
        cl.classDefined(jcname);
    }

    public void setPMapper(PMapper pm) {
        this.pMapper = pm;
    }

    public void setLogger(Logger l) {
        this.logger = l;
    }

    public void clear() throws PException {
        this.clusterList.clear();
    }
}

