/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.jorm.metainfo.lib;

import java.util.Collection;
import java.util.HashMap;
import java.util.Set;
import org.objectweb.jorm.metainfo.api.Class;
import org.objectweb.jorm.metainfo.api.ClassProject;
import org.objectweb.jorm.metainfo.api.Mapping;
import org.objectweb.jorm.metainfo.api.MetaObject;
import org.objectweb.jorm.metainfo.lib.BasicMetaObject;
import org.objectweb.util.monolog.api.BasicLevel;

public class BasicClassProject
extends BasicMetaObject
implements ClassProject {
    String projectName;
    HashMap mappings;

    public BasicClassProject(String projectName, MetaObject parent) {
        super(parent);
        this.projectName = projectName;
        this.mappings = new HashMap();
    }

    public String getProjectName() {
        return this.projectName;
    }

    public void setProjectName(String name) {
        this.projectName = name;
    }

    public Collection getMappings() {
        return this.mappings.values();
    }

    public Mapping getMapping(String mapperName) {
        Mapping mapping = (Mapping)this.mappings.get(mapperName);
        return mapping;
    }

    public Set getMappers() {
        return this.mappings.keySet();
    }

    public Mapping createMapping(String mapperName) {
        Mapping mp;
        if (this.debug) {
            this.logger.log(BasicLevel.DEBUG, (Object)("Create a new Mapping (" + mapperName + ") for the current ClassProject (" + this.projectName + ")"));
        }
        if ((mp = (Mapping)this.mappings.get(mapperName)) == null) {
            mp = this.getManager().getMappingFactory(mapperName).createMapping(mapperName, this);
            this.setLoggingOnChild(mp);
            this.mappings.put(mapperName, mp);
        } else {
            String className = ((Class)this.getParent()).getName();
            if (this.debug) {
                this.logger.log(BasicLevel.DEBUG, (Object)("try to map twice the class (" + className + ") using the mapper (" + mapperName + "), the existing mapping is returned."));
            }
        }
        return mp;
    }

    protected Collection getChildren() {
        return this.mappings.values();
    }
}

