/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.jorm.xml2mi.lib;

import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.tools.ant.types.DTDLocation;
import org.objectweb.jorm.api.PException;
import org.objectweb.jorm.metainfo.api.Class;
import org.objectweb.jorm.metainfo.api.ClassMapping;
import org.objectweb.jorm.metainfo.api.ClassProject;
import org.objectweb.jorm.metainfo.api.ClassRef;
import org.objectweb.jorm.metainfo.api.CompositeName;
import org.objectweb.jorm.metainfo.api.GenClassRef;
import org.objectweb.jorm.metainfo.api.IdentifierMapping;
import org.objectweb.jorm.metainfo.api.Manager;
import org.objectweb.jorm.metainfo.api.Mapping;
import org.objectweb.jorm.metainfo.api.MetaObject;
import org.objectweb.jorm.metainfo.api.NameDef;
import org.objectweb.jorm.metainfo.api.NameRef;
import org.objectweb.jorm.metainfo.api.Package;
import org.objectweb.jorm.metainfo.api.ParentClassMapping;
import org.objectweb.jorm.metainfo.api.PrimitiveElement;
import org.objectweb.jorm.metainfo.api.Reference;
import org.objectweb.jorm.metainfo.api.TypedElement;
import org.objectweb.jorm.type.api.PType;
import org.objectweb.jorm.type.api.PTypeSpace;
import org.objectweb.jorm.util.api.Loggable;
import org.objectweb.jorm.util.io.api.PathExplorer;
import org.objectweb.jorm.util.io.lib.DirJavaExplorer;
import org.objectweb.jorm.xml2mi.api.MappingParser;
import org.objectweb.jorm.xml2mi.api.Parser;
import org.objectweb.jorm.xml2mi.lib.DTDResolver;
import org.objectweb.jorm.xml2mi.lib.ParserHelper;
import org.objectweb.jorm.xml2mi.lib.SAXParserHelper;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class BasicDomParser
extends ParserHelper
implements Parser,
Loggable {
    private Manager metaInfoManager;
    private Map mappingParsers = new HashMap();
    private SAXParserHelper parser;
    private PathExplorer pathExplorer;
    private Exception parserException = null;
    private boolean genDep = false;
    private DTDResolver resolver = null;
    private List parsedMO = null;
    private List undefinedMO = null;
    private Map idvalue2genclassref;

    public void init(boolean dtdVerify, ArrayList dtds) {
        Properties p = new Properties();
        if (dtds != null) {
            Iterator iter = dtds.iterator();
            while (iter.hasNext()) {
                DTDLocation element = (DTDLocation)iter.next();
                p.setProperty(element.getPublicId(), element.getLocation());
            }
        }
        try {
            this.parser = new SAXParserHelper(p, this.logger, null, dtdVerify);
        }
        catch (SAXException e) {
            this.logger.log(BasicLevel.ERROR, (Object)"Error during the parser initialization", (Throwable)e);
        }
        this.parsedMO = new ArrayList();
        this.undefinedMO = new ArrayList();
        this.motable = new Hashtable();
        this.mappingParsers = new HashMap();
        this.idvalue2genclassref = new HashMap();
    }

    public void addMappingParser(String mapperName, MappingParser mappingParser) throws PException {
        if (mappingParser == null) {
            throw new PException("<" + mapperName + "> MappingParser has not been created.");
        }
        if (this.logger.isLoggable(BasicLevel.DEBUG)) {
            this.logger.log(BasicLevel.DEBUG, (Object)("Add a MappingParser (" + mapperName + ") for the current Parser"));
        }
        if (!this.mappingParsers.containsKey(mapperName)) {
            this.mappingParsers.put(mapperName, mappingParser);
        }
    }

    public MappingParser getMappingParser(String mapperName) {
        MappingParser mappingParser = (MappingParser)this.mappingParsers.get(mapperName);
        if (this.logger.isLoggable(BasicLevel.DEBUG)) {
            this.logger.log(BasicLevel.DEBUG, (Object)("Looking for mapping parser of mapper [" + mapperName + "]: " + mappingParser));
        }
        return mappingParser;
    }

    public Collection parse(Iterator files) throws PException {
        Class clazz;
        MetaObject metaObject;
        ArrayList<MetaObject> res = new ArrayList<MetaObject>();
        while (files.hasNext()) {
            String filename = (String)files.next();
            MetaObject mo = (MetaObject)this.motable.get(filename);
            if (mo == null && (mo = this.parse(filename)) != null) {
                this.motable.put(filename, mo);
            }
            res.add(mo);
        }
        while (!this.undefinedMO.isEmpty()) {
            MetaObject mo = (MetaObject)this.undefinedMO.remove(0);
            String fqname = null;
            if (mo instanceof Class) {
                fqname = ((Class)mo).getFQName();
            } else if (mo instanceof CompositeName) {
                fqname = ((CompositeName)mo).getFQName();
            } else {
                throw new PException("Unknown meta object: " + mo);
            }
            fqname = fqname.replace('.', File.separatorChar) + ".pd";
            this.parse(fqname);
            this.motable.put(fqname, mo);
        }
        HashSet handledImplicitMappings = new HashSet();
        Iterator itMO = res.iterator();
        while (itMO.hasNext()) {
            metaObject = (MetaObject)itMO.next();
            if (!(metaObject instanceof Class)) continue;
            clazz = (Class)metaObject;
            this.addImplicitMappings(clazz, handledImplicitMappings);
        }
        itMO = res.iterator();
        while (itMO.hasNext()) {
            metaObject = (MetaObject)itMO.next();
            if (!(metaObject instanceof Class)) continue;
            clazz = (Class)metaObject;
            this.addImplicitDependencies(clazz);
        }
        Set filenames = this.motable.keySet();
        if (!filenames.isEmpty()) {
            Iterator iter = filenames.iterator();
            while (iter.hasNext()) {
                String filename = (String)iter.next();
                this.logger.log(BasicLevel.DEBUG, (Object)("BasicDomParser filename in motable " + filename));
            }
        }
        this.logger.log(BasicLevel.DEBUG, (Object)("BasicDomParser size of motable " + this.motable.size()));
        this.logger.log(BasicLevel.DEBUG, (Object)("BasicDomParser size of res " + res.size()));
        return res;
    }

    public MetaObject parse(String file) throws PException {
        Document doc;
        InputStream is;
        this.logger.log(BasicLevel.INFO, (Object)("Parsing the file " + file + "..."));
        boolean debug = this.logger.isLoggable(BasicLevel.DEBUG);
        if (debug) {
            this.logger.log(BasicLevel.DEBUG, (Object)("try to get input stream from <" + file + ">"));
        }
        if ((is = this.pathExplorer.getInputStream(file)) == null) {
            throw new PException("The file '" + file + "' has not been found in the following classpath \"" + this.pathExplorer.getClassPath() + "\"");
        }
        if (debug) {
            this.logger.log(BasicLevel.DEBUG, (Object)("File " + file + " found"));
        }
        try {
            doc = this.parser.parse(is);
        }
        catch (Exception e) {
            this.logger.log(BasicLevel.ERROR, (Object)("Parsing error for file: " + file), (Throwable)e);
            this.parserException = e;
            throw new PException(e, "there is a problem (exception) during the parsing of <" + file + "> from the SAX module (SAXNotRecognized)");
        }
        if (debug) {
            this.logger.log(BasicLevel.DEBUG, (Object)"Parsing done.");
        }
        return doc.getDocumentElement() != null ? this.build(doc, file) : null;
    }

    public void setMetaInfoManager(Manager mim) {
        this.metaInfoManager = mim;
    }

    public void setPathExplorer(PathExplorer pathexpl) {
        this.pathExplorer = pathexpl;
        if (this.pathExplorer == null) {
            this.pathExplorer = new DirJavaExplorer();
        }
        this.logger.log(BasicLevel.DEBUG, (Object)("jorm classpath=" + this.pathExplorer.getClassPath()));
    }

    public void setGenDep(boolean gendep) {
        this.genDep = gendep;
    }

    public boolean isGenDep() {
        return this.genDep;
    }

    public Exception getParserException() {
        return this.parserException;
    }

    private MetaObject build(Document doc, String name) throws PException {
        if (this.logger.isLoggable(BasicLevel.DEBUG)) {
            this.logger.log(BasicLevel.DEBUG, (Object)("build the meta information for <" + name + "> description file"));
        }
        Package schema = null;
        Class clazz = null;
        CompositeName aname = null;
        NodeList nodes = doc.getDocumentElement().getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            int index;
            Node node = nodes.item(i);
            String nodeName = node.getNodeName();
            if (nodeName.equals("package")) {
                if (this.logger.isLoggable(BasicLevel.DEBUG)) {
                    this.logger.log(BasicLevel.DEBUG, (Object)("begin =<" + nodeName + ">"));
                    this.logger.log(BasicLevel.DEBUG, (Object)("package name =<" + node.getFirstChild().getNodeValue() + ">"));
                }
                schema = this.metaInfoManager.createPackage(node.getFirstChild().getNodeValue());
                if (!this.logger.isLoggable(BasicLevel.DEBUG)) continue;
                this.logger.log(BasicLevel.DEBUG, (Object)("end   =<" + nodeName + ">"));
                continue;
            }
            if (nodeName.equals("class")) {
                String sub;
                String className = ((Element)node).getAttribute("name");
                index = name.lastIndexOf(File.separatorChar);
                int endIdx = name.lastIndexOf(".");
                if (endIdx <= index) {
                    endIdx = name.length();
                }
                if (!(sub = name.substring(index + 1, endIdx)).equals(className)) {
                    this.logger.log(BasicLevel.WARN, (Object)("Be careful, the name of the class is different from the name of the file : " + sub + " and " + className + "(" + className + " is used)"));
                }
                if (this.logger.isLoggable(BasicLevel.DEBUG)) {
                    this.logger.log(BasicLevel.DEBUG, (Object)("begin =<" + nodeName + ">"));
                }
                String isAbstractString = ((Element)node).getAttribute("abstract").toLowerCase();
                if (schema == null) {
                    schema = this.metaInfoManager.createPackage("");
                }
                if (!this.parsedMO.contains(clazz = schema.createClass(className))) {
                    this.parsedMO.add(clazz);
                    this.undefinedMO.remove(clazz);
                    boolean abstractClass = isAbstractString != null && isAbstractString.equals("true");
                    clazz.setAbstract(abstractClass);
                    if (this.logger.isLoggable(BasicLevel.DEBUG)) {
                        this.logger.log(BasicLevel.DEBUG, (Object)("isAbstractString:<" + isAbstractString + ">"));
                        this.logger.log(BasicLevel.DEBUG, (Object)("Boolean.getBoolean(" + isAbstractString + "):" + Boolean.getBoolean(isAbstractString)));
                        this.logger.log(BasicLevel.DEBUG, (Object)("abstractClass:<" + abstractClass + ">"));
                        this.logger.log(BasicLevel.DEBUG, (Object)("class FQName:<" + clazz.getFQName() + "> isabstract:<" + clazz.isAbstract() + ">"));
                    }
                    this.processClass(clazz, (Element)node);
                }
                if (!this.logger.isLoggable(BasicLevel.DEBUG)) continue;
                this.logger.log(BasicLevel.DEBUG, (Object)("end   =<" + nodeName + ">"));
                continue;
            }
            if (nodeName.equals("mapping")) {
                if (this.logger.isLoggable(BasicLevel.DEBUG)) {
                    this.logger.log(BasicLevel.DEBUG, (Object)("begin =<" + nodeName + ">"));
                }
                String projectName = ((Element)node).getAttribute("project-name");
                if (clazz == null) {
                    this.logger.log(BasicLevel.DEBUG, (Object)"the class definition is missing!");
                    break;
                }
                if (this.logger.isLoggable(BasicLevel.DEBUG)) {
                    this.logger.log(BasicLevel.DEBUG, (Object)("project-name =<" + projectName + ">"));
                }
                ClassProject classProject = clazz.createClassProject(projectName);
                this.parseMapping((Element)node, classProject);
                if (!this.logger.isLoggable(BasicLevel.DEBUG)) continue;
                this.logger.log(BasicLevel.DEBUG, (Object)("end   =<" + nodeName + ">"));
                continue;
            }
            if (!nodeName.equals("composite-name")) continue;
            String CN_name = ((Element)node).getAttribute("name");
            index = name.lastIndexOf(File.separatorChar);
            String sub = name.substring(index + 1, name.length() - 3);
            if (sub.compareTo(CN_name) != 0) {
                this.logger.log(BasicLevel.WARN, (Object)("Be careful, the name of the composite name is different from the name of the file : " + name + " and " + CN_name + "(" + CN_name + " is used)"));
            }
            if (this.logger.isLoggable(BasicLevel.DEBUG)) {
                this.logger.log(BasicLevel.DEBUG, (Object)("begin =<" + nodeName + ">"));
            }
            if (schema == null) {
                schema = this.metaInfoManager.createPackage("");
            }
            if (!this.parsedMO.contains(aname = schema.createCompositeName(CN_name))) {
                this.parsedMO.add(aname);
                this.undefinedMO.remove(aname);
                this.processCompositeName(aname, (Element)node);
            }
            if (this.logger.isLoggable(BasicLevel.DEBUG)) {
                this.logger.log(BasicLevel.DEBUG, (Object)("end   =<" + nodeName + ">"));
            }
            return aname;
        }
        return clazz;
    }

    private void processCompositeName(CompositeName compositeName, Element compositeNameElem) {
        NodeList children = compositeNameElem.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            String CN_name;
            CompositeName parentCN;
            Node child = children.item(i);
            String childName = child.getNodeName();
            if (childName.equals("scalar-field")) {
                if (this.logger.isLoggable(BasicLevel.DEBUG)) {
                    this.logger.log(BasicLevel.DEBUG, (Object)("begin =<" + childName + ">"));
                }
                this.processScalarField(compositeName, (Element)child);
                if (!this.logger.isLoggable(BasicLevel.DEBUG)) continue;
                this.logger.log(BasicLevel.DEBUG, (Object)("end   =<" + childName + ">"));
                continue;
            }
            if (!childName.equals("extension")) continue;
            if (this.logger.isLoggable(BasicLevel.DEBUG)) {
                this.logger.log(BasicLevel.DEBUG, (Object)("begin =<" + childName + ">"));
            }
            if ((parentCN = this.metaInfoManager.getCompositeName(CN_name = ((Element)child).getAttribute("Name"))) == null) {
                parentCN = this.metaInfoManager.createCompositeName(CN_name);
                this.undefinedMO.add(parentCN);
            }
            compositeName.addInheritedCompositeName(parentCN);
            if (!this.logger.isLoggable(BasicLevel.DEBUG)) continue;
            this.logger.log(BasicLevel.DEBUG, (Object)("end   =<" + childName + ">"));
        }
    }

    private void processClass(Class clazz, Element classElem) throws PException {
        NodeList children = classElem.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            NameDef nd;
            Node child = children.item(i);
            String nodeName = child.getNodeName();
            if (nodeName.equals("field")) {
                if (this.logger.isLoggable(BasicLevel.DEBUG)) {
                    this.logger.log(BasicLevel.DEBUG, (Object)("begin =<" + nodeName + ">"));
                }
                this.processField(clazz, (Element)child);
                if (!this.logger.isLoggable(BasicLevel.DEBUG)) continue;
                this.logger.log(BasicLevel.DEBUG, (Object)("end   =<" + nodeName + ">"));
                continue;
            }
            if (nodeName.equals("scalar-field")) {
                if (this.logger.isLoggable(BasicLevel.DEBUG)) {
                    this.logger.log(BasicLevel.DEBUG, (Object)("begin =<" + nodeName + ">"));
                }
                this.processScalarField(clazz, (Element)child);
                if (!this.logger.isLoggable(BasicLevel.DEBUG)) continue;
                this.logger.log(BasicLevel.DEBUG, (Object)("end   =<" + nodeName + ">"));
                continue;
            }
            if (nodeName.equals("constant-value")) {
                if (this.logger.isLoggable(BasicLevel.DEBUG)) {
                    this.logger.log(BasicLevel.DEBUG, (Object)("begin =<" + nodeName + ">"));
                }
                this.processConstantValue(clazz, (Element)child);
                if (!this.logger.isLoggable(BasicLevel.DEBUG)) continue;
                this.logger.log(BasicLevel.DEBUG, (Object)("end   =<" + nodeName + ">"));
                continue;
            }
            if (nodeName.equals("extension")) {
                Class inheritedClass;
                String fqcn = ((Element)child).getAttribute("name");
                if (this.logger.isLoggable(BasicLevel.DEBUG)) {
                    this.logger.log(BasicLevel.DEBUG, (Object)("begin =<" + nodeName + ">"));
                    this.logger.log(BasicLevel.DEBUG, (Object)("name of the extension=<" + fqcn + ">"));
                }
                if ((inheritedClass = this.metaInfoManager.getClass(fqcn)) == null) {
                    fqcn = fqcn.replace('.', File.separatorChar) + ".pd";
                    inheritedClass = (Class)this.parse(fqcn);
                    this.motable.put(fqcn, inheritedClass);
                }
                clazz.addSuperClass(inheritedClass);
                if (!this.logger.isLoggable(BasicLevel.DEBUG)) continue;
                this.logger.log(BasicLevel.DEBUG, (Object)("end   =<" + nodeName + ">"));
                continue;
            }
            if (nodeName.equals("name-def")) {
                if (this.logger.isLoggable(BasicLevel.DEBUG)) {
                    this.logger.log(BasicLevel.DEBUG, (Object)("begin =<" + nodeName + ">"));
                }
                NameDef nameDef = clazz.createNameDef();
                this.processNameDef(nameDef, (Element)child);
                if (!this.logger.isLoggable(BasicLevel.DEBUG)) continue;
                this.logger.log(BasicLevel.DEBUG, (Object)("end   =<" + nodeName + ">"));
                continue;
            }
            if (nodeName.equals("name-def-filter")) {
                if (this.logger.isLoggable(BasicLevel.DEBUG)) {
                    this.logger.log(BasicLevel.DEBUG, (Object)("begin =<" + nodeName + ">"));
                }
                String filter = ((Element)child).getAttribute("filter");
                nd = this.getIdNameDef(clazz, ((Element)child).getAttribute("link-end"));
                clazz.setInheritanceFilter(nd, filter);
                if (!this.logger.isLoggable(BasicLevel.DEBUG)) continue;
                this.logger.log(BasicLevel.DEBUG, (Object)("end   =<" + nodeName + ">"));
                continue;
            }
            if (!nodeName.equals("name-def-key")) continue;
            if (this.logger.isLoggable(BasicLevel.DEBUG)) {
                this.logger.log(BasicLevel.DEBUG, (Object)("begin =<" + nodeName + ">"));
            }
            String key = ((Element)child).getAttribute("key");
            nd = this.getIdNameDef(clazz, ((Element)child).getAttribute("link-end"));
            clazz.setInheritanceNamingKey(nd, key);
            if (!this.logger.isLoggable(BasicLevel.DEBUG)) continue;
            this.logger.log(BasicLevel.DEBUG, (Object)("end   =<" + nodeName + ">"));
        }
    }

    private void processScalarField(MetaObject mo, Element scalarFieldElem) {
        String scalarFieldName = scalarFieldElem.getAttribute("name");
        NodeList children = scalarFieldElem.getChildNodes();
        PrimitiveElement scalarField = null;
        for (int j = 0; j < children.getLength(); ++j) {
            Node child = children.item(j);
            String childName = child.getNodeName();
            if (this.logger.isLoggable(BasicLevel.DEBUG)) {
                this.logger.log(BasicLevel.DEBUG, (Object)("begin =<" + childName + ">"));
            }
            if (childName.equals("scalar-type")) {
                String type = ((Element)child).getAttribute("type");
                if (mo instanceof Class) {
                    scalarField = ((Class)mo).createHiddenField(scalarFieldName, this.getPType(type), Integer.parseInt(((Element)child).getAttribute("size")), Integer.parseInt(((Element)child).getAttribute("scale")));
                } else if (mo instanceof GenClassRef) {
                    scalarField = ((GenClassRef)mo).createHiddenField(scalarFieldName, this.getPType(type), Integer.parseInt(((Element)child).getAttribute("size")), Integer.parseInt(((Element)child).getAttribute("scale")));
                } else if (mo instanceof CompositeName) {
                    scalarField = ((CompositeName)mo).createCompositeNameField(scalarFieldName, this.getPType(type), Integer.parseInt(((Element)child).getAttribute("size")), Integer.parseInt(((Element)child).getAttribute("scale")));
                }
            } else if (childName.equals("null-value")) {
                String value = ((Element)child).getAttribute("value");
                scalarField.setNullValue(value);
            }
            if (!this.logger.isLoggable(BasicLevel.DEBUG)) continue;
            this.logger.log(BasicLevel.DEBUG, (Object)("end   =<" + childName + ">"));
        }
        scalarField.setIsAutoCalculated(Boolean.valueOf(scalarFieldElem.getAttribute("auto-calculated")));
        String status = scalarFieldElem.getAttribute("status");
        if (status == null || status.equals("variable-persistent")) {
            scalarField.setStatus(1);
        } else if (status.equals("constant-persistent")) {
            scalarField.setStatus(2);
        } else if (status.equals("constant-non-persistent")) {
            scalarField.setStatus(3);
        }
    }

    private void processConstantValue(MetaObject mo, Element constantElem) throws PException {
        String fieldName = constantElem.getAttribute("field-name");
        String fieldValue = constantElem.getAttribute("field-value");
        TypedElement te = ((Class)mo).getTypedElement(fieldName);
        if (te != null) {
            if (!(te instanceof PrimitiveElement)) {
                throw new PException("Trying to assign a constant value to a non-primitive field " + fieldName);
            }
            PrimitiveElement pe = (PrimitiveElement)te;
            if (!pe.isConstant()) {
                throw new PException("Trying to assign a constant value to a non-constant field " + fieldName);
            }
        }
        if (this.logger.isLoggable(BasicLevel.DEBUG)) {
            this.logger.log(BasicLevel.DEBUG, (Object)("Assign constant value: name=" + fieldName + " / value=" + fieldValue));
        }
        ((Class)mo).setConstantValue(fieldName, fieldValue);
    }

    private void processField(Class clazz, Element fieldElem) {
        String fieldName = fieldElem.getAttribute("name");
        NodeList children = fieldElem.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            String nodeName = child.getNodeName();
            if (nodeName.equals("primitive-type")) {
                if (this.logger.isLoggable(BasicLevel.DEBUG)) {
                    this.logger.log(BasicLevel.DEBUG, (Object)("begin =<" + nodeName + ">"));
                }
                PrimitiveElement pe = clazz.createPrimitiveElement(fieldName, this.getPType(((Element)child).getAttribute("type")), Integer.parseInt(((Element)child).getAttribute("size")), Integer.parseInt(((Element)child).getAttribute("scale")));
                pe.setIsAutoCalculated(Boolean.valueOf(((Element)child).getAttribute("auto-calculated")));
                String status = fieldElem.getAttribute("status");
                if (status == null || status.equals("variable-persistent")) {
                    pe.setStatus(1);
                } else if (status.equals("constant-persistent")) {
                    pe.setStatus(2);
                } else if (status.equals("constant-non-persistent")) {
                    pe.setStatus(3);
                }
                if (!this.logger.isLoggable(BasicLevel.DEBUG)) continue;
                this.logger.log(BasicLevel.DEBUG, (Object)("end   =<" + nodeName + ">"));
                continue;
            }
            if (nodeName.equals("class-ref")) {
                if (this.logger.isLoggable(BasicLevel.DEBUG)) {
                    this.logger.log(BasicLevel.DEBUG, (Object)("begin =<" + nodeName + ">"));
                }
                this.processClassRef(clazz, (Element)child);
                if (!this.logger.isLoggable(BasicLevel.DEBUG)) continue;
                this.logger.log(BasicLevel.DEBUG, (Object)("end   =<" + nodeName + ">"));
                continue;
            }
            if (!nodeName.equals("gen-class-ref")) continue;
            if (this.logger.isLoggable(BasicLevel.DEBUG)) {
                this.logger.log(BasicLevel.DEBUG, (Object)("begin =<" + nodeName + ">"));
            }
            this.processGenClassRef(clazz, (Element)child);
            if (!this.logger.isLoggable(BasicLevel.DEBUG)) continue;
            this.logger.log(BasicLevel.DEBUG, (Object)("end   =<" + nodeName + ">"));
        }
    }

    private Class getReferencedClass(MetaObject mo, Element classRefElem) {
        String fqClassName = classRefElem.getAttribute("class-name");
        Class aClass = this.metaInfoManager.getClass(fqClassName);
        if (aClass == null) {
            aClass = this.metaInfoManager.createClass(fqClassName);
            this.undefinedMO.add(aClass);
        }
        return aClass;
    }

    private void processClassRef(MetaObject mo, Element classRefElem) {
        Class referencedClass = this.getReferencedClass(mo, classRefElem);
        ClassRef classRef = null;
        if (mo instanceof Class) {
            Node fieldNode = classRefElem.getParentNode();
            String fieldName = ((Element)fieldNode).getAttribute("name");
            classRef = ((Class)mo).createClassRef(fieldName, referencedClass);
        } else if (mo instanceof GenClassRef) {
            classRef = ((GenClassRef)mo).createClassRef(referencedClass);
        }
        NodeList children = classRefElem.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            String childName = child.getNodeName();
            if (!childName.equals("name-def")) continue;
            if (this.logger.isLoggable(BasicLevel.DEBUG)) {
                this.logger.log(BasicLevel.DEBUG, (Object)("begin =<" + childName + ">"));
            }
            NameDef nameDef = classRef.createRefNameDef();
            this.processNameDef(nameDef, (Element)child);
            if (!this.logger.isLoggable(BasicLevel.DEBUG)) continue;
            this.logger.log(BasicLevel.DEBUG, (Object)("begin =<" + childName + ">"));
        }
    }

    private void processFieldRef(Reference mo, Element refTypeElem) {
        Node fieldRefNode = refTypeElem.getNextSibling();
        if (fieldRefNode != null) {
            String fieldRefNodeName = fieldRefNode.getNodeName();
            if (this.logger.isLoggable(BasicLevel.DEBUG)) {
                this.logger.log(BasicLevel.DEBUG, (Object)("begin =<" + fieldRefNodeName + ">"));
            }
            if (this.logger.isLoggable(BasicLevel.DEBUG)) {
                this.logger.log(BasicLevel.DEBUG, (Object)("end   =<" + fieldRefNodeName + ">"));
            }
        }
    }

    private PType getPType(String name) {
        if (name.equals(PTypeSpace.BOOLEAN.getJormName())) {
            return PTypeSpace.BOOLEAN;
        }
        if (name.equals(PTypeSpace.OBJBOOLEAN.getJormName())) {
            return PTypeSpace.OBJBOOLEAN;
        }
        if (name.equals(PTypeSpace.OBJCHAR.getJormName()) || name.equals("Character")) {
            return PTypeSpace.OBJCHAR;
        }
        if (name.equals(PTypeSpace.CHAR.getJormName())) {
            return PTypeSpace.CHAR;
        }
        if (name.equals(PTypeSpace.OBJBYTE.getJormName())) {
            return PTypeSpace.OBJBYTE;
        }
        if (name.equals(PTypeSpace.BYTE.getJormName())) {
            return PTypeSpace.BYTE;
        }
        if (name.equals(PTypeSpace.OBJSHORT.getJormName())) {
            return PTypeSpace.OBJSHORT;
        }
        if (name.equals(PTypeSpace.SHORT.getJormName())) {
            return PTypeSpace.SHORT;
        }
        if (name.equals(PTypeSpace.OBJINT.getJormName()) || name.equals("Integer")) {
            return PTypeSpace.OBJINT;
        }
        if (name.equals(PTypeSpace.INT.getJormName())) {
            return PTypeSpace.INT;
        }
        if (name.equals(PTypeSpace.OBJLONG.getJormName())) {
            return PTypeSpace.OBJLONG;
        }
        if (name.equals(PTypeSpace.LONG.getJormName())) {
            return PTypeSpace.LONG;
        }
        if (name.equals(PTypeSpace.OBJFLOAT.getJormName())) {
            return PTypeSpace.OBJFLOAT;
        }
        if (name.equals(PTypeSpace.FLOAT.getJormName())) {
            return PTypeSpace.FLOAT;
        }
        if (name.equals(PTypeSpace.OBJDOUBLE.getJormName())) {
            return PTypeSpace.OBJDOUBLE;
        }
        if (name.equals(PTypeSpace.DOUBLE.getJormName())) {
            return PTypeSpace.DOUBLE;
        }
        if (name.equals(PTypeSpace.STRING.getJormName()) || name.equals("String")) {
            return PTypeSpace.STRING;
        }
        if (name.equals(PTypeSpace.DATE.getJormName()) || name.equals("Date")) {
            return PTypeSpace.DATE;
        }
        if (name.equals(PTypeSpace.SERIALIZED.getJormName()) || name.equals("Serializable")) {
            return PTypeSpace.SERIALIZED;
        }
        if (name.equals(PTypeSpace.BYTEARRAY.getJormName())) {
            return PTypeSpace.BYTEARRAY;
        }
        if (name.equals(PTypeSpace.CHARARRAY.getJormName())) {
            return PTypeSpace.CHARARRAY;
        }
        if (name.equals(PTypeSpace.BIGINTEGER.getJormName())) {
            return PTypeSpace.BIGINTEGER;
        }
        if (name.equals(PTypeSpace.BIGDECIMAL.getJormName())) {
            return PTypeSpace.BIGDECIMAL;
        }
        this.logger.log(BasicLevel.ERROR, (Object)("Invalid type name: " + name));
        return null;
    }

    private void processNameDef(NameDef nameDef, Element nameDefElem) {
        String name = nameDefElem.getAttribute("name");
        nameDef.setName(name);
        NodeList children = nameDefElem.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            CompositeName aCompositeName;
            Node child = children.item(i);
            String childName = child.getNodeName();
            if (childName.equals("system")) {
                if (this.logger.isLoggable(BasicLevel.DEBUG)) {
                    this.logger.log(BasicLevel.DEBUG, (Object)("begin =<" + childName + ">"));
                }
                nameDef.setSystem(true);
                if (!this.logger.isLoggable(BasicLevel.DEBUG)) continue;
                this.logger.log(BasicLevel.DEBUG, (Object)("end   =<" + childName + ">"));
                continue;
            }
            if (childName.equals("field-ref")) {
                if (this.logger.isLoggable(BasicLevel.DEBUG)) {
                    this.logger.log(BasicLevel.DEBUG, (Object)("begin =<" + childName + ">"));
                }
                String fieldName = ((Element)child).getAttribute("field-name");
                nameDef.setFieldName(fieldName);
                if (!this.logger.isLoggable(BasicLevel.DEBUG)) continue;
                this.logger.log(BasicLevel.DEBUG, (Object)("end   =<" + childName + ">"));
                continue;
            }
            if (!childName.equals("composite-name-ref")) continue;
            if (this.logger.isLoggable(BasicLevel.DEBUG)) {
                this.logger.log(BasicLevel.DEBUG, (Object)("begin =<" + childName + ">"));
            }
            String fqCN_Name = ((Element)child).getAttribute("composite-name-name");
            if (this.logger.isLoggable(BasicLevel.DEBUG)) {
                this.logger.log(BasicLevel.DEBUG, (Object)("composite-name-ref composite-name-name =<" + fqCN_Name + ">"));
            }
            int lastindexofpoint = fqCN_Name.lastIndexOf(46);
            String CN_Name = null;
            Package CN_Schema = null;
            if (lastindexofpoint != -1) {
                String schemaName = fqCN_Name.substring(0, fqCN_Name.lastIndexOf(46));
                CN_Schema = this.metaInfoManager.createPackage(schemaName);
                CN_Name = fqCN_Name.substring(fqCN_Name.lastIndexOf(46) + 1, fqCN_Name.length());
            } else {
                MetaObject tmp = nameDef.getParent();
                while (!(tmp instanceof Package)) {
                    tmp = tmp.getParent();
                }
                CN_Schema = (Package)tmp;
                this.logger.log(BasicLevel.WARN, (Object)("Be careful, the name of package (Package name) is not specified, continue with " + CN_Schema.getName() + " schema."));
                CN_Name = fqCN_Name;
            }
            if (this.logger.isLoggable(BasicLevel.DEBUG)) {
                this.logger.log(BasicLevel.DEBUG, (Object)("schema name =<" + CN_Schema.getName() + ">"));
            }
            if ((aCompositeName = CN_Schema.getCompositeName(CN_Name)) == null) {
                aCompositeName = CN_Schema.createCompositeName(CN_Name);
                this.undefinedMO.add(aCompositeName);
            }
            NameRef nameRef = nameDef.createNameRef(aCompositeName);
            this.processNameRef(nameRef, (Element)child);
            if (!this.logger.isLoggable(BasicLevel.DEBUG)) continue;
            this.logger.log(BasicLevel.DEBUG, (Object)("end   =<" + childName + ">"));
        }
    }

    private void processNameRef(NameRef nameRef, Element compositeNameRefElem) {
        NodeList children = compositeNameRefElem.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            String nodeName = child.getNodeName();
            if (!nodeName.equals("composite-name-field-projection")) continue;
            if (this.logger.isLoggable(BasicLevel.DEBUG)) {
                this.logger.log(BasicLevel.DEBUG, (Object)("begin =<" + nodeName + ">"));
            }
            String CN_fieldName = ((Element)child).getAttribute("composite-name-field-name");
            String classfieldName = ((Element)child).getAttribute("class-field-name");
            nameRef.addProjection(CN_fieldName, classfieldName);
            if (!this.logger.isLoggable(BasicLevel.DEBUG)) continue;
            this.logger.log(BasicLevel.DEBUG, (Object)("end   =<" + nodeName + ">"));
        }
    }

    private void processGenClassRef(MetaObject mo, Element genClassRefElem) {
        NodeList children = genClassRefElem.getChildNodes();
        Reference genClassRef = null;
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            String childName = child.getNodeName();
            if (childName.equals("gen-class")) {
                if (this.logger.isLoggable(BasicLevel.DEBUG)) {
                    this.logger.log(BasicLevel.DEBUG, (Object)("begin =<" + childName + ">"));
                }
                String genClassName = ((Element)child).getAttribute("gen-class-name");
                if (mo instanceof Class) {
                    Node fieldNode = genClassRefElem.getParentNode();
                    String fieldName = ((Element)fieldNode).getAttribute("name");
                    genClassRef = ((Class)mo).createGenClassRef(fieldName, genClassName);
                } else if (mo instanceof GenClassRef) {
                    genClassRef = ((GenClassRef)mo).createGenClassRef(genClassName);
                }
                this.idvalue2genclassref.put(genClassRef.getGenClassId(), genClassRef);
                if (this.logger.isLoggable(BasicLevel.DEBUG)) {
                    this.logger.log(BasicLevel.DEBUG, (Object)("genclass id =<" + genClassRef.getGenClassId() + ">"));
                }
                this.processGenClass((GenClassRef)genClassRef, (Element)child);
                if (!this.logger.isLoggable(BasicLevel.DEBUG)) continue;
                this.logger.log(BasicLevel.DEBUG, (Object)("end   =<" + childName + ">"));
                continue;
            }
            if (!childName.equals("name-def")) continue;
            if (this.logger.isLoggable(BasicLevel.DEBUG)) {
                this.logger.log(BasicLevel.DEBUG, (Object)("begin =<" + childName + ">"));
            }
            NameDef nameDef = genClassRef.createRefNameDef();
            this.processNameDef(nameDef, (Element)child);
            if (!this.logger.isLoggable(BasicLevel.DEBUG)) continue;
            this.logger.log(BasicLevel.DEBUG, (Object)("end   =<" + childName + ">"));
        }
    }

    private void processGenClass(GenClassRef genClassRef, Element genClassElem) {
        NodeList children = genClassElem.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            String childName = child.getNodeName();
            if (this.logger.isLoggable(BasicLevel.DEBUG)) {
                this.logger.log(BasicLevel.DEBUG, (Object)("begin =<" + childName + ">"));
            }
            if (childName.equals("scalar-field")) {
                this.processScalarField(genClassRef, (Element)child);
            } else if (childName.equals("name-def")) {
                NameDef nameDef = genClassRef.createIdNameDef();
                this.processNameDef(nameDef, (Element)child);
            } else if (childName.equals("index")) {
                this.processIndex(genClassRef, (Element)child);
            } else if (childName.equals("primitive-type")) {
                genClassRef.createPrimitiveElement(this.getPType(((Element)child).getAttribute("type")), Integer.parseInt(((Element)child).getAttribute("size")), Integer.parseInt(((Element)child).getAttribute("scale")));
            } else if (childName.equals("class-ref")) {
                this.processClassRef(genClassRef, (Element)child);
            } else if (childName.equals("gen-class-ref")) {
                this.processClassRef(genClassRef, (Element)child);
            }
            if (!this.logger.isLoggable(BasicLevel.DEBUG)) continue;
            this.logger.log(BasicLevel.DEBUG, (Object)("end   =<" + childName + ">"));
        }
    }

    private void processIndex(GenClassRef genClassRef, Element indexElem) {
        NodeList children = indexElem.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            String childName = child.getNodeName();
            if (this.logger.isLoggable(BasicLevel.DEBUG)) {
                this.logger.log(BasicLevel.DEBUG, (Object)("begin =<" + childName + ">"));
            }
            if (childName.equals("field-ref")) {
                genClassRef.addIndexField(((Element)child).getAttribute("field-name"));
            }
            if (!this.logger.isLoggable(BasicLevel.DEBUG)) continue;
            this.logger.log(BasicLevel.DEBUG, (Object)("end   =<" + childName + ">"));
        }
    }

    public void parseMapping(Element mappingElem, ClassProject classProject) throws PException {
        NodeList nodes = mappingElem.getChildNodes();
        MappingParser mp = null;
        Mapping mapping = null;
        String mapperName = null;
        boolean parseOn = false;
        for (int i = 0; i < nodes.getLength(); ++i) {
            int pos;
            Node child = nodes.item(i);
            String childName = child.getNodeName();
            if (this.logger.isLoggable(BasicLevel.DEBUG)) {
                this.logger.log(BasicLevel.DEBUG, (Object)("begin =<" + childName + ">"));
            }
            if ((pos = childName.indexOf("-")) == -1 || classProject.getMapping(mapperName = childName.substring(0, pos)) != null && !parseOn) continue;
            parseOn = true;
            mp = this.getMappingParser(mapperName);
            if (mp == null) {
                if (!this.logger.isLoggable(BasicLevel.DEBUG)) continue;
                this.logger.log(BasicLevel.DEBUG, (Object)"cannot get the mapping parser!");
                continue;
            }
            mp.setPathExplorer(this.pathExplorer);
            ((Loggable)((Object)mp)).setLogger(this.logger);
            mp.setMetaInfoManager(this.metaInfoManager);
            mp.setidvalue2genclassref(this.idvalue2genclassref);
            mp.setCurrentClass((Class)classProject.getParent());
            mp.setmotable(this.motable);
            mapping = classProject.createMapping(mapperName);
            if (this.logger.isLoggable(BasicLevel.DEBUG)) {
                this.logger.log(BasicLevel.DEBUG, (Object)("current class =<" + ((Class)classProject.getParent()).getName() + ">"));
                this.logger.log(BasicLevel.DEBUG, (Object)("current project =<" + classProject.getProjectName() + ">"));
                this.logger.log(BasicLevel.DEBUG, (Object)("current mapping =<" + mapping.getMapperName() + ">"));
            }
            if (mapping instanceof Loggable) {
                if (this.loggerFactory != null) {
                    ((Loggable)((Object)mapping)).setLoggerFactory(this.loggerFactory);
                } else if (this.logger != null) {
                    ((Loggable)((Object)mapping)).setLogger(this.logger);
                }
            }
            mp.parseMapping((Element)child, mapping);
            if (!this.logger.isLoggable(BasicLevel.DEBUG)) continue;
            this.logger.log(BasicLevel.DEBUG, (Object)("end   =<" + childName + ">"));
        }
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
        if (this.resolver != null) {
            this.resolver.setLogger(logger);
        }
    }

    private void addImplicitMappings(Class clazz, Set handledClasses) {
        Iterator itSuperClass = clazz.getSuperClasses().iterator();
        while (itSuperClass.hasNext()) {
            Class superClass = (Class)itSuperClass.next();
            if (!handledClasses.contains(superClass)) {
                this.addImplicitMappings(superClass, handledClasses);
            }
            Iterator itProject = superClass.getClassProjects().iterator();
            while (itProject.hasNext()) {
                ClassProject superClassProject = (ClassProject)itProject.next();
                ClassProject classProject = clazz.getClassProject(superClassProject.getProjectName());
                if (classProject == null) {
                    classProject = clazz.createClassProject(superClassProject.getProjectName());
                    this.logger.log(BasicLevel.DEBUG, (Object)("Create implicit class project " + clazz.getName() + "<" + classProject.getProjectName() + ">"));
                }
                Iterator itMapping = superClassProject.getMappings().iterator();
                while (itMapping.hasNext()) {
                    ParentClassMapping pm;
                    ClassMapping classMapping;
                    Mapping superMapping = (Mapping)itMapping.next();
                    Mapping mapping = classProject.getMapping(superMapping.getMapperName());
                    if (mapping == null) {
                        mapping = classProject.createMapping(superMapping.getMapperName());
                        classMapping = mapping.createClassMapping("");
                        this.logger.log(BasicLevel.DEBUG, (Object)("Create implicit mapping & class mapping " + clazz.getName() + "<" + classMapping.getProjectName() + "," + classMapping.getMapperName() + ">"));
                    } else {
                        classMapping = mapping.getClassMapping();
                    }
                    IdentifierMapping id = classMapping.getIdentifierMapping();
                    if (id == null) {
                        this.logger.log(BasicLevel.DEBUG, (Object)("Create implicit id mapping " + clazz.getName() + "<" + classMapping.getProjectName() + "," + classMapping.getMapperName() + "> from IM of " + superClass.getName()));
                        classMapping.createIdentifierMapping((NameDef)superMapping.getClassMapping().getIdentifierMapping().getLinkedMO());
                    }
                    if ((pm = classMapping.getParentClassMapping(superClass.getFQName())) != null) continue;
                    pm = classMapping.createImplicitParentClassMapping(superClass);
                    this.logger.log(BasicLevel.DEBUG, (Object)("Create implicit parent class mapping " + clazz.getName() + "<" + classMapping.getProjectName() + "," + classMapping.getMapperName() + "> to " + superClass.getName()));
                }
            }
        }
    }

    private void addImplicitDependencies(Class clazz) {
        Iterator itProject = clazz.getClassProjects().iterator();
        while (itProject.hasNext()) {
            ClassProject classProject = (ClassProject)itProject.next();
            Iterator itMapping = classProject.getMappings().iterator();
            while (itMapping.hasNext()) {
                Mapping mapping = (Mapping)itMapping.next();
                ClassMapping classMapping = mapping.getClassMapping();
                classMapping.addImplicitDependencies();
            }
        }
    }
}

