/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.medor.expression.lib;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;
import org.objectweb.jorm.type.api.PType;
import org.objectweb.medor.expression.api.BinaryArithmeticOperator;
import org.objectweb.medor.expression.api.Expression;
import org.objectweb.medor.expression.api.ExpressionException;
import org.objectweb.medor.expression.api.MalformedExpressionException;
import org.objectweb.medor.expression.api.Operand;
import org.objectweb.medor.expression.api.ParameterOperand;
import org.objectweb.medor.expression.api.TypingException;
import org.objectweb.medor.expression.lib.BasicBinaryOperator;
import org.objectweb.medor.expression.lib.BasicVariableOperand;
import org.objectweb.medor.expression.type.ExpressionTypeHelper;

public abstract class BasicBinaryArithmeticOperator
extends BasicBinaryOperator
implements BinaryArithmeticOperator {
    public BasicBinaryArithmeticOperator() {
    }

    public BasicBinaryArithmeticOperator(Expression e0, Expression e1) {
        super(e0, e1);
    }

    public BasicBinaryArithmeticOperator(PType type) {
        super(type);
    }

    public BasicBinaryArithmeticOperator(PType type, Expression e0, Expression e1) {
        super(type, e0, e1);
    }

    public Operand evaluate(ParameterOperand[] pos, Object o) throws ExpressionException {
        try {
            this.expressions[1].evaluate(pos, o);
            switch (this.type.getTypeCode()) {
                case 2: 
                case 10: {
                    this.result.setValue(this.evaluate((int)this.expressions[0].evaluate(pos, o).getByte(), (short)this.expressions[1].evaluate(pos, o).getByte()));
                    break;
                }
                case 1: 
                case 9: {
                    this.result.setValue(this.evaluate(this.expressions[0].evaluate(pos, o).getChar(), this.expressions[1].evaluate(pos, o).getChar()));
                    break;
                }
                case 3: 
                case 11: {
                    this.result.setValue(this.evaluate((int)this.expressions[0].evaluate(pos, o).getShort(), this.expressions[1].evaluate(pos, o).getShort()));
                    break;
                }
                case 4: 
                case 12: {
                    this.result.setValue(this.evaluate(this.expressions[0].evaluate(pos, o).getInt(), this.expressions[1].evaluate(pos, o).getInt()));
                    break;
                }
                case 5: 
                case 13: {
                    this.result.setValue(this.evaluate(this.expressions[0].evaluate(pos, o).getLong(), this.expressions[1].evaluate(pos, o).getLong()));
                    break;
                }
                case 6: 
                case 14: {
                    this.result.setValue(this.evaluate(this.expressions[0].evaluate(pos, o).getFloat(), this.expressions[1].evaluate(pos, o).getFloat()));
                    break;
                }
                case 7: 
                case 15: {
                    this.result.setValue(this.evaluate(this.expressions[0].evaluate(pos, o).getDouble(), this.expressions[1].evaluate(pos, o).getDouble()));
                    break;
                }
                case 16: {
                    this.result.setValue(this.evaluate(this.expressions[0].evaluate(pos, o).getString(), this.expressions[1].evaluate(pos, o).getString()));
                    break;
                }
                case 22: {
                    this.result.setValue(this.evaluate(this.expressions[0].evaluate(pos, o).getBigDecimal(), this.expressions[1].evaluate(pos, o).getBigDecimal()));
                    break;
                }
                case 21: {
                    this.result.setValue(this.evaluate(this.expressions[0].evaluate(pos, o).getBigInteger(), this.expressions[1].evaluate(pos, o).getBigInteger()));
                    break;
                }
                default: {
                    throw new TypingException("Incompatible type");
                }
            }
        }
        catch (NullPointerException e) {
            throw new IllegalStateException("Unevaluable Expression: Not compiled");
        }
        return this.result;
    }

    public abstract int evaluate(int var1, int var2);

    public abstract int evaluate(int var1, short var2);

    public abstract long evaluate(int var1, long var2);

    public abstract float evaluate(int var1, float var2);

    public abstract double evaluate(int var1, double var2);

    public abstract float evaluate(float var1, float var2);

    public abstract float evaluate(float var1, short var2);

    public abstract float evaluate(float var1, int var2);

    public abstract float evaluate(float var1, long var2);

    public abstract double evaluate(float var1, double var2);

    public abstract int evaluate(char var1, char var2) throws TypingException;

    public abstract String evaluate(char var1, String var2) throws TypingException;

    public abstract long evaluate(long var1, long var3);

    public abstract long evaluate(long var1, short var3);

    public abstract long evaluate(long var1, int var3);

    public abstract float evaluate(long var1, float var3);

    public abstract double evaluate(long var1, double var3);

    public abstract double evaluate(double var1, double var3);

    public abstract double evaluate(double var1, short var3);

    public abstract double evaluate(double var1, int var3);

    public abstract double evaluate(double var1, float var3);

    public abstract double evaluate(double var1, long var3);

    public abstract BigDecimal evaluate(BigDecimal var1, BigDecimal var2);

    public abstract BigInteger evaluate(BigInteger var1, BigInteger var2);

    public abstract String evaluate(String var1, String var2) throws TypingException;

    public abstract String evaluate(String var1, char var2) throws TypingException;

    public abstract Date evaluate(Date var1, Date var2) throws TypingException;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Operand compileExpression() throws ExpressionException, MalformedExpressionException {
        this.compileOperands();
        if (this.expressions[0] == null || this.expressions[1] == null) throw new MalformedExpressionException("null children value");
        if (this.expressions[0].getType() == null || this.expressions[1].getType() == null) throw new MalformedExpressionException("null children value");
        if (!ExpressionTypeHelper.isArithmeticType(this.expressions[0].getType()) || !ExpressionTypeHelper.isArithmeticType(this.expressions[1].getType())) {
            throw new TypingException("Attempt an aritmetic type " + this.expressions[0].getType().getJavaName() + "  " + this.expressions[1].getType().getJavaName());
        }
        this.type = this.expressions[0].getType().isa(this.expressions[1].getType()) ? this.expressions[1].getType() : this.expressions[0].getType();
        this.result = new BasicVariableOperand(this.type);
        this.verified = true;
        return this.result;
    }
}

