/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.medor.expression.lib;

import org.objectweb.jorm.type.api.PType;
import org.objectweb.jorm.type.api.PTypeSpace;
import org.objectweb.medor.expression.api.Comparator;
import org.objectweb.medor.expression.api.Expression;
import org.objectweb.medor.expression.api.ExpressionException;
import org.objectweb.medor.expression.api.MalformedExpressionException;
import org.objectweb.medor.expression.api.Operand;
import org.objectweb.medor.expression.api.ParameterOperand;
import org.objectweb.medor.expression.api.TypingException;
import org.objectweb.medor.expression.lib.BasicBinaryOperator;
import org.objectweb.medor.expression.lib.BasicVariableOperand;
import org.objectweb.medor.expression.type.ExpressionTypeHelper;

public abstract class BasicComparator
extends BasicBinaryOperator
implements Comparator {
    public BasicComparator() {
        super(PTypeSpace.BOOLEAN);
    }

    public BasicComparator(Expression e0, Expression e1) {
        super(PTypeSpace.BOOLEAN, e0, e1);
    }

    public Operand evaluate(ParameterOperand[] pos, Object o) throws ExpressionException {
        Operand leftResult = this.expressions[0].evaluate(pos, o);
        Operand rightResult = this.expressions[1].evaluate(pos, o);
        PType rtype = ExpressionTypeHelper.getResultType(this.expressions[0].getType(), this.expressions[1].getType());
        switch (rtype.getTypeCode()) {
            case 0: {
                this.result.setValue(this.evaluate(leftResult.getBoolean(), rightResult.getBoolean()));
                break;
            }
            case 2: {
                this.result.setValue(this.evaluate((int)leftResult.getByte(), (short)rightResult.getByte()));
                break;
            }
            case 1: {
                this.result.setValue(this.evaluate(leftResult.getChar(), rightResult.getChar()));
                break;
            }
            case 3: {
                this.result.setValue(this.evaluate((int)leftResult.getShort(), rightResult.getShort()));
                break;
            }
            case 4: {
                this.result.setValue(this.evaluate(leftResult.getInt(), rightResult.getInt()));
                break;
            }
            case 5: {
                this.result.setValue(this.evaluate(leftResult.getLong(), rightResult.getLong()));
                break;
            }
            case 6: {
                this.result.setValue(this.evaluate(leftResult.getFloat(), rightResult.getFloat()));
                break;
            }
            case 7: {
                this.result.setValue(this.evaluate(leftResult.getDouble(), rightResult.getDouble()));
                break;
            }
            case 16: {
                this.result.setValue(this.evaluate(leftResult.getString(), rightResult.getString()));
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 21: 
            case 22: {
                this.result.setValue(this.evaluate(leftResult.getObject(), rightResult.getObject()));
                break;
            }
            default: {
                throw new TypingException("Unmanaged the type: ( typeCode: " + rtype.getTypeCode() + " jormName: " + rtype.getJormName() + " javaName: " + rtype.getJavaName() + ") this=" + this);
            }
        }
        return this.result;
    }

    public abstract boolean evaluate(Object var1, Object var2);

    public abstract boolean evaluate(int var1, int var2);

    public abstract boolean evaluate(int var1, short var2);

    public abstract boolean evaluate(int var1, long var2);

    public abstract boolean evaluate(int var1, float var2);

    public abstract boolean evaluate(int var1, double var2);

    public abstract boolean evaluate(float var1, float var2);

    public abstract boolean evaluate(float var1, short var2);

    public abstract boolean evaluate(float var1, int var2);

    public abstract boolean evaluate(float var1, long var2);

    public abstract boolean evaluate(float var1, double var2);

    public abstract boolean evaluate(char var1, char var2);

    public abstract boolean evaluate(long var1, long var3);

    public abstract boolean evaluate(long var1, float var3);

    public abstract boolean evaluate(long var1, double var3);

    public abstract boolean evaluate(double var1, double var3);

    public abstract boolean evaluate(double var1, short var3);

    public abstract boolean evaluate(double var1, int var3);

    public abstract boolean evaluate(double var1, float var3);

    public abstract boolean evaluate(double var1, long var3);

    public abstract boolean evaluate(String var1, String var2);

    public abstract boolean evaluate(boolean var1, boolean var2);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Operand compileExpression() throws ExpressionException, MalformedExpressionException {
        this.compileOperands();
        if (this.expressions[0] == null || this.expressions[1] == null) throw new MalformedExpressionException("Null children value in Expression");
        if (this.expressions[0].getType() == null || this.expressions[1].getType() == null) throw new MalformedExpressionException("Null children value in Expression");
        if ((!ExpressionTypeHelper.isArithmeticType(this.expressions[0].getType()) || !ExpressionTypeHelper.isArithmeticType(this.expressions[1].getType())) && this.expressions[0].getType().getTypeCode() != this.expressions[1].getType().getTypeCode()) throw new TypingException("Attempt an aritmetic type on a non arithmetic type");
        if (!this.expressions[0].getType().isa(this.expressions[1].getType()) && !this.expressions[1].getType().isa(this.expressions[0].getType())) {
            throw new TypingException("incompatible types");
        }
        this.result = new BasicVariableOperand(PTypeSpace.BOOLEAN);
        this.verified = true;
        return this.result;
    }
}

