/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.medor.expression.lib;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;
import java.util.Map;
import org.objectweb.jorm.type.api.PType;
import org.objectweb.jorm.type.api.PTypeSpace;
import org.objectweb.medor.expression.api.ExpressionException;
import org.objectweb.medor.expression.api.Operand;
import org.objectweb.medor.expression.api.ParameterOperand;
import org.objectweb.medor.expression.api.TypingException;
import org.objectweb.medor.expression.lib.BasicExpression;

public class BasicOperand
extends BasicExpression
implements Operand {
    private static final long serialVersionUID = 4221478892097356192L;
    protected long longValue;
    protected double doubleValue;
    protected Object objectValue;
    protected boolean isDefined = true;

    public BasicOperand() {
    }

    public BasicOperand(BasicOperand bo) {
        super(bo);
        this.longValue = bo.longValue;
        this.doubleValue = bo.doubleValue;
        this.objectValue = bo.objectValue;
        this.isDefined = bo.isDefined;
    }

    protected BasicOperand(PType p) {
        super(p);
    }

    public BasicOperand(boolean p) {
        super(PTypeSpace.BOOLEAN);
        this.longValue = p ? 1 : 0;
        this.doubleValue = p ? 1 : 0;
    }

    public BasicOperand(char p) {
        super(PTypeSpace.CHAR);
        this.longValue = p;
        this.doubleValue = p;
    }

    public BasicOperand(char[] p) {
        super(PTypeSpace.CHARARRAY);
        this.objectValue = p;
    }

    public BasicOperand(byte p) {
        super(PTypeSpace.BYTE);
        this.longValue = p;
        this.doubleValue = p;
    }

    public BasicOperand(byte[] p) {
        super(PTypeSpace.BYTEARRAY);
        this.objectValue = p;
    }

    public BasicOperand(short p) {
        super(PTypeSpace.SHORT);
        this.longValue = p;
        this.doubleValue = p;
    }

    public BasicOperand(int p) {
        super(PTypeSpace.INT);
        this.longValue = p;
        this.doubleValue = p;
    }

    public BasicOperand(long p) {
        super(PTypeSpace.LONG);
        this.longValue = p;
        this.doubleValue = p;
    }

    public BasicOperand(float p) {
        super(PTypeSpace.FLOAT);
        this.doubleValue = p;
    }

    public BasicOperand(double p) {
        super(PTypeSpace.DOUBLE);
        this.doubleValue = p;
    }

    public BasicOperand(String p) {
        super(PTypeSpace.STRING);
        this.objectValue = p;
    }

    public BasicOperand(Date p) {
        super(PTypeSpace.DATE);
        this.objectValue = p;
    }

    public BasicOperand(Object p, PType type) {
        super(type);
        this.objectValue = p;
        switch (type.getTypeCode()) {
            case 0: {
                this.longValue = (Boolean)p != false ? 1L : 0L;
                this.doubleValue = this.longValue;
                break;
            }
            case 2: {
                this.longValue = ((Byte)p).byteValue();
                this.doubleValue = this.longValue;
                break;
            }
            case 3: {
                this.longValue = ((Short)p).shortValue();
                this.doubleValue = this.longValue;
                break;
            }
            case 4: {
                this.longValue = ((Integer)p).intValue();
                this.doubleValue = this.longValue;
                break;
            }
            case 5: {
                this.longValue = ((Long)p).intValue();
                this.doubleValue = this.longValue;
                break;
            }
            case 1: {
                this.longValue = ((Character)p).charValue();
                this.doubleValue = this.longValue;
                break;
            }
            case 6: {
                this.doubleValue = ((Float)p).floatValue();
                break;
            }
            case 7: {
                this.doubleValue = (Double)p;
            }
        }
    }

    public Object clone(Object clone, Map obj2clone) throws CloneNotSupportedException {
        clone = super.clone(clone, obj2clone);
        BasicOperand bo = (BasicOperand)clone;
        bo.longValue = this.longValue;
        bo.doubleValue = this.doubleValue;
        bo.objectValue = this.objectValue;
        bo.type = this.type;
        bo.isDefined = this.isDefined;
        return clone;
    }

    public String getValueAsString() {
        if (this.type == null) {
            if (this.objectValue == null) {
                return "";
            }
            return this.objectValue.toString();
        }
        switch (this.type.getTypeCode()) {
            case 0: {
                return "" + (this.longValue == 1L);
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                return "" + this.longValue;
            }
            case 1: {
                return new Character((char)this.longValue).toString();
            }
            case 6: 
            case 7: {
                return "" + this.doubleValue;
            }
        }
        return this.objectValue == null ? null : this.objectValue.toString();
    }

    public String toString() {
        return this.getValueAsString();
    }

    public Operand evaluate(ParameterOperand[] pos, Object o) throws ExpressionException {
        return this;
    }

    public PType getType() {
        return this.type;
    }

    public boolean isDefined() {
        return this.isDefined;
    }

    public void setIsDefined(boolean isdefined) {
        this.isDefined = isdefined;
    }

    public boolean getBoolean() throws TypingException {
        if (this.type.getTypeCode() == 0) {
            return this.longValue == 1L;
        }
        if (this.type.getTypeCode() == 8 && (this.objectValue == null || this.objectValue instanceof Boolean)) {
            return this.objectValue != null && (Boolean)this.objectValue != false;
        }
        throw new TypingException("Can not get a boolean value");
    }

    public int getInt() throws TypingException {
        if (this.type.getTypeCode() == 4) {
            return (int)this.longValue;
        }
        if (this.type.getTypeCode() == 12 && (this.objectValue == null || this.objectValue instanceof Integer)) {
            return this.objectValue == null ? -1 : (Integer)this.objectValue;
        }
        throw new TypingException("Can not get an integer value " + this.type.getTypeCode());
    }

    public byte getByte() throws TypingException {
        if (this.type.getTypeCode() == 2) {
            return (byte)this.longValue;
        }
        if (this.type.getTypeCode() == 10 && (this.objectValue == null || this.objectValue instanceof Byte)) {
            return this.objectValue == null ? (byte)-1 : (Byte)this.objectValue;
        }
        throw new TypingException("Can not get a byte value");
    }

    public byte[] getByteArray() throws TypingException {
        if (this.type.getTypeCode() == 19) {
            return (byte[])this.objectValue;
        }
        throw new TypingException("Can not get a byteArray value");
    }

    public short getShort() throws TypingException {
        if (this.type.getTypeCode() == 3) {
            return (short)this.longValue;
        }
        if (this.type.getTypeCode() == 11 && (this.objectValue == null || this.objectValue instanceof Short)) {
            return this.objectValue == null ? (short)-1 : (Short)this.objectValue;
        }
        throw new TypingException("Can not get a short value");
    }

    public long getLong() throws TypingException {
        if (this.type.getTypeCode() == 5) {
            return this.longValue;
        }
        if (this.type.getTypeCode() == 13 && (this.objectValue == null || this.objectValue instanceof Long)) {
            return this.objectValue == null ? -1L : (Long)this.objectValue;
        }
        throw new TypingException("Can not get a long value");
    }

    public float getFloat() throws TypingException {
        if (this.type.getTypeCode() == 6) {
            return (float)this.doubleValue;
        }
        if (this.type.getTypeCode() == 14 && (this.objectValue == null || this.objectValue instanceof Float)) {
            return this.objectValue == null ? -1.0f : ((Float)this.objectValue).floatValue();
        }
        throw new TypingException("Can not get a float value");
    }

    public double getDouble() throws TypingException {
        if (this.type.getTypeCode() == 7) {
            return this.doubleValue;
        }
        if (this.type.getTypeCode() == 15 && (this.objectValue == null || this.objectValue instanceof Double)) {
            return this.objectValue == null ? -1.0 : (Double)this.objectValue;
        }
        throw new TypingException("Can not get a double value " + this.type.getJavaName());
    }

    public char getChar() throws TypingException {
        if (this.type.getTypeCode() == 1) {
            return (char)this.longValue;
        }
        if (this.type.getTypeCode() == 9 && (this.objectValue == null || this.objectValue instanceof Character)) {
            return this.objectValue == null ? (char)'\uffff' : ((Character)this.objectValue).charValue();
        }
        throw new TypingException("Can not get a char value");
    }

    public char[] getCharArray() throws TypingException {
        if (this.type.getTypeCode() == 18) {
            return (char[])this.objectValue;
        }
        throw new TypingException("Can not get a char value");
    }

    public String getString() throws TypingException {
        if (this.type.getTypeCode() == 16 && (this.objectValue == null || this.objectValue instanceof String)) {
            return (String)this.objectValue;
        }
        throw new TypingException("Can not get a string value: " + this.objectValue);
    }

    public BigDecimal getBigDecimal() throws TypingException {
        if (this.type.getTypeCode() == 22 && (this.objectValue == null || this.objectValue instanceof BigDecimal)) {
            return (BigDecimal)this.objectValue;
        }
        throw new TypingException("Can not get a BigDecimal value: " + this.objectValue);
    }

    public BigInteger getBigInteger() throws TypingException {
        if (this.type.getTypeCode() == 21 && (this.objectValue == null || this.objectValue instanceof BigInteger)) {
            return (BigInteger)this.objectValue;
        }
        throw new TypingException("Can not get a BigInteger value: " + this.objectValue);
    }

    public Date getDate() throws TypingException {
        if (this.objectValue == null || this.objectValue instanceof Date) {
            return (Date)this.objectValue;
        }
        throw new TypingException("Can not get a Date value: " + (this.objectValue == null ? "null" : this.objectValue.getClass().getName()));
    }

    public Object getObject() {
        if (this.type == null) {
            return this.objectValue;
        }
        switch (this.type.getTypeCode()) {
            case 0: {
                return new Boolean(this.longValue == 1L);
            }
            case 2: {
                return new Byte((byte)this.longValue);
            }
            case 1: {
                return new Character((char)this.longValue);
            }
            case 7: {
                return new Double(this.longValue);
            }
            case 6: {
                return new Float(this.longValue);
            }
            case 4: {
                return new Integer((int)this.longValue);
            }
            case 5: {
                return new Long(this.longValue);
            }
            case 3: {
                return new Short((short)this.longValue);
            }
        }
        return this.objectValue;
    }

    public Operand compileExpression() {
        return this;
    }
}

