/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.medor.expression.lib;

import org.objectweb.jorm.type.api.PType;
import org.objectweb.medor.expression.api.Expression;
import org.objectweb.medor.expression.api.ExpressionException;
import org.objectweb.medor.expression.api.MalformedExpressionException;
import org.objectweb.medor.expression.api.Operand;
import org.objectweb.medor.expression.api.ParameterOperand;
import org.objectweb.medor.expression.api.TypingException;
import org.objectweb.medor.expression.api.UnaryArithmeticOperator;
import org.objectweb.medor.expression.lib.BasicUnaryOperator;
import org.objectweb.medor.expression.lib.BasicVariableOperand;
import org.objectweb.medor.expression.type.ExpressionTypeHelper;

public abstract class BasicUnaryArithmeticOperator
extends BasicUnaryOperator
implements UnaryArithmeticOperator {
    public BasicUnaryArithmeticOperator() {
    }

    public BasicUnaryArithmeticOperator(PType type) {
        super(type);
    }

    public BasicUnaryArithmeticOperator(Expression e) {
        super(e);
    }

    public BasicUnaryArithmeticOperator(PType type, Expression e) {
        super(type, e);
    }

    public Operand evaluate(ParameterOperand[] pos, Object o) throws ExpressionException {
        if (this.result == null) {
            throw new IllegalStateException("Unevaluable Expression: Not compiled");
        }
        Operand subResult = this.expressions[0].evaluate(pos, o);
        switch (subResult.getType().getTypeCode()) {
            case 7: {
                this.result.setValue(this.evaluate(subResult.getDouble()));
                break;
            }
            case 6: {
                this.result.setValue(this.evaluate(subResult.getFloat()));
                break;
            }
            case 2: {
                this.result.setValue(this.evaluate(subResult.getByte()));
                break;
            }
            case 3: {
                this.result.setValue(this.evaluate(subResult.getShort()));
                break;
            }
            case 4: {
                this.result.setValue(this.evaluate(subResult.getInt()));
                break;
            }
            case 5: {
                this.result.setValue(this.evaluate(subResult.getLong()));
                break;
            }
            default: {
                throw new MalformedExpressionException("Unauthorized expression element");
            }
        }
        return this.result;
    }

    public Operand compileExpression() throws ExpressionException, MalformedExpressionException {
        this.compileOperands();
        if (this.expressions[0] != null) {
            if (!ExpressionTypeHelper.isArithmeticType(this.expressions[0].getType())) {
                throw new TypingException("Attempt an aritmetic type");
            }
        } else {
            throw new MalformedExpressionException("null childeren value");
        }
        this.type = this.expressions[0].getType();
        this.result = new BasicVariableOperand(this.type);
        this.verified = true;
        return this.result;
    }
}

