/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.medor.expression.lib;

import java.util.Map;
import org.objectweb.jorm.type.api.PTypeSpace;
import org.objectweb.medor.expression.api.Expression;
import org.objectweb.medor.expression.api.ExpressionException;
import org.objectweb.medor.expression.api.MalformedExpressionException;
import org.objectweb.medor.expression.api.Operand;
import org.objectweb.medor.expression.api.ParameterOperand;
import org.objectweb.medor.expression.lib.BasicOperator;
import org.objectweb.medor.expression.lib.BasicVariableOperand;

public class Round
extends BasicOperator {
    private static final long serialVersionUID = 383548759848730675L;
    int round = 0;

    public Round() {
        this.expressions = new Expression[1];
    }

    public Round(Expression e) {
        this(e, 0);
    }

    public Round(Expression e, int r) {
        super(new Expression[]{e});
        this.setRound(r);
    }

    public int getRound() {
        return this.round;
    }

    public void setRound(int r) {
        this.round = r;
    }

    public Operand compileExpression() throws ExpressionException, MalformedExpressionException {
        this.type = this.expressions[0].compileExpression().getType();
        switch (this.type.getTypeCode()) {
            case 6: 
            case 7: {
                if (this.round > 0) break;
                this.type = PTypeSpace.LONG;
            }
        }
        this.result = new BasicVariableOperand(this.type);
        return this.result;
    }

    public Operand evaluate(ParameterOperand[] values, Object o) throws ExpressionException {
        Operand sub = this.expressions[0].evaluate(values, o);
        switch (sub.getType().getTypeCode()) {
            case 6: {
                this.result.setValue(Math.round(sub.getFloat()));
                break;
            }
            case 14: {
                Float f = (Float)sub.getObject();
                if (f == null) {
                    this.result.setValue((Object)null);
                    break;
                }
                this.result.setValue((long)Math.round(f.floatValue()));
                break;
            }
            case 7: {
                this.result.setValue(Math.round(sub.getDouble()));
                break;
            }
            case 15: {
                Double d = (Double)sub.getObject();
                if (d == null) {
                    this.result.setValue((Object)null);
                    break;
                }
                this.result.setValue(Math.round(d));
                break;
            }
            default: {
                return sub;
            }
        }
        return this.result;
    }

    public String getOperatorString() {
        return "round";
    }

    public Object clone(Object clone, Map obj2clone) throws CloneNotSupportedException {
        clone = super.clone(clone, obj2clone);
        Round ro = (Round)clone;
        ro.round = this.round;
        return clone;
    }
}

