/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.medor.optim.lib;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Stack;
import java.util.Vector;
import org.objectweb.jorm.type.api.PType;
import org.objectweb.jorm.type.api.PTypeSpace;
import org.objectweb.medor.api.MedorException;
import org.objectweb.medor.api.TupleStructure;
import org.objectweb.medor.expression.api.BinaryArithmeticOperator;
import org.objectweb.medor.expression.api.BinaryLogicalOperator;
import org.objectweb.medor.expression.api.Comparator;
import org.objectweb.medor.expression.api.Expression;
import org.objectweb.medor.expression.api.ExpressionException;
import org.objectweb.medor.expression.api.Operand;
import org.objectweb.medor.expression.api.ParameterOperand;
import org.objectweb.medor.expression.api.UnaryArithmeticOperator;
import org.objectweb.medor.expression.api.UnaryLogicalOperator;
import org.objectweb.medor.filter.api.BelongOperator;
import org.objectweb.medor.filter.api.ExpressionHelper;
import org.objectweb.medor.filter.api.FieldOperand;
import org.objectweb.medor.filter.postfix.PostfixExpressionHelper;
import org.objectweb.medor.optim.api.ExecPlanGenerator;
import org.objectweb.medor.optim.lib.DirsCompileClassLoader;
import org.objectweb.medor.query.api.CalculatedField;
import org.objectweb.medor.query.api.QueryNode;
import org.objectweb.medor.query.api.QueryTree;
import org.objectweb.medor.tuple.api.TupleLoader;
import org.objectweb.util.io.api.TargetHolder;
import org.objectweb.util.io.lib.BlockImpl;
import org.objectweb.util.io.lib.JavaFileHolder;

public class SourceCodeGeneratorCompiler
implements ExecPlanGenerator {
    private DirsCompileClassLoader mcl;
    private TargetHolder queryFiltersHolder;
    private TargetHolder tcTypeHolder;
    private QueryTree queryTree;
    private String sourceDirectory;
    private String classDirectory;
    private HashSet library = new HashSet();
    ExpressionHelper eHelper = new PostfixExpressionHelper();
    private int nbrFilter = 0;
    private int nbrQTType = 0;
    private static final String javaFilterName = "QueryFilter";
    private static final String tupleLoaderClassName = "TupleLoader";

    public SourceCodeGeneratorCompiler(String outputSourceDirectory, String outputClassdirectory, String[] libraryPaths) throws MedorException {
        try {
            this.sourceDirectory = outputSourceDirectory;
            this.classDirectory = outputClassdirectory;
            File tadir = new File(this.sourceDirectory);
            if (!tadir.isDirectory()) {
                throw new MedorException("the output directory parametre must be a directory:  " + this.sourceDirectory);
            }
            this.library.add(this.sourceDirectory);
            tadir = new File(this.classDirectory);
            if (!tadir.isDirectory()) {
                throw new MedorException("the output directory parametre must be a directory:  " + this.classDirectory);
            }
            this.library.add(this.classDirectory);
            for (int i = 0; i < libraryPaths.length; ++i) {
                File targetDirectory = new File(libraryPaths[i]);
                if (!targetDirectory.exists()) {
                    throw new MedorException("the path library  " + libraryPaths[i] + "does not exist");
                }
                this.library.add(libraryPaths[i]);
            }
            this.queryFiltersHolder = new JavaFileHolder(this.sourceDirectory);
            this.tcTypeHolder = new JavaFileHolder(this.sourceDirectory);
        }
        catch (Exception e) {
            throw new MedorException(e.getMessage());
        }
    }

    public void buildFilterSources(QueryTree query) throws MedorException {
        if (query instanceof QueryNode && ((QueryNode)query).getQueryFilter() != null) {
            QueryNode qn = (QueryNode)query;
            this.generateFilterSourceCode(qn.getQueryFilter(), javaFilterName + this.nbrFilter++);
            QueryTree[] qts = qn.getChildren();
            for (int cpt = 0; cpt < qts.length; ++cpt) {
                this.buildFilterSources(qts[cpt]);
            }
        }
    }

    public void buildTupleLoader(QueryTree query) throws MedorException {
        if (query instanceof QueryNode && ((QueryNode)query).getTupleLoader() != null) {
            this.generateTupleLoader(((QueryNode)query).getTupleLoader().getFieldIndexes(), query.getTupleStructure(), tupleLoaderClassName + this.nbrQTType++);
            QueryTree[] qts = ((QueryNode)query).getChildren();
            for (int cpt = 0; cpt < qts.length; ++cpt) {
                this.buildTupleLoader(qts[cpt]);
            }
        }
    }

    public QueryTree getQueryTree() {
        return this.queryTree;
    }

    public String[] getOutPutDirectoryName() {
        String[] dirs = new String[]{this.sourceDirectory, this.classDirectory};
        return dirs;
    }

    private void buildAllQueryFilter() throws MedorException {
        this.buildFilterSources(this.queryTree);
    }

    private void buildAllTupleLoader() throws MedorException {
        this.buildTupleLoader(this.queryTree);
    }

    private void generateTupleLoader(int[] indexes, TupleStructure ts, String javaFileName) throws MedorException {
        try {
            int cpt;
            FileWriter fw = this.tcTypeHolder.getFileWriter(javaFileName + ".java");
            byte b = 0;
            BlockImpl bk = new BlockImpl(fw, b);
            bk.writeLine("/**");
            bk.writeLine(" * This class is generated by Medor Compiler");
            bk.writeLine(" * It represents a TupleLoader Object");
            bk.writeLine(" */");
            bk.newLine();
            bk.writeLine("package org.objectweb.medor.filter.lib;");
            bk.newLine();
            bk.writeLine("import org.objectweb.medor.api.MedorException;");
            bk.writeLine("import org.objectweb.medor.tuple.api.TupleLoader;");
            bk.writeLine("import org.objectweb.medor.tuple.api.Tuple;");
            bk.writeLine("import org.objectweb.medor.expression.api.ParameterOperand;");
            bk.writeLine("import org.objectweb.medor.filter.api.VariableOperand;");
            bk.writeLine("import org.objectweb.medor.api.TupleStructure;");
            bk.newLine();
            ArrayList<String> listParams = new ArrayList<String>();
            bk.openBlock("public final class " + javaFileName + " implements TupleLoader");
            bk.newLine();
            for (int i = 1; i <= ts.getSize(); ++i) {
                if (!(ts.getField(i) instanceof CalculatedField)) continue;
                String[] parameters = this.eHelper.getParameterNames(((CalculatedField)ts.getField(i)).getExpression());
                for (int cpt2 = 0; cpt2 < parameters.length; ++cpt2) {
                    bk.writeLine("ParameterOperand " + parameters[cpt2] + ";");
                    listParams.add(parameters[cpt2]);
                }
            }
            String[] allParameters = new String[listParams.size()];
            for (cpt = 0; cpt < listParams.size(); ++cpt) {
                allParameters[cpt] = (String)listParams.get(cpt);
            }
            if (allParameters.length > 0) {
                bk.newLine();
                bk.openBlock("private int getParamRank(String paramName, ParameterOperand[] parameters) throws MedorException");
                bk.writeLine("int i;");
                bk.writeLine("for (i=0; (i<parameters.length && !(parameters[i].getName().equalsIgnoreCase(paramName)));i++);");
                bk.writeLine("if (i== parameters.length) throw new MedorException (\"Parameter Error\" + paramName);");
                bk.writeLine("return i;");
                bk.closeBlock();
            }
            bk.newLine();
            bk.openBlock("public void loadTuple(Tuple thisTuple, VariableOperand[] temp, ParameterOperand[] parameters) throws MedorException");
            for (cpt = 0; cpt < allParameters.length; ++cpt) {
                bk.writeLine(allParameters[cpt] + "= parameters[getParamRank(" + " \"" + allParameters[cpt] + "\" ,parameters)];");
            }
            int size = indexes.length;
            block18: for (int i = 0; i < size; ++i) {
                PType type = ts.getField(i + 1).getType();
                if (indexes[i] != -1) {
                    switch (type.getTypeCode()) {
                        case 4: {
                            bk.writeLine("temp[" + i + "].setValue(thisTuple.getInt(" + indexes[i] + "));");
                            break;
                        }
                        case 3: {
                            bk.writeLine("temp[" + i + "].setValue(thisTuple.getShort(" + indexes[i] + "));");
                            break;
                        }
                        case 2: {
                            bk.writeLine("temp[" + i + "].setValue(thisTuple.getByte(" + indexes[i] + "));");
                            break;
                        }
                        case 5: {
                            bk.writeLine("temp[" + i + "].setValue(thisTuple.getLong(" + indexes[i] + "));");
                            break;
                        }
                        case 7: {
                            bk.writeLine("temp[" + i + "].setValue(thisTuple.getDouble(" + indexes[i] + "));");
                            break;
                        }
                        case 0: {
                            bk.writeLine("temp[" + i + "].setValue(thisTuple.getBoolean(" + indexes[i] + "));");
                            break;
                        }
                        case 6: {
                            bk.writeLine("temp[" + i + "].setValue(thisTuple.getFloat(" + indexes[i] + "));");
                            break;
                        }
                        case 16: {
                            bk.writeLine("temp[" + i + "].setValue(thisTuple.getString(" + indexes[i] + "));");
                            break;
                        }
                        case 1: {
                            bk.writeLine("temp[" + i + "].setValue(thisTuple.getChar(" + indexes[i] + "));");
                            break;
                        }
                        case 17: {
                            bk.writeLine("temp[" + i + "].setValue(thisTuple.getDate(" + indexes[i] + "));");
                            break;
                        }
                        default: {
                            if (!type.getJormName().equals("collection")) continue block18;
                            bk.writeLine("temp[" + i + "].setValue(thisTuple.getTupleCollection(" + indexes[i] + "));");
                            break;
                        }
                    }
                    continue;
                }
                Expression calculExp = ((CalculatedField)ts.getField(i + 1)).getExpression();
                String filterExpression = this.generateQueryFilterString(this.eHelper.toStack(calculExp));
                bk.writeLine("temp[" + i + "].setValue(" + filterExpression + ");");
            }
            bk.closeBlock();
            bk.newLine();
            bk.openBlock("public int[] getFieldIndexes()");
            bk.writeLine("return null;");
            bk.closeBlock();
            bk.newLine();
            bk.openBlock("public TupleStructure getTupleStructure()");
            bk.writeLine("return null;");
            bk.closeBlock();
            bk.closeBlock();
            fw.close();
        }
        catch (Exception e) {
            throw new MedorException(e);
        }
    }

    private void generateFilterSourceCode(Expression filter, String javaFileName) throws MedorException {
        try {
            int cpt;
            FileWriter fw = this.queryFiltersHolder.getFileWriter(javaFileName + ".java");
            byte b = 0;
            BlockImpl bk = new BlockImpl(fw, b);
            bk.writeLine("/**");
            bk.writeLine(" * This class is generated by Medor Compiler");
            bk.writeLine(" * It represents a compiled Expression");
            bk.writeLine(" */");
            bk.newLine();
            bk.writeLine("package org.objectweb.medor.filter.lib;");
            bk.newLine();
            bk.writeLine("import org.objectweb.medor.api.MedorException;");
            bk.writeLine("import org.objectweb.medor.filter.api.Expression;");
            bk.writeLine("import org.objectweb.medor.filter.api.Operand;");
            bk.writeLine("import org.objectweb.medor.filter.api.VariableOperand;");
            bk.writeLine("import org.objectweb.medor.filter.lib.BasicVariableOperand;");
            bk.writeLine("import org.objectweb.medor.expression.api.ParameterOperand;");
            bk.writeLine("import org.objectweb.jorm.type.api.PTypeSpace;");
            bk.writeLine("import org.objectweb.jorm.type.api.PType;");
            bk.writeLine("import org.objectweb.medor.tuple.api.Tuple;");
            bk.newLine();
            bk.openBlock("public final class " + javaFileName + " implements Expression");
            bk.newLine();
            bk.writeLine("VariableOperand result = new BasicVariableOperand(PTypeSpace.BOOLEAN);");
            String[] allParameters = this.eHelper.getParameterNames(filter);
            for (cpt = 0; cpt < allParameters.length; ++cpt) {
                bk.writeLine("ParameterOperand " + allParameters[cpt] + ";");
            }
            if (allParameters.length > 0) {
                bk.newLine();
                bk.openBlock("private int getParamRank(String paramName, ParameterOperand[] parameters) throws MedorException");
                bk.writeLine("int i;");
                bk.writeLine("for (i=0; (i<parameters.length && !(parameters[i].getName().equalsIgnoreCase(paramName)));i++);");
                bk.writeLine("if (i== parameters.length) throw new MedorException (paramName);");
                bk.writeLine("return i;");
                bk.closeBlock();
            }
            bk.newLine();
            bk.openBlock("public void evaluate(ParameterOperand[] parameters,Tuple thisTuple) throws MedorException");
            for (cpt = 0; cpt < allParameters.length; ++cpt) {
                bk.writeLine(allParameters[cpt] + "= parameters[getParamRank(" + "\"" + allParameters[cpt] + "\" ,parameters)];");
            }
            String filterExpression = this.generateQueryFilterString(this.eHelper.toStack(filter));
            bk.writeLine("result.setValue( " + filterExpression + ");");
            bk.closeBlock();
            String ptype = "";
            bk.newLine();
            bk.openBlock("public PType getType()");
            switch (filter.getType().getTypeCode()) {
                case 2: {
                    ptype = "PTypeSpace.BYTE";
                    break;
                }
                case 7: {
                    ptype = "PTypeSpace.DOUBLE";
                    break;
                }
                case 4: {
                    ptype = "PTypeSpace.INT";
                    break;
                }
                case 6: {
                    ptype = "PTypeSpace.FLOAT";
                    break;
                }
                case 5: {
                    ptype = "PTypeSpace.LONG";
                    break;
                }
                case 3: {
                    ptype = "PTypeSpace.SHORT";
                    break;
                }
                case 0: {
                    ptype = "PTypeSpace.BOOLEAN";
                    break;
                }
                case 1: {
                    ptype = "PTypeSpace.CHAR";
                    break;
                }
                case 17: {
                    ptype = "PTypeSpace.DATE";
                }
            }
            bk.writeLine("return " + ptype + ";");
            bk.closeBlock();
            bk.newLine();
            bk.openBlock("public boolean isCompiled()");
            bk.writeLine("return true;");
            bk.closeBlock();
            bk.newLine();
            bk.openBlock("public Operand getResult()");
            bk.writeLine("return result;");
            bk.closeBlock();
            bk.newLine();
            bk.openBlock("public void compileExpression()");
            bk.closeBlock();
            bk.newLine();
            bk.openBlock("public Object clone()");
            bk.writeLine("return this;");
            bk.closeBlock();
            bk.newLine();
            bk.closeBlock();
            fw.close();
        }
        catch (Exception e) {
            throw new MedorException(e);
        }
    }

    private String generateQueryFilterString(Expression[] regularExp) throws ExpressionException {
        Expression[] polonfpf = regularExp;
        Stack<Object> popBuffer = new Stack<Object>();
        String opExp = "";
        for (int cpt = 0; cpt < polonfpf.length; ++cpt) {
            String rightOp;
            String leftOp;
            String operator;
            Object op1;
            Object op2;
            if (polonfpf[cpt] instanceof Operand) {
                popBuffer.push(polonfpf[cpt]);
                continue;
            }
            if (polonfpf[cpt] instanceof Comparator) {
                op2 = popBuffer.pop();
                op1 = popBuffer.pop();
                Comparator c = (Comparator)polonfpf[cpt];
                operator = c.getOperatorString();
                leftOp = op1 instanceof Operand ? this.generateOperandString((Operand)op1) : (String)op1;
                rightOp = op2 instanceof Operand ? this.generateOperandString((Operand)op2) : (String)op2;
                opExp = !c.getType().isa(PTypeSpace.STRING) ? "(" + leftOp + operator + rightOp + ")" : "(" + leftOp + "compareTo(" + rightOp + ")" + operator + "0)";
                popBuffer.push(opExp);
                continue;
            }
            if (polonfpf[cpt] instanceof BelongOperator) {
                op2 = popBuffer.pop();
                op1 = popBuffer.pop();
                leftOp = op1 instanceof Operand ? this.generateOperandString((Operand)op1) : (String)op1;
                rightOp = op2 instanceof Operand ? this.generateOperandString((Operand)op2) : (String)op2;
                opExp = "(new InTupleCollection().evaluate(leftOp , rightOp)";
                popBuffer.push(opExp);
                continue;
            }
            if (polonfpf[cpt] instanceof BinaryLogicalOperator) {
                op2 = popBuffer.pop();
                op1 = popBuffer.pop();
                BinaryLogicalOperator bLogicop = (BinaryLogicalOperator)polonfpf[cpt];
                operator = bLogicop.getOperatorString();
                leftOp = op1 instanceof Operand ? this.generateOperandString((Operand)op1) : (String)op1;
                rightOp = op2 instanceof Operand ? this.generateOperandString((Operand)op2) : (String)op2;
                opExp = "(" + leftOp + operator + rightOp + ")";
                popBuffer.push(opExp);
                continue;
            }
            if (polonfpf[cpt] instanceof UnaryLogicalOperator) {
                op1 = popBuffer.pop();
                leftOp = op1 instanceof Operand ? this.generateOperandString((Operand)op1) : (String)op1;
                opExp = "(!" + leftOp + ")";
                popBuffer.push(opExp);
                continue;
            }
            if (polonfpf[cpt] instanceof BinaryArithmeticOperator) {
                op2 = popBuffer.pop();
                op1 = popBuffer.pop();
                BinaryArithmeticOperator bArithOp = (BinaryArithmeticOperator)polonfpf[cpt];
                operator = bArithOp.getOperatorString() + "";
                leftOp = op1 instanceof Operand ? this.generateOperandString((Operand)op1) : (String)op1;
                rightOp = op2 instanceof Operand ? this.generateOperandString((Operand)op2) : (String)op2;
                opExp = "(" + leftOp + operator + rightOp + ")";
                popBuffer.push(opExp);
                continue;
            }
            if (!(polonfpf[cpt] instanceof UnaryArithmeticOperator)) continue;
            UnaryArithmeticOperator unArith = (UnaryArithmeticOperator)polonfpf[cpt];
            op1 = popBuffer.pop();
            leftOp = op1 instanceof Operand ? this.generateOperandString((Operand)op1) : (String)op1;
            opExp = "(" + unArith.getOperatorString() + leftOp + ")";
            popBuffer.push(opExp);
        }
        return (String)popBuffer.pop();
    }

    private String generateOperandString(Operand op) throws ExpressionException {
        String operandExp = "";
        PType type = op.getType();
        switch (type.getTypeCode()) {
            case 4: {
                if (op instanceof ParameterOperand) {
                    operandExp = ((ParameterOperand)op).getName() + ".getInt()";
                    break;
                }
                if (op instanceof FieldOperand) {
                    int range = ((FieldOperand)op).getIndex();
                    operandExp = "thisTuple.getInt(" + range + ")";
                    break;
                }
                operandExp = op.getInt() + "";
                break;
            }
            case 3: {
                if (op instanceof ParameterOperand) {
                    operandExp = ((ParameterOperand)op).getName() + ".getShort()";
                    break;
                }
                if (op instanceof Operand) {
                    operandExp = op.getShort() + "";
                    break;
                }
                if (!(op instanceof FieldOperand)) break;
                int range = ((FieldOperand)op).getIndex();
                operandExp = "thisTuple.getShort(" + range + ")";
                break;
            }
            case 17: {
                if (op instanceof ParameterOperand) {
                    operandExp = ((ParameterOperand)op).getName() + ".getByte()";
                    break;
                }
                if (op instanceof Operand) {
                    operandExp = op.getByte() + "";
                    break;
                }
                if (!(op instanceof FieldOperand)) break;
                int range = ((FieldOperand)op).getIndex();
                operandExp = "thisTuple.getByte(" + range + ")";
                break;
            }
            case 5: {
                if (op instanceof ParameterOperand) {
                    operandExp = ((ParameterOperand)op).getName() + ".getLong()";
                    break;
                }
                if (op instanceof Operand) {
                    operandExp = op.getLong() + "";
                    break;
                }
                if (!(op instanceof FieldOperand)) break;
                int range = ((FieldOperand)op).getIndex();
                operandExp = "thisTuple.getLong(" + range + ")";
                break;
            }
            case 7: {
                if (op instanceof ParameterOperand) {
                    operandExp = ((ParameterOperand)op).getName() + ".getDouble()";
                    break;
                }
                if (op instanceof Operand) {
                    operandExp = op.getDouble() + "";
                    break;
                }
                if (!(op instanceof FieldOperand)) break;
                int range = ((FieldOperand)op).getIndex();
                operandExp = "thisTuple.getDouble(" + range + ")";
                break;
            }
            case 6: {
                if (op instanceof ParameterOperand) {
                    operandExp = ((ParameterOperand)op).getName() + ".getFloat()";
                    break;
                }
                if (op instanceof Operand) {
                    operandExp = op.getFloat() + "";
                    break;
                }
                if (!(op instanceof FieldOperand)) break;
                int range = ((FieldOperand)op).getIndex();
                operandExp = "thisTuple.getFloat(" + range + ")";
                break;
            }
            case 0: {
                if (op instanceof ParameterOperand) {
                    operandExp = ((ParameterOperand)op).getName() + ".getBoolean()";
                    break;
                }
                if (op instanceof Operand) {
                    operandExp = op.getBoolean() + "";
                    break;
                }
                if (!(op instanceof FieldOperand)) break;
                int range = ((FieldOperand)op).getIndex();
                operandExp = "thisTuple.getBoolean(" + range + ")";
                break;
            }
            case 1: {
                if (op instanceof ParameterOperand) {
                    operandExp = ((ParameterOperand)op).getName() + ".getChar()";
                    break;
                }
                if (op instanceof Operand) {
                    operandExp = op.getChar() + "";
                    break;
                }
                if (!(op instanceof FieldOperand)) break;
                int range = ((FieldOperand)op).getIndex();
                operandExp = "thisTuple.getChar(" + range + ")";
                break;
            }
            case 16: {
                if (op instanceof ParameterOperand) {
                    operandExp = ((ParameterOperand)op).getName() + ".getString()";
                    break;
                }
                if (op instanceof Operand) {
                    operandExp = op.getString();
                    break;
                }
                if (!(op instanceof FieldOperand)) break;
                int range = ((FieldOperand)op).getIndex();
                operandExp = "thisTuple.getString(" + range + ")";
                break;
            }
            default: {
                if (type.getJormName().equals("collection")) {
                    if (op instanceof ParameterOperand) {
                        operandExp = ((ParameterOperand)op).getName() + ".getTupleCollection()";
                        break;
                    }
                    if (op instanceof Operand) {
                        operandExp = op.getObject() + "";
                        break;
                    }
                    if (!(op instanceof FieldOperand)) break;
                    int range = ((FieldOperand)op).getIndex();
                    operandExp = "thisTuple.getTupleCollection(" + range + ")";
                    break;
                }
                if (!type.getJormName().equals("tuple")) break;
                if (op instanceof ParameterOperand) {
                    operandExp = ((ParameterOperand)op).getName() + ".getTuple()";
                    break;
                }
                if (op instanceof Operand) {
                    operandExp = op.getObject() + "";
                    break;
                }
                if (!(op instanceof FieldOperand)) break;
                int range = ((FieldOperand)op).getIndex();
                operandExp = "thisTuple.getTuple(" + range + ")";
            }
        }
        return operandExp;
    }

    public Iterator getSourceFileIterator() {
        return this.queryFiltersHolder.iterateFile();
    }

    public QueryTree transform(QueryTree query) throws MedorException {
        this.queryTree = query;
        this.buildAllQueryFilter();
        this.buildAllTupleLoader();
        Vector list = new Vector();
        Iterator i1 = this.queryFiltersHolder.iterateFile();
        Iterator i2 = this.tcTypeHolder.iterateFile();
        while (i1.hasNext()) {
            list.add(i1.next());
        }
        while (i2.hasNext()) {
            list.add(i2.next());
        }
        this.javac(list.elements());
        QueryTree copy = this.queryTree;
        this.library.add(this.sourceDirectory);
        this.mcl = new DirsCompileClassLoader(this.library);
        this.nbrFilter = 0;
        this.nbrQTType = 0;
        this.compileFilters(copy, javaFilterName + this.nbrFilter);
        this.compileTupleLoader(copy, tupleLoaderClassName + this.nbrQTType);
        return copy;
    }

    private void compileFilters(QueryTree query, String fileName) throws MedorException {
        Class<?> c = null;
        try {
            if (query instanceof QueryNode && ((QueryNode)query).getQueryFilter() != null) {
                ++this.nbrFilter;
                c = this.mcl.loadClass("org.objectweb.medor.filter.lib." + fileName);
                Object o = c.newInstance();
                Expression predicate = (Expression)o;
                ((QueryNode)query).setQueryFilter(predicate);
                QueryTree[] qts = ((QueryNode)query).getChildren();
                for (int cpt = 0; cpt < qts.length; ++cpt) {
                    this.compileFilters(qts[cpt], javaFilterName + this.nbrFilter);
                }
            }
        }
        catch (ClassNotFoundException exp) {
            throw new MedorException("THIS CLASS NOT EXIST TRY TO COMPILE AT FIRST");
        }
        catch (InstantiationException iexo) {
        }
        catch (IllegalAccessException e) {
            // empty catch block
        }
    }

    private void compileTupleLoader(QueryTree query, String fileName) throws MedorException {
        Class<?> c = null;
        try {
            if (query instanceof QueryNode && ((QueryNode)query).getTupleLoader() != null) {
                ++this.nbrQTType;
                c = this.mcl.loadClass("org.objectweb.medor.filter.lib." + fileName);
                Object o = c.newInstance();
                TupleLoader tLoader = (TupleLoader)o;
                ((QueryNode)query).setTupleLoader(tLoader);
                QueryTree[] qts = ((QueryNode)query).getChildren();
                for (int cpt = 0; cpt < qts.length; ++cpt) {
                    this.compileTupleLoader(qts[cpt], tupleLoaderClassName + this.nbrQTType);
                }
            }
        }
        catch (ClassNotFoundException exp) {
            throw new MedorException("THIS CLASS May be NOT EXIST TRY TO COMPILE AT FIRST or correct the classpath");
        }
        catch (InstantiationException iexo) {
        }
        catch (IllegalAccessException e) {
            // empty catch block
        }
    }

    private void javac(Enumeration listFile) {
        Runtime rt = Runtime.getRuntime();
        Process p = null;
        try {
            String s;
            File f;
            System.out.println("Launching javac ...");
            String classpath = "";
            String sourceFiles = this.sourceDirectory + File.separator;
            Iterator i = this.library.iterator();
            if (i.hasNext()) {
                classpath = classpath + (String)i.next();
            }
            while (i.hasNext()) {
                classpath = classpath + File.pathSeparator + (String)i.next();
            }
            if (listFile.hasMoreElements()) {
                f = (File)listFile.nextElement();
                s = f.getName();
                sourceFiles = sourceFiles + s;
            }
            while (listFile.hasMoreElements()) {
                f = (File)listFile.nextElement();
                s = f.getName();
                sourceFiles = sourceFiles + " " + this.sourceDirectory + File.separator + s;
            }
            String cmd = "javac -classpath " + classpath + " " + "-d " + this.classDirectory + " " + sourceFiles;
            System.out.println(cmd);
            try {
                p = rt.exec(cmd);
            }
            catch (IOException e) {
                System.err.println(" Compilation failed... " + e.getMessage());
            }
            p.waitFor();
            System.out.println("Compilation finisched ...");
        }
        catch (InterruptedException e) {
            System.err.println(" Compilation failed... " + e.getMessage());
        }
    }

    public void addLibraryPath(String classpath) throws MedorException {
        File tadir = new File(classpath);
        if (!tadir.exists()) {
            throw new MedorException("the path library  " + classpath + "does not exist");
        }
        this.library.add(classpath);
    }

    public Iterator getPathsIterator() {
        return this.library.iterator();
    }
}

