/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.oxm;

import javax.activation.DataHandler;
import javax.xml.namespace.QName;
import org.eclipse.persistence.exceptions.XMLMarshalException;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.oxm.ContainerValue;
import org.eclipse.persistence.internal.oxm.MappingNodeValue;
import org.eclipse.persistence.internal.oxm.NodeValue;
import org.eclipse.persistence.internal.oxm.XMLBinaryDataHelper;
import org.eclipse.persistence.internal.oxm.XMLConversionManager;
import org.eclipse.persistence.internal.oxm.XPathFragment;
import org.eclipse.persistence.internal.oxm.record.MarshalContext;
import org.eclipse.persistence.internal.oxm.record.ObjectMarshalContext;
import org.eclipse.persistence.internal.oxm.record.XMLReader;
import org.eclipse.persistence.internal.oxm.record.deferred.BinaryMappingContentHandler;
import org.eclipse.persistence.internal.queries.ContainerPolicy;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.mappings.converters.Converter;
import org.eclipse.persistence.oxm.NamespaceResolver;
import org.eclipse.persistence.oxm.XMLField;
import org.eclipse.persistence.oxm.XMLMarshaller;
import org.eclipse.persistence.oxm.mappings.XMLBinaryDataCollectionMapping;
import org.eclipse.persistence.oxm.mappings.converters.XMLConverter;
import org.eclipse.persistence.oxm.record.MarshalRecord;
import org.eclipse.persistence.oxm.record.UnmarshalRecord;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class XMLBinaryDataCollectionMappingNodeValue
extends MappingNodeValue
implements ContainerValue {
    private XMLBinaryDataCollectionMapping xmlBinaryDataCollectionMapping;

    public XMLBinaryDataCollectionMappingNodeValue(XMLBinaryDataCollectionMapping mapping) {
        this.xmlBinaryDataCollectionMapping = mapping;
    }

    public void setContainerInstance(Object object, Object containerInstance) {
        this.xmlBinaryDataCollectionMapping.setAttributeValueInObject(object, containerInstance);
    }

    public Object getContainerInstance() {
        return this.getContainerPolicy().containerInstance();
    }

    public ContainerPolicy getContainerPolicy() {
        return this.xmlBinaryDataCollectionMapping.getContainerPolicy();
    }

    protected String getValueToWrite(QName schemaType, Object value, AbstractSession session) {
        return (String)((XMLConversionManager)session.getDatasourcePlatform().getConversionManager()).convertObject(value, ClassConstants.STRING, schemaType);
    }

    public boolean isOwningNode(XPathFragment xPathFragment) {
        return xPathFragment.getNextFragment() == null || xPathFragment.isAttribute();
    }

    public boolean marshal(XPathFragment xPathFragment, MarshalRecord marshalRecord, Object object, AbstractSession session, NamespaceResolver namespaceResolver) {
        if (this.xmlBinaryDataCollectionMapping.isReadOnly()) {
            return false;
        }
        Object collection = this.xmlBinaryDataCollectionMapping.getAttributeAccessor().getAttributeValueFromObject(object);
        if (null == collection) {
            return false;
        }
        String xopPrefix = null;
        if (namespaceResolver != null) {
            xopPrefix = namespaceResolver.resolveNamespaceURI("http://www.w3.org/2004/08/xop/include");
        }
        if (xopPrefix == null || namespaceResolver == null) {
            xopPrefix = "xop";
            marshalRecord.getNamespaceResolver().put(xopPrefix, "http://www.w3.org/2004/08/xop/include");
        }
        ContainerPolicy cp = this.getContainerPolicy();
        Object iterator = cp.iteratorFor(collection);
        while (cp.hasNext(iterator)) {
            Object objectValue = cp.next(iterator, session);
            this.marshalSingleValue(xPathFragment, marshalRecord, object, objectValue, session, namespaceResolver, ObjectMarshalContext.getInstance());
        }
        marshalRecord.getNamespaceResolver().removeNamespace("xop");
        return true;
    }

    public boolean startElement(XPathFragment xPathFragment, UnmarshalRecord unmarshalRecord, Attributes atts) {
        try {
            XMLField xmlField = (XMLField)this.xmlBinaryDataCollectionMapping.getField();
            XPathFragment lastFragment = xmlField.getLastXPathFragment();
            if (!lastFragment.isAttribute()) {
                BinaryMappingContentHandler handler = new BinaryMappingContentHandler(unmarshalRecord, (NodeValue)this, this.xmlBinaryDataCollectionMapping);
                String qnameString = xPathFragment.getLocalName();
                if (xPathFragment.getPrefix() != null) {
                    qnameString = xPathFragment.getPrefix() + ':' + qnameString;
                }
                handler.startElement(xPathFragment.getNamespaceURI(), xPathFragment.getLocalName(), qnameString, atts);
                XMLReader xmlReader = unmarshalRecord.getXMLReader();
                xmlReader.setContentHandler(handler);
                xmlReader.setLexicalHandler(handler);
            } else if (lastFragment.isAttribute()) {
                String value = atts.getValue(lastFragment.getNamespaceURI(), lastFragment.getLocalName());
                Object fieldValue = null;
                if (this.xmlBinaryDataCollectionMapping.isSwaRef()) {
                    if (unmarshalRecord.getUnmarshaller().getAttachmentUnmarshaller() != null) {
                        fieldValue = this.xmlBinaryDataCollectionMapping.getAttributeClassification() == XMLBinaryDataHelper.getXMLBinaryDataHelper().DATA_HANDLER ? (Object)unmarshalRecord.getUnmarshaller().getAttachmentUnmarshaller().getAttachmentAsDataHandler(value) : unmarshalRecord.getUnmarshaller().getAttachmentUnmarshaller().getAttachmentAsByteArray(value);
                        this.xmlBinaryDataCollectionMapping.setAttributeValueInObject(unmarshalRecord.getCurrentObject(), XMLBinaryDataHelper.getXMLBinaryDataHelper().convertObject(fieldValue, this.xmlBinaryDataCollectionMapping.getAttributeClassification(), unmarshalRecord.getSession()));
                    }
                } else {
                    fieldValue = ((XMLConversionManager)unmarshalRecord.getSession().getDatasourcePlatform().getConversionManager()).convertSchemaBase64ToByteArray(value);
                    this.xmlBinaryDataCollectionMapping.setAttributeValueInObject(unmarshalRecord.getCurrentObject(), XMLBinaryDataHelper.getXMLBinaryDataHelper().convertObject(fieldValue, this.xmlBinaryDataCollectionMapping.getAttributeClassification(), unmarshalRecord.getSession()));
                }
            }
            return true;
        }
        catch (SAXException ex) {
            throw XMLMarshalException.unmarshalException(ex);
        }
    }

    public void endElement(XPathFragment xPathFragment, UnmarshalRecord unmarshalRecord) {
        unmarshalRecord.getStringBuffer().reset();
    }

    public DataHandler getDataHandlerForObjectValue(Object obj, Class classification) {
        if (classification == DataHandler.class) {
            return (DataHandler)obj;
        }
        return null;
    }

    public boolean isContainerValue() {
        return true;
    }

    public boolean marshalSingleValue(XPathFragment xPathFragment, MarshalRecord marshalRecord, Object object, Object objectValue, AbstractSession session, NamespaceResolver namespaceResolver, MarshalContext marshalContext) {
        if (objectValue == null) {
            return false;
        }
        boolean addDeclaration = false;
        boolean removePrefix = false;
        String xopPrefix = null;
        if (namespaceResolver != null) {
            xopPrefix = namespaceResolver.resolveNamespaceURI("http://www.w3.org/2004/08/xop/include");
        }
        if (xopPrefix == null) {
            addDeclaration = true;
            xopPrefix = marshalRecord.getNamespaceResolver().resolveNamespaceURI("http://www.w3.org/2004/08/xop/include");
            if (xopPrefix == null) {
                removePrefix = true;
                xopPrefix = "xop";
                marshalRecord.getNamespaceResolver().put(xopPrefix, "http://www.w3.org/2004/08/xop/include");
            }
            namespaceResolver = marshalRecord.getNamespaceResolver();
        }
        XMLMarshaller marshaller = marshalRecord.getMarshaller();
        if (this.xmlBinaryDataCollectionMapping.getValueConverter() != null) {
            Converter converter = this.xmlBinaryDataCollectionMapping.getValueConverter();
            objectValue = converter instanceof XMLConverter ? ((XMLConverter)converter).convertObjectValueToDataValue(objectValue, session, marshaller) : converter.convertObjectValueToDataValue(objectValue, session);
        }
        XPathFragment groupingFragment = marshalRecord.openStartGroupingElements(namespaceResolver);
        marshalRecord.closeStartGroupingElements(groupingFragment);
        marshalRecord.openStartElement(xPathFragment, namespaceResolver);
        marshalRecord.closeStartElement();
        if (this.xmlBinaryDataCollectionMapping.isSwaRef() && marshaller.getAttachmentMarshaller() != null) {
            String c_id = null;
            byte[] bytes = null;
            if (this.xmlBinaryDataCollectionMapping.getAttributeElementClass() == XMLBinaryDataHelper.getXMLBinaryDataHelper().DATA_HANDLER) {
                c_id = marshaller.getAttachmentMarshaller().addSwaRefAttachment((DataHandler)objectValue);
                if (c_id == null) {
                    bytes = XMLBinaryDataHelper.getXMLBinaryDataHelper().getBytesForBinaryValue(objectValue, marshaller, this.xmlBinaryDataCollectionMapping.getMimeType(object)).getData();
                }
            } else {
                XMLBinaryDataHelper.EncodedData data = XMLBinaryDataHelper.getXMLBinaryDataHelper().getBytesForBinaryValue(objectValue, marshaller, this.xmlBinaryDataCollectionMapping.getMimeType(object));
                bytes = data.getData();
                c_id = marshaller.getAttachmentMarshaller().addSwaRefAttachment(bytes, 0, bytes.length);
            }
            if (c_id != null) {
                marshalRecord.characters(c_id);
            } else {
                String value = this.getValueToWrite(((XMLField)this.xmlBinaryDataCollectionMapping.getField()).getSchemaType(), bytes, session);
                marshalRecord.characters(value);
            }
        } else if (marshalRecord.isXOPPackage() && !this.xmlBinaryDataCollectionMapping.shouldInlineBinaryData()) {
            XPathFragment lastFrag = ((XMLField)this.xmlBinaryDataCollectionMapping.getField()).getLastXPathFragment();
            String c_id = "";
            byte[] bytes = null;
            if (objectValue.getClass() == ClassConstants.APBYTE) {
                bytes = (byte[])objectValue;
                c_id = marshaller.getAttachmentMarshaller().addMtomAttachment(bytes, 0, bytes.length, this.xmlBinaryDataCollectionMapping.getMimeType(object), lastFrag.getLocalName(), lastFrag.getNamespaceURI());
            } else if (this.xmlBinaryDataCollectionMapping.getAttributeClassification() == XMLBinaryDataHelper.getXMLBinaryDataHelper().DATA_HANDLER) {
                c_id = marshaller.getAttachmentMarshaller().addMtomAttachment((DataHandler)objectValue, lastFrag.getLocalName(), lastFrag.getNamespaceURI());
                if (c_id == null) {
                    bytes = XMLBinaryDataHelper.getXMLBinaryDataHelper().getBytesForBinaryValue(objectValue, marshaller, this.xmlBinaryDataCollectionMapping.getMimeType(object)).getData();
                }
            } else {
                XMLBinaryDataHelper.EncodedData data = XMLBinaryDataHelper.getXMLBinaryDataHelper().getBytesForBinaryValue(objectValue, marshaller, this.xmlBinaryDataCollectionMapping.getMimeTypePolicy().getMimeType(object));
                bytes = data.getData();
                c_id = marshaller.getAttachmentMarshaller().addMtomAttachment(bytes, 0, bytes.length, data.getMimeType(), lastFrag.getLocalName(), lastFrag.getNamespaceURI());
            }
            if (c_id == null) {
                String value = this.getValueToWrite(((XMLField)this.xmlBinaryDataCollectionMapping.getField()).getSchemaType(), bytes, session);
                marshalRecord.characters(value);
            } else {
                XPathFragment xopInclude = new XPathFragment(xopPrefix + ":Include");
                xopInclude.setNamespaceURI("http://www.w3.org/2004/08/xop/include");
                marshalRecord.openStartElement(xopInclude, namespaceResolver);
                marshalRecord.attribute("", "href", "href", c_id);
                if (addDeclaration) {
                    marshalRecord.attribute("http://www.w3.org/2000/xmlns/", xopPrefix, "xmlns:" + xopPrefix, "http://www.w3.org/2004/08/xop/include");
                }
                marshalRecord.closeStartElement();
                marshalRecord.endElement(xPathFragment, namespaceResolver);
            }
        } else {
            String value = "";
            if (objectValue.getClass() == ClassConstants.ABYTE || objectValue.getClass() == ClassConstants.APBYTE) {
                value = this.getValueToWrite(((XMLField)this.xmlBinaryDataCollectionMapping.getField()).getSchemaType(), objectValue, session);
            } else {
                byte[] bytes = XMLBinaryDataHelper.getXMLBinaryDataHelper().getBytesForBinaryValue(objectValue, marshaller, this.xmlBinaryDataCollectionMapping.getMimeTypePolicy().getMimeType(object)).getData();
                value = this.getValueToWrite(((XMLField)this.xmlBinaryDataCollectionMapping.getField()).getSchemaType(), bytes, session);
            }
            marshalRecord.characters(value);
        }
        marshalRecord.endElement(xPathFragment, namespaceResolver);
        if (removePrefix) {
            marshalRecord.getNamespaceResolver().removeNamespace("xop");
        }
        return true;
    }

    public XMLBinaryDataCollectionMapping getMapping() {
        return this.xmlBinaryDataCollectionMapping;
    }

    public boolean getReuseContainer() {
        return this.getMapping().getReuseContainer();
    }
}

