/*
 * Decompiled with CFR 0.152.
 */
package fr.dyade.aaa.common.monitoring;

import fr.dyade.aaa.common.Debug;
import fr.dyade.aaa.common.monitoring.MonitoringTimerTaskMBean;
import fr.dyade.aaa.util.management.MXWrapper;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Timer;
import java.util.TimerTask;
import javax.management.MBeanAttributeInfo;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;

public abstract class MonitoringTimerTask
extends TimerTask
implements MonitoringTimerTaskMBean {
    protected long period;
    Properties attlist = null;
    public static Logger logger = Debug.getLogger(MonitoringTimerTask.class.getName());

    public long getPeriod() {
        return this.period;
    }

    public MonitoringTimerTask(long period, Properties attlist) {
        this.period = period;
        this.attlist = attlist;
    }

    protected final void start(Timer timer) {
        timer.scheduleAtFixedRate((TimerTask)this, this.period, this.period);
    }

    protected abstract void initializeRecords();

    protected abstract void addRecord(ObjectName var1, String var2, Object var3);

    protected abstract void finalizeRecords();

    public void run() {
        this.initializeRecords();
        Enumeration<Object> mbeans = this.attlist.keys();
        while (mbeans.hasMoreElements()) {
            String name = (String)mbeans.nextElement();
            Set mBeans = null;
            try {
                mBeans = MXWrapper.queryNames(new ObjectName(name));
            }
            catch (MalformedObjectNameException exc) {
                logger.log(BasicLevel.ERROR, (Object)("MonitoringTimerTask.run, bad name: " + name), (Throwable)exc);
            }
            if (mBeans == null) continue;
            for (ObjectName mBean : mBeans) {
                StringTokenizer st = new StringTokenizer((String)this.attlist.get(name), ",");
                while (st.hasMoreTokens()) {
                    String token = st.nextToken();
                    if (token.equals("*")) {
                        try {
                            MBeanAttributeInfo[] attributes = MXWrapper.getAttributes(mBean);
                            if (attributes == null) continue;
                            for (int i = 0; i < attributes.length; ++i) {
                                String attname = attributes[i].getName();
                                try {
                                    this.addRecord(mBean, attname, MXWrapper.getAttribute(mBean, attname));
                                    continue;
                                }
                                catch (Exception exc) {
                                    logger.log(BasicLevel.ERROR, (Object)("MonitoringTimerTask.run, bad attribute : " + mBean + ":" + attname), (Throwable)exc);
                                }
                            }
                            continue;
                        }
                        catch (Exception exc) {
                            logger.log(BasicLevel.ERROR, (Object)"MonitoringTimerTask.run", (Throwable)exc);
                            continue;
                        }
                    }
                    String attname = token.trim();
                    try {
                        this.addRecord(mBean, attname, MXWrapper.getAttribute(mBean, attname));
                    }
                    catch (Exception exc) {
                        logger.log(BasicLevel.ERROR, (Object)("MonitoringTimerTask.run, bad attribute : " + mBean + ":" + attname), (Throwable)exc);
                    }
                }
            }
        }
        this.finalizeRecords();
    }

    public String[] getMonitoredAttributes() {
        int i = 0;
        String[] ret = new String[this.attlist.size()];
        Enumeration<Object> e = this.attlist.keys();
        while (e.hasMoreElements()) {
            String mbean = (String)e.nextElement();
            ret[i++] = mbean + '=' + this.attlist.getProperty(mbean);
        }
        return ret;
    }

    public void addMonitoredAttributes(String MBeanName, String attributes) {
        this.attlist.put(MBeanName, attributes);
    }

    public void delMonitoredAttributes(String MBeanName) {
        this.attlist.remove(MBeanName);
    }

    public void cancelTask() {
        this.cancel();
    }
}

