/*
 * Decompiled with CFR 0.152.
 */
package fr.dyade.aaa.util.management;

import fr.dyade.aaa.util.management.MXServer;
import java.util.Set;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.MBeanAttributeInfo;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;

public final class MXWrapper {
    public static final String ServerImpl = "MXServer";
    public static MXServer mxserver = null;

    public static void init() throws Exception {
        if (mxserver != null) {
            return;
        }
        String mxname = System.getProperty(ServerImpl);
        if (mxname != null && mxname.length() > 0) {
            Class.forName(mxname).newInstance();
        }
    }

    public static String objectName(String domain, String name) {
        StringBuffer strbuf = new StringBuffer();
        strbuf.append(domain).append(':').append(name);
        return strbuf.toString();
    }

    public static String registerMBean(Object bean, String domain, String name) throws Exception {
        return MXWrapper.registerMBean(bean, MXWrapper.objectName(domain, name));
    }

    public static String registerMBean(Object bean, String fullName) throws Exception {
        if (mxserver == null) {
            return null;
        }
        return mxserver.registerMBean(bean, fullName);
    }

    public static Object getMBeanInstance(ObjectName objName) {
        if (mxserver == null) {
            return null;
        }
        return mxserver.getMBeanInstance(objName);
    }

    public static void unregisterMBean(String domain, String name) throws Exception {
        MXWrapper.unregisterMBean(MXWrapper.objectName(domain, name));
    }

    public static void unregisterMBean(String fullName) throws Exception {
        if (mxserver == null) {
            return;
        }
        mxserver.unregisterMBean(fullName);
    }

    public static void setMXServer(MXServer server) {
        mxserver = server;
    }

    public static MXServer getMXServer() {
        return mxserver;
    }

    public static void setAttribute(ObjectName name, Attribute attribute) throws Exception {
        if (mxserver != null) {
            mxserver.setAttribute(name, attribute);
        }
    }

    public static void addNotificationListener(ObjectName name, NotificationListener listener, NotificationFilter filter, Object handback) throws Exception {
        if (mxserver != null) {
            mxserver.addNotificationListener(name, listener, filter, handback);
        }
    }

    public static void removeNotificationListener(ObjectName name, NotificationListener listener) throws Exception {
        if (mxserver != null) {
            mxserver.removeNotificationListener(name, listener);
        }
    }

    public static void removeNotificationListener(ObjectName name, NotificationListener listener, NotificationFilter filter, Object handback) throws Exception {
        if (mxserver != null) {
            mxserver.removeNotificationListener(name, listener, filter, handback);
        }
    }

    public static Object getAttribute(ObjectName objectName, String attribute) throws Exception {
        if (mxserver == null) {
            return null;
        }
        return mxserver.getAttribute(objectName, attribute);
    }

    public static MBeanAttributeInfo[] getAttributes(ObjectName objectName) throws Exception {
        if (mxserver == null) {
            return null;
        }
        return mxserver.getAttributes(objectName);
    }

    public AttributeList setAttributes(ObjectName name, AttributeList attributes) throws Exception {
        if (mxserver == null) {
            return null;
        }
        return mxserver.setAttributes(name, attributes);
    }

    public static Set queryNames(ObjectName objectName) {
        if (mxserver == null) {
            return null;
        }
        return mxserver.queryNames(objectName);
    }
}

