/*
 * Decompiled with CFR 0.152.
 */
package fr.dyade.aaa.agent.conf;

import fr.dyade.aaa.agent.conf.A3CMLProperty;
import fr.dyade.aaa.agent.conf.A3CMLServer;
import fr.dyade.aaa.agent.conf.DuplicateServerException;
import fr.dyade.aaa.agent.conf.UnknownServerException;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;

public class A3CMLCluster
implements Serializable {
    private static final long serialVersionUID = 1L;
    public short sid = (short)-1;
    public String name = null;
    public String jvmArgs = null;
    public Hashtable servers = null;
    public Hashtable properties = null;

    public A3CMLCluster(short sid, String name) throws Exception {
        this.sid = sid;
        this.name = name;
        this.properties = new Hashtable();
        this.servers = new Hashtable();
    }

    public final void addServer(A3CMLServer server) throws DuplicateServerException {
        Short id = new Short(server.sid);
        if (this.servers.containsKey(id)) {
            throw new DuplicateServerException("Duplicate server id. #" + server.sid);
        }
        server.name = "cluster_" + this.sid + "_" + server.sid;
        server.sid = this.sid;
        this.servers.put(id, server);
    }

    public final A3CMLServer removeServer(short sid) throws UnknownServerException {
        A3CMLServer server = null;
        Short id = new Short(sid);
        if (!this.servers.containsKey(id)) {
            throw new UnknownServerException("Unknown server id. #" + sid);
        }
        server = (A3CMLServer)this.servers.remove(id);
        return server;
    }

    public final A3CMLServer removeServer(String name) throws UnknownServerException {
        return this.removeServer(this.getServerIdByName(name));
    }

    public final boolean containsServer(short sid) {
        return this.servers.containsKey(new Short(sid));
    }

    public short getServerIdByName(String name) throws UnknownServerException {
        Enumeration s = this.servers.elements();
        while (s.hasMoreElements()) {
            A3CMLServer server = (A3CMLServer)s.nextElement();
            if (!server.name.equals(name)) continue;
            return server.sid;
        }
        throw new UnknownServerException("Unknown server " + name);
    }

    public final boolean containsServer(String name) {
        try {
            this.getServerIdByName(name);
        }
        catch (UnknownServerException exc) {
            return false;
        }
        return true;
    }

    public final A3CMLServer getServer(short sid) throws UnknownServerException {
        A3CMLServer server = (A3CMLServer)this.servers.get(new Short(sid));
        if (server == null) {
            throw new UnknownServerException("Unknown server id. #" + sid);
        }
        return server;
    }

    public final A3CMLServer getServer(String name) throws UnknownServerException {
        Enumeration s = this.servers.elements();
        while (s.hasMoreElements()) {
            A3CMLServer server = (A3CMLServer)s.nextElement();
            if (!server.name.equals(name)) continue;
            return server;
        }
        throw new UnknownServerException("Unknown server id for server " + name);
    }

    public final A3CMLProperty addProperty(A3CMLProperty prop) throws Exception {
        return this.properties.put(prop.name, prop);
    }

    public final A3CMLProperty removeProperty(String name) {
        return (A3CMLProperty)this.properties.remove(name);
    }

    public final boolean containsProperty(String name) {
        return this.properties.containsKey(name);
    }

    public final A3CMLProperty getProperty(String name) {
        return (A3CMLProperty)this.properties.get(name);
    }

    public final String getJvmArgs(short sid) throws UnknownServerException {
        A3CMLServer server = this.getServer(sid);
        return server.getJvmArgs();
    }

    public final String getJvmArgs(String name) throws UnknownServerException {
        A3CMLServer server = this.getServer(name);
        return server.getJvmArgs();
    }

    public String toString() {
        StringBuffer strBuf = new StringBuffer();
        strBuf.append("(").append(super.toString());
        strBuf.append(",sid=").append(this.sid);
        strBuf.append(",name=").append(this.name);
        strBuf.append(",jvmArgs=").append(this.jvmArgs);
        strBuf.append(",properties=").append(this.properties);
        strBuf.append(",servers=").append(this.servers);
        strBuf.append(")");
        return strBuf.toString();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof A3CMLCluster) {
            A3CMLCluster cluster = (A3CMLCluster)obj;
            if (this.sid == cluster.sid && this.name.equals(cluster.name) && this.servers.equals(cluster.servers) && this.properties.equals(cluster.properties)) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.properties == null ? 0 : this.properties.hashCode());
        result = 31 * result + (this.servers == null ? 0 : this.servers.hashCode());
        result = 31 * result + this.sid;
        return result;
    }
}

