/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.environment.tomcat;

import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.InjectionTarget;
import javax.naming.NamingException;
import org.apache.AnnotationProcessor;
import org.jboss.weld.manager.api.WeldManager;

public class WeldAnnotationProcessor
implements AnnotationProcessor {
    private final Map<Class<?>, InjectionTarget<?>> injectionTargets;
    private final WeldManager manager;

    public WeldAnnotationProcessor(WeldManager manager) {
        this.manager = manager;
        this.injectionTargets = new ConcurrentHashMap();
    }

    public void processAnnotations(Object instance) throws IllegalAccessException, InvocationTargetException, NamingException {
        Class<?> clazz = instance.getClass();
        if (!this.injectionTargets.containsKey(clazz)) {
            this.injectionTargets.put(clazz, this.manager.createInjectionTarget(this.manager.createAnnotatedType(clazz)));
        }
        CreationalContext cc = this.manager.createCreationalContext(null);
        InjectionTarget<?> it = this.injectionTargets.get(clazz);
        it.inject(instance, cc);
    }

    public void postConstruct(Object arg0) throws IllegalAccessException, InvocationTargetException {
    }

    public void preDestroy(Object arg0) throws IllegalAccessException, InvocationTargetException {
    }
}

