/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.cdi.weld.internal.resource;

import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import org.jboss.weld.resources.spi.ResourceLoader;
import org.jboss.weld.resources.spi.ResourceLoadingException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApplicationResourceLoader
implements ResourceLoader {
    private ClassLoader loader;

    public ApplicationResourceLoader(ClassLoader loader) {
        this.loader = loader;
    }

    public Class<?> classForName(String name) {
        try {
            return Class.forName(name, true, this.loader);
        }
        catch (Exception e) {
            throw new ResourceLoadingException((Throwable)e);
        }
    }

    public URL getResource(String name) {
        return this.loader.getResource(name);
    }

    public Collection<URL> getResources(String name) {
        try {
            Enumeration<URL> enumeration = this.loader.getResources(name);
            if (enumeration.hasMoreElements()) {
                return Collections.list(enumeration);
            }
            return Collections.emptySet();
        }
        catch (IOException e) {
            throw new ResourceLoadingException((Throwable)e);
        }
    }

    public void cleanup() {
        this.loader = null;
    }
}

