/*
 * Decompiled with CFR 0.152.
 */
package aQute.lib.deployer;

import aQute.lib.deployer.FileRepo;
import aQute.lib.osgi.Instruction;
import aQute.lib.osgi.Jar;
import aQute.lib.osgi.Processor;
import aQute.lib.osgi.Verifier;
import aQute.libg.reporter.Reporter;
import aQute.libg.version.Version;
import aQute.libg.version.VersionRange;
import java.io.File;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileInstallRepo
extends FileRepo {
    String group;
    boolean dirty;
    Reporter reporter;
    Pattern REPO_FILE = Pattern.compile("([-a-zA-z0-9_\\.]+)-([0-9\\.]+)\\.(jar|lib)");

    @Override
    public void setProperties(Map<String, String> map) {
        super.setProperties(map);
        this.group = map.get("group");
    }

    @Override
    public void setReporter(Reporter reporter) {
        super.setReporter(reporter);
        this.reporter = reporter;
    }

    @Override
    public File put(Jar jar) throws Exception {
        File dir;
        this.dirty = true;
        Manifest manifest = jar.getManifest();
        if (manifest == null) {
            throw new IllegalArgumentException("No manifest in JAR: " + jar);
        }
        String bsn = manifest.getMainAttributes().getValue("Bundle-SymbolicName");
        if (bsn == null) {
            throw new IllegalArgumentException("No Bundle SymbolicName set");
        }
        Map<String, Map<String, String>> b = Processor.parseHeader(bsn, null);
        if (b.size() != 1) {
            throw new IllegalArgumentException("Multiple bsn's specified " + b);
        }
        for (String key : b.keySet()) {
            bsn = key;
            if (Verifier.SYMBOLICNAME.matcher(bsn).matches()) continue;
            throw new IllegalArgumentException("Bundle SymbolicName has wrong format: " + bsn);
        }
        String versionString = manifest.getMainAttributes().getValue("Bundle-Version");
        Version version = versionString == null ? new Version() : new Version(versionString);
        if (this.group == null) {
            dir = this.getRoot();
        } else {
            dir = new File(this.getRoot(), this.group);
            dir.mkdirs();
        }
        String fName = bsn + "-" + version.getMajor() + "." + version.getMinor() + "." + version.getMicro() + ".jar";
        File file = new File(dir, fName);
        System.out.println("put" + file.getAbsolutePath() + " " + file.lastModified() + " " + jar.lastModified());
        System.out.println("Updating " + fName);
        jar.write(file);
        file = new File(dir, bsn + "-latest.jar");
        if (file.isFile() && file.lastModified() < jar.lastModified()) {
            jar.write(file);
        }
        return file;
    }

    @Override
    public boolean refresh() {
        if (this.dirty) {
            this.dirty = false;
            return true;
        }
        return false;
    }

    @Override
    public List<String> list(String regex) {
        Instruction pattern = null;
        if (regex != null) {
            pattern = Instruction.getPattern(regex);
        }
        String[] list = this.getRoot().list();
        ArrayList<String> result = new ArrayList<String>();
        for (String f : list) {
            Matcher m = this.REPO_FILE.matcher(f);
            if (!m.matches()) continue;
            String s = m.group(1);
            if (pattern != null && !pattern.matches(s)) continue;
            result.add(s);
        }
        return result;
    }

    @Override
    public File[] get(String bsn, String versionRange) throws MalformedURLException {
        if (versionRange != null && versionRange.equals("project")) {
            return null;
        }
        VersionRange range = versionRange == null || versionRange.equals("latest") ? new VersionRange("0") : new VersionRange(versionRange);
        File[] instances = this.getRoot().listFiles();
        TreeMap<Version, File> versions = new TreeMap<Version, File>();
        for (int i = 0; i < instances.length; ++i) {
            String versionString;
            Version version;
            Matcher m = this.REPO_FILE.matcher(instances[i].getName());
            if (!m.matches() || !m.group(1).equals(bsn) || !range.includes(version = (versionString = m.group(2)).equals("latest") ? new Version(Integer.MAX_VALUE) : new Version(versionString))) continue;
            versions.put(version, instances[i]);
        }
        return versions.values().toArray(new File[versions.size()]);
    }
}

