/*
 * Decompiled with CFR 0.152.
 */
package org.slf4j.impl;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.slf4j.ILoggerFactory;
import org.slf4j.Logger;
import org.slf4j.helpers.Util;
import org.slf4j.impl.JCLLoggerAdapter;

public class JCLLoggerFactory
implements ILoggerFactory {
    private static final String JCL_DELEGATION_LOOP_URL = "http://www.slf4j.org/codes.html#jclDelegationLoop";
    Map loggerMap = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Logger getLogger(String name) {
        Logger logger = null;
        JCLLoggerFactory jCLLoggerFactory = this;
        synchronized (jCLLoggerFactory) {
            logger = (Logger)this.loggerMap.get(name);
            if (logger == null) {
                Log jclLogger = LogFactory.getLog((String)name);
                logger = new JCLLoggerAdapter(jclLogger, name);
                this.loggerMap.put(name, logger);
            }
        }
        return logger;
    }

    static {
        try {
            Class.forName("org.apache.commons.logging.impl.SLF4JLogFactory");
            String part1 = "Detected both jcl-over-slf4j.jar AND slf4j-jcl.jar on the class path, preempting StackOverflowError. ";
            String part2 = "See also http://www.slf4j.org/codes.html#jclDelegationLoop for more details.";
            Util.report(part1);
            Util.report(part2);
            throw new IllegalStateException(part1 + part2);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return;
        }
    }
}

