/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.web.jetty8;

import java.lang.reflect.Field;
import java.net.URL;
import java.util.List;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import org.apache.jasper.EmbeddedServletOptions;
import org.apache.jasper.runtime.TldScanner;
import org.apache.jasper.servlet.JspServlet;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.eclipse.jetty.util.component.LifeCycle;
import org.ow2.jonas.web.jetty8.JOnASTldScanner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSPLifecycleListener
extends AbstractLifeCycle.AbstractLifeCycleListener
implements LifeCycle.Listener {
    private List<URL> resourcesToMonitor = null;

    public JSPLifecycleListener(List<URL> resourcesToMonitor) {
        this.resourcesToMonitor = resourcesToMonitor;
    }

    public void lifeCycleStarted(LifeCycle lifecycle) {
        if (lifecycle instanceof ServletHolder) {
            Servlet servlet;
            ServletHolder servletHolder = (ServletHolder)lifecycle;
            try {
                servlet = servletHolder.getServlet();
            }
            catch (ServletException e) {
                return;
            }
            if (servlet instanceof JspServlet) {
                JspServlet jspServlet = (JspServlet)servlet;
                Field optionsField = null;
                try {
                    optionsField = JspServlet.class.getDeclaredField("options");
                }
                catch (SecurityException e) {
                    return;
                }
                catch (NoSuchFieldException e) {
                    return;
                }
                optionsField.setAccessible(true);
                Object options = null;
                try {
                    options = optionsField.get((Object)jspServlet);
                }
                catch (IllegalArgumentException e) {
                    return;
                }
                catch (IllegalAccessException e) {
                    return;
                }
                if (options instanceof EmbeddedServletOptions) {
                    Field tldScannerField;
                    EmbeddedServletOptions embeddedServletOptions = (EmbeddedServletOptions)options;
                    TldScanner tldScanner = embeddedServletOptions.getTldScanner();
                    try {
                        tldScannerField = EmbeddedServletOptions.class.getDeclaredField("tldScanner");
                    }
                    catch (SecurityException e) {
                        return;
                    }
                    catch (NoSuchFieldException e) {
                        return;
                    }
                    tldScannerField.setAccessible(true);
                    JOnASTldScanner jOnASTldScanner = new JOnASTldScanner(tldScanner, this.resourcesToMonitor);
                    try {
                        tldScannerField.set(embeddedServletOptions, jOnASTldScanner);
                    }
                    catch (IllegalArgumentException e) {
                        return;
                    }
                    catch (IllegalAccessException e) {
                        return;
                    }
                }
            }
        }
    }
}

