/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.shell.gui.plugin;

import java.awt.Font;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class ScrollableOutputArea
extends JScrollPane {
    private JTextArea m_textArea = null;

    public ScrollableOutputArea() {
        this.m_textArea = new JTextArea();
        this.initialize();
    }

    public ScrollableOutputArea(int rows, int columns) {
        this.m_textArea = new JTextArea(rows, columns);
        this.initialize();
    }

    private void initialize() {
        this.setViewportView(this.m_textArea);
        this.m_textArea.setLineWrap(true);
        this.m_textArea.setAutoscrolls(true);
        this.m_textArea.setEnabled(true);
        this.m_textArea.setEditable(false);
        this.m_textArea.setFont(new Font("Monospaced", 0, 12));
        this.setAutoscrolls(true);
    }

    public void setText(String s) {
        this.m_textArea.setText(s);
    }

    public void addText(String text) {
        this.m_textArea.append(text);
        if (this.m_textArea.isDisplayable()) {
            try {
                this.m_textArea.setCaretPosition(Integer.MAX_VALUE);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        this.validate();
        JScrollBar sb = this.getVerticalScrollBar();
        if (sb != null && sb.isVisible()) {
            sb.setValue(Integer.MAX_VALUE);
        }
    }
}

