/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.spec.ee.jaxrs;

import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.Variant;
import javax.ws.rs.ext.RuntimeDelegate;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ForwardingRuntimeDelegate
extends RuntimeDelegate
implements ServiceListener {
    private BundleContext bundleContext;
    private Map<ServiceReference, RuntimeDelegate> delegates;
    private RuntimeDelegate preferred;

    public ForwardingRuntimeDelegate(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
        this.delegates = new HashMap<ServiceReference, RuntimeDelegate>();
    }

    @Override
    public UriBuilder createUriBuilder() {
        this.checkDelegateIsAvailable();
        return this.preferred.createUriBuilder();
    }

    @Override
    public Response.ResponseBuilder createResponseBuilder() {
        this.checkDelegateIsAvailable();
        return this.preferred.createResponseBuilder();
    }

    @Override
    public Variant.VariantListBuilder createVariantListBuilder() {
        this.checkDelegateIsAvailable();
        return this.preferred.createVariantListBuilder();
    }

    @Override
    public <T> T createEndpoint(Application application, Class<T> endpointType) throws IllegalArgumentException, UnsupportedOperationException {
        this.checkDelegateIsAvailable();
        return this.preferred.createEndpoint(application, endpointType);
    }

    @Override
    public <T> RuntimeDelegate.HeaderDelegate<T> createHeaderDelegate(Class<T> type) {
        this.checkDelegateIsAvailable();
        return this.preferred.createHeaderDelegate(type);
    }

    public void serviceChanged(ServiceEvent event) {
        switch (event.getType()) {
            case 2: {
                this.onModification(event.getServiceReference());
                break;
            }
            case 1: {
                this.onRegistration(event.getServiceReference());
                break;
            }
            case 4: {
                this.onUnregistration(event.getServiceReference());
            }
        }
    }

    public void onModification(ServiceReference reference) {
    }

    public void onRegistration(ServiceReference reference) {
        RuntimeDelegate delegate = (RuntimeDelegate)this.bundleContext.getService(reference);
        this.delegates.put(reference, delegate);
        if (this.preferred == null) {
            this.preferred = delegate;
        }
    }

    public void onUnregistration(ServiceReference reference) {
        RuntimeDelegate delegate = this.delegates.remove(reference);
        if (this.preferred == delegate) {
            this.preferred = this.getFirstAvailable();
        }
    }

    private RuntimeDelegate getFirstAvailable() {
        RuntimeDelegate delegate = null;
        if (!this.delegates.isEmpty()) {
            delegate = this.delegates.values().iterator().next();
        }
        return delegate;
    }

    public void start() throws Exception {
        ServiceReference[] references = this.bundleContext.getServiceReferences(RuntimeDelegate.class.getName(), null);
        if (references != null) {
            for (ServiceReference reference : references) {
                this.onRegistration(reference);
            }
        }
        this.bundleContext.addServiceListener((ServiceListener)this, "(objectClass=" + RuntimeDelegate.class.getName() + ")");
    }

    public void stop() {
        this.bundleContext.removeServiceListener((ServiceListener)this);
        this.delegates.clear();
    }

    private void checkDelegateIsAvailable() {
        if (this.preferred == null) {
            throw new IllegalStateException("No " + RuntimeDelegate.class.getName() + " service is available.");
        }
    }
}

