/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.util.event.impl;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Semaphore;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.ow2.util.event.api.EventPriority;
import org.ow2.util.event.api.IEvent;
import org.ow2.util.event.api.IEventDispatcher;
import org.ow2.util.event.api.IEventListener;
import org.ow2.util.event.api.IEventToken;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

public class EventDispatcher
implements IEventDispatcher {
    private static final int DEFAULT_SIZE = 1;
    private Log logger = LogFactory.getLog(EventDispatcher.class);
    private final HashMap<EventPriority, CopyOnWriteArrayList<IEventListener>> listeners;
    private final EventQueue queue;
    private final EventToken kill = new EventToken();
    private AtomicBoolean available;
    private AtomicInteger size;

    public EventDispatcher() {
        this.queue = new EventQueue();
        this.available = new AtomicBoolean(false);
        this.size = new AtomicInteger(1);
        this.listeners = new HashMap();
        for (EventPriority priority : EventPriority.values()) {
            this.listeners.put(priority, new CopyOnWriteArrayList());
        }
    }

    public void start() {
        boolean old = this.available.getAndSet(true);
        if (!old) {
            this.createWorkers(this.size.get());
        }
    }

    public void stop() {
        boolean old = this.available.getAndSet(false);
        if (old) {
            this.destroyWorkers(this.size.get());
        }
    }

    public boolean isAvailable() {
        return this.available.get();
    }

    public int getNbWorkers() {
        return this.size.get();
    }

    public void setNbWorkers(int nbWorkers) {
        int diff = this.size.getAndSet(nbWorkers) - nbWorkers;
        if (this.available.get()) {
            if (diff > 0) {
                this.destroyWorkers(diff);
            } else {
                this.createWorkers(-diff);
            }
        }
    }

    public void addListener(IEventListener listener) {
        this.listeners.get(listener.getPriority()).add(listener);
    }

    public void removeListener(IEventListener listener) {
        this.listeners.get(listener.getPriority()).remove(listener);
    }

    public IEventToken dispatch(IEvent event) {
        return this.dispatch(event, EventPriority.NONE, Long.MAX_VALUE, 1);
    }

    public IEventToken dispatch(IEvent event, EventPriority priority) {
        return this.dispatch(event, priority, Long.MAX_VALUE, 1);
    }

    public IEventToken dispatch(IEvent event, long timeout) {
        return this.dispatch(event, EventPriority.NONE, timeout, 1);
    }

    public IEventToken dispatch(IEvent event, int nbWorker) {
        return this.dispatch(event, EventPriority.NONE, Long.MAX_VALUE, nbWorker);
    }

    public IEventToken dispatch(IEvent event, EventPriority priority, long timeout) {
        return this.dispatch(event, priority, timeout, 1);
    }

    public IEventToken dispatch(IEvent event, EventPriority priority, int nbWorker) {
        return this.dispatch(event, priority, Long.MAX_VALUE, nbWorker);
    }

    public IEventToken dispatch(IEvent event, long timeout, int nbWorker) {
        return this.dispatch(event, EventPriority.NONE, timeout, nbWorker);
    }

    public IEventToken dispatch(IEvent event, EventPriority priority, long timeout, int nbWorker) {
        if (!this.available.get()) {
            return null;
        }
        long end = System.currentTimeMillis() + timeout;
        if (end < 0L) {
            end = Long.MAX_VALUE;
        }
        EventToken token = new EventToken(event);
        for (int i = 0; i < nbWorker; ++i) {
            token.allocate();
        }
        if (priority != null) {
            while (System.currentTimeMillis() < end) {
                try {
                    token.join(priority, end - System.currentTimeMillis());
                    break;
                }
                catch (InterruptedException e) {
                }
            }
        }
        return token;
    }

    private void createWorkers(int nb) {
        for (int i = 0; i < nb; ++i) {
            EventWorker worker = new EventWorker();
            worker.setDaemon(true);
            worker.start();
        }
    }

    private void destroyWorkers(int nb) {
        EventToken kill = this.kill;
        EventQueue queue = this.queue;
        for (int i = 0; i < nb; ++i) {
            queue.put(kill);
        }
    }

    static /* synthetic */ EventToken access$200(EventDispatcher x0) {
        return x0.kill;
    }

    private final class EventToken
    implements IEventToken {
        private IEvent event;
        private boolean killed = false;
        private Semaphore lock = new Semaphore(1, true);
        private LinkedList<EventWorker> workers = new LinkedList();
        private ConcurrentLinkedQueue<IEventListener> listeners = new ConcurrentLinkedQueue();
        private Map<EventPriority, Semaphore> semaphores = new HashMap<EventPriority, Semaphore>();
        private Map<EventPriority, AtomicInteger> counts = new HashMap<EventPriority, AtomicInteger>();

        private EventToken() {
        }

        private EventToken(IEvent event) {
            this.event = event;
            int permit = 1;
            for (EventPriority priority : EventPriority.values()) {
                int count = 0;
                this.semaphores.put(priority, new Semaphore(permit, true));
                for (IEventListener listener : (CopyOnWriteArrayList)EventDispatcher.this.listeners.get(priority)) {
                    if (!event.checkPermission(listener) || !listener.accept(event)) continue;
                    this.listeners.add(listener);
                    permit = 0;
                    ++count;
                }
                this.counts.put(priority, new AtomicInteger(count));
            }
            this.semaphores.put(null, new Semaphore(permit, true));
            this.counts.put(null, new AtomicInteger(0));
        }

        public void terminate() {
            EventDispatcher.this.logger.debug((Object)"EventToken {0} terminating.", new Object[]{this});
            this.lock.acquireUninterruptibly();
            this.killed = true;
            EventDispatcher.this.createWorkers(this.workers.size());
            for (EventWorker worker : this.workers) {
                worker.stop();
            }
            for (Semaphore semaphore : this.semaphores.values()) {
                semaphore.release();
            }
            this.listeners.clear();
            this.lock.release();
            EventDispatcher.this.logger.debug((Object)"EventToken {0} terminated.", new Object[]{this});
        }

        public void allocate() {
            EventDispatcher.this.queue.put(this);
        }

        public boolean join(long timeout) throws InterruptedException {
            return this.join(EventPriority.values()[EventPriority.values().length - 1], timeout, false);
        }

        public boolean join(long timeout, boolean kill) throws InterruptedException {
            return this.join(EventPriority.values()[EventPriority.values().length - 1], timeout, kill);
        }

        public boolean join(EventPriority priority, long timeout) throws InterruptedException {
            return this.join(priority, timeout, false);
        }

        public boolean join(EventPriority priority, long timeout, boolean kill) throws InterruptedException {
            int nextOrdinal = priority.ordinal() + 1;
            EventPriority nextPriority = nextOrdinal < EventPriority.values().length ? EventPriority.values()[nextOrdinal] : null;
            Semaphore semaphore = this.semaphores.get(nextPriority);
            boolean ok = semaphore.tryAcquire(timeout, TimeUnit.MILLISECONDS);
            if (ok) {
                semaphore.release();
            } else if (kill) {
                this.terminate();
            }
            return ok;
        }

        static /* synthetic */ Semaphore access$300(EventToken x0) {
            return x0.lock;
        }

        static /* synthetic */ boolean access$400(EventToken x0) {
            return x0.killed;
        }

        static /* synthetic */ LinkedList access$500(EventToken x0) {
            return x0.workers;
        }

        static /* synthetic */ ConcurrentLinkedQueue access$600(EventToken x0) {
            return x0.listeners;
        }

        static /* synthetic */ Map access$700(EventToken x0) {
            return x0.semaphores;
        }

        static /* synthetic */ IEvent access$800(EventToken x0) {
            return x0.event;
        }

        static /* synthetic */ Map access$900(EventToken x0) {
            return x0.counts;
        }
    }

    private final class EventWorker
    extends Thread {
        private EventWorker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            try {
                EventDispatcher.access$000(EventDispatcher.this).debug((Object)"EventWorker {0} started.", new Object[]{this});
                this.setName("EventWorker");
                queue = EventDispatcher.access$100(EventDispatcher.this);
                kill = EventDispatcher.access$200(EventDispatcher.this);
lbl6:
                // 4 sources

                while (true) {
                    token = queue.take();
                    if (token == kill) {
                    }
                    ** GOTO lbl-1000
                    break;
                }
            }
            catch (Throwable fault) {
                EventDispatcher.access$000(EventDispatcher.this).debug((Object)"EventWorker {0} died due to an unknown error. {1}", new Object[]{this, fault});
                EventDispatcher.access$1000(EventDispatcher.this, 1);
                var15_16 = null;
                EventDispatcher.access$000(EventDispatcher.this).debug((Object)"EventWorker {0} finished.", new Object[]{this});
                return;
            }
            catch (Throwable var14_18) {
                var15_17 = null;
                EventDispatcher.access$000(EventDispatcher.this).debug((Object)"EventWorker {0} finished.", new Object[]{this});
                throw var14_18;
            }
            EventDispatcher.access$000(EventDispatcher.this).debug((Object)"EventWorker {0} finished.", new Object[]{this});
            return;
lbl-1000:
            // 1 sources

            {
                try {
                    block20: {
                        EventToken.access$300(token).acquireUninterruptibly();
                        if (!EventToken.access$400(token)) break block20;
                        EventToken.access$300(token).release();
                        ** GOTO lbl6
                    }
                    EventToken.access$500(token).add(this);
                    EventToken.access$300(token).release();
                    try {
                        block19: {
                            block14: while (true) lbl-1000:
                            // 3 sources

                            {
                                if ((listener = (IEventListener)EventToken.access$600(token).poll()) == null) break block19;
                                priority = listener.getPriority();
                                semaphore = (Semaphore)EventToken.access$700(token).get(priority);
                                semaphore.acquireUninterruptibly();
                                semaphore.release();
                                try {
                                    listener.handle(EventToken.access$800(token));
                                }
                                catch (Throwable fault) {
                                    EventDispatcher.access$000(EventDispatcher.this).debug((Object)"Listener {0} failed due to an unknown error. {1}", new Object[]{listener, fault});
                                    var9_10 = null;
                                    count = ((AtomicInteger)EventToken.access$900(token).get(priority)).decrementAndGet();
                                    while (true) {
                                        if (count != 0 || priority == null) ** GOTO lbl-1000
                                        nextOrdinal = priority.ordinal() + 1;
                                        priority = nextOrdinal < EventPriority.values().length ? EventPriority.values()[nextOrdinal] : null;
                                        semaphore = (Semaphore)EventToken.access$700(token).get(priority);
                                        count = ((AtomicInteger)EventToken.access$900(token).get(priority)).get();
                                        semaphore.release();
                                    }
                                }
                                var9_10 = null;
                                count = ((AtomicInteger)EventToken.access$900(token).get(priority)).decrementAndGet();
                                while (true) {
                                    if (count != 0 || priority == null) continue block14;
                                    nextOrdinal = priority.ordinal() + 1;
                                    priority = nextOrdinal < EventPriority.values().length ? EventPriority.values()[nextOrdinal] : null;
                                    semaphore = (Semaphore)EventToken.access$700(token).get(priority);
                                    count = ((AtomicInteger)EventToken.access$900(token).get(priority)).get();
                                    semaphore.release();
                                }
                                break;
                            }
                            catch (Throwable var8_14) {
                                var9_10 = null;
                                count = ((AtomicInteger)EventToken.access$900(token).get(priority)).decrementAndGet();
                                while (count == 0) {
                                    if (priority == null) throw var8_14;
                                    nextOrdinal = priority.ordinal() + 1;
                                    priority = nextOrdinal < EventPriority.values().length ? EventPriority.values()[nextOrdinal] : null;
                                    semaphore = (Semaphore)EventToken.access$700(token).get(priority);
                                    count = ((AtomicInteger)EventToken.access$900(token).get(priority)).get();
                                    semaphore.release();
                                }
                                throw var8_14;
                            }
                        }
                        var13_13 = null;
                        EventToken.access$300(token).acquireUninterruptibly();
                        EventToken.access$500(token).remove(this);
                        EventToken.access$300(token).release();
                        ** GOTO lbl6
                    }
                    catch (Throwable var12_15) {
                        var13_13 = null;
                        EventToken.access$300(token).acquireUninterruptibly();
                        EventToken.access$500(token).remove(this);
                        EventToken.access$300(token).release();
                        throw var12_15;
                    }
                }
                catch (Throwable fault) {
                    EventDispatcher.access$000(EventDispatcher.this).debug((Object)"EventWorker {0} failed due to an unknown error. {1}", new Object[]{this, fault});
                    token.terminate();
                    ** continue;
                }
            }
        }
    }

    private final class EventQueue {
        private static final long SYNC_POLL_TIME = 1000L;
        private final SynchronousQueue<EventToken> synchronousQueue = new SynchronousQueue(true);
        private final ConcurrentLinkedQueue<EventToken> concurrentLinkedQueue = new ConcurrentLinkedQueue();

        private EventQueue() {
        }

        public void put(EventToken token) {
            if (!this.synchronousQueue.offer(token)) {
                this.concurrentLinkedQueue.offer(token);
            }
        }

        public EventToken take() throws InterruptedException {
            EventToken token;
            do {
                if ((token = this.concurrentLinkedQueue.poll()) == null) continue;
                return token;
            } while ((token = this.synchronousQueue.poll(1000L, TimeUnit.MILLISECONDS)) == null);
            return token;
        }
    }
}

