/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.lib.util;

import java.io.File;
import java.lang.reflect.Method;
import java.rmi.Remote;
import java.util.StringTokenizer;
import javax.ejb.EJBHome;
import javax.ejb.EJBLocalHome;
import javax.ejb.EJBLocalObject;
import javax.ejb.EJBObject;
import javax.security.jacc.EJBMethodPermission;

public class BeanNaming {
    public static String getPackageName(String name) {
        if (name == null) {
            return null;
        }
        int idx = name.lastIndexOf(46);
        return idx == -1 ? "" : name.substring(0, idx);
    }

    public static String getClassName(String packageName, String name) {
        return packageName.length() == 0 ? name : packageName + "." + name;
    }

    public static String getBaseName(String fullName) {
        String baseName = null;
        if (fullName != null) {
            int idx = fullName.lastIndexOf(46);
            int len = fullName.length();
            baseName = idx == -1 ? fullName : (idx != len - 1 ? fullName.substring(idx + 1, len) : "");
        }
        return baseName;
    }

    public static String getPath(String fullName) {
        String pkg = new String();
        StringTokenizer stk = new StringTokenizer(fullName, ".");
        int nb = stk.countTokens();
        for (int i = 0; i < nb; ++i) {
            pkg = pkg.concat(stk.nextToken());
            if (i >= nb - 1) continue;
            pkg = pkg + File.separatorChar;
        }
        return pkg;
    }

    public static String firstToUpperCase(String s) {
        String value;
        if (s.length() > 0) {
            char c = Character.toUpperCase(s.charAt(0));
            value = new String(c + s.substring(1));
        } else {
            value = new String();
        }
        return value;
    }

    public static String getJonasXmlName(String stdXmlName) {
        String jonasXmlName = new String();
        File f = new File(stdXmlName);
        String p = f.getParent();
        String n = f.getName();
        if (p != null) {
            jonasXmlName = jonasXmlName.concat(p);
            jonasXmlName = jonasXmlName.concat(File.separator);
        }
        jonasXmlName = jonasXmlName.concat("jonas-");
        jonasXmlName = jonasXmlName.concat(n);
        return jonasXmlName;
    }

    public static String getParentName(String fileName) {
        File f = new File(fileName);
        return f.getParent();
    }

    public static String getSignature(String ejbName, Method method) {
        Class<?> clazz = method.getDeclaringClass();
        String methItf = "";
        if (EJBHome.class.isAssignableFrom(clazz)) {
            methItf = "Home";
        } else if (EJBObject.class.isAssignableFrom(clazz)) {
            methItf = "Remote";
        } else if (EJBLocalHome.class.isAssignableFrom(clazz)) {
            methItf = "LocalHome";
        } else if (EJBLocalObject.class.isAssignableFrom(clazz)) {
            methItf = "Local";
        } else if (Remote.class.isAssignableFrom(clazz)) {
            methItf = "ServiceEndpoint";
        }
        return new EJBMethodPermission(ejbName, methItf, method).getActions();
    }
}

