/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.util.monolog.file.monolog;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Properties;

public class MonologPropertiesIO {
    public static final char[] PROP_VAL_SEPS = new char[]{'=', ' '};
    public static final String[] keywords = new String[]{"logger.", "handler.", "level."};

    public static void writeProperties(Properties props, OutputStream os) throws IOException {
        String key;
        int i;
        BufferedWriter w = new BufferedWriter(new OutputStreamWriter(os));
        ArrayList<Object> keys = new ArrayList<Object>(props.keySet());
        Collections.sort(keys);
        ArrayList<String> loggers = new ArrayList<String>();
        ArrayList<String> handlers = new ArrayList<String>();
        ArrayList<String> levels = new ArrayList<String>();
        for (i = 0; i < keys.size(); ++i) {
            key = (String)keys.get(i);
            if (key.startsWith("logger")) {
                if (key.startsWith("logger.root.")) {
                    loggers.add(0, key);
                    continue;
                }
                loggers.add(key);
                continue;
            }
            if (key.startsWith("handler")) {
                handlers.add(key);
                continue;
            }
            if (!key.startsWith("level")) continue;
            levels.add(key);
        }
        keys = null;
        w.write("#Generated by Monolog the ");
        w.write(DateFormat.getInstance().format(Calendar.getInstance().getTime()));
        if (levels.size() > 0) {
            w.newLine();
            w.newLine();
            w.write("#Level configuration");
            w.newLine();
            for (i = 0; i < levels.size(); ++i) {
                key = (String)levels.get(i);
                w.write(key);
                w.write(PROP_VAL_SEPS[0]);
                w.write(props.getProperty(key));
                w.newLine();
            }
        }
        if (handlers.size() > 0) {
            w.newLine();
            w.newLine();
            w.write("#Handler configuration");
            w.newLine();
            for (i = 0; i < handlers.size(); ++i) {
                key = (String)handlers.get(i);
                if (key.endsWith(".activation")) continue;
                w.write(key);
                w.write(PROP_VAL_SEPS[0]);
                w.write(props.getProperty(key));
                w.newLine();
            }
        }
        if (loggers.size() > 0) {
            w.newLine();
            w.newLine();
            w.write("#Logger configuration");
            w.newLine();
            for (i = 0; i < loggers.size(); ++i) {
                key = (String)loggers.get(i);
                String value = props.getProperty(key);
                if (key.endsWith(".additivity") && Boolean.valueOf(value).booleanValue()) continue;
                if (key.endsWith(".level") && "INHERIT".equalsIgnoreCase(value)) {
                    key = '#' + key;
                }
                w.write(key);
                w.write(PROP_VAL_SEPS[0]);
                w.write(value);
                w.newLine();
            }
        }
        w.flush();
    }

    public static Properties readProperties(InputStream is) throws IOException {
        Properties props = new Properties();
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        while (br.ready()) {
            int keywordIdx;
            int nc;
            String p = br.readLine();
            if (p == null || p.length() == 0) continue;
            p = p.replace('\r', ' ').trim();
            boolean isComment = false;
            for (nc = 0; nc < p.length() && p.charAt(nc) == '#'; ++nc) {
                isComment = true;
            }
            if (nc == p.length()) continue;
            if (isComment) {
                p = p.substring(nc).trim();
            }
            for (keywordIdx = 0; keywordIdx < keywords.length && !p.startsWith(keywords[keywordIdx]); ++keywordIdx) {
            }
            int sepIdx = -1;
            if (keywordIdx < keywords.length) {
                for (int i = 0; sepIdx == -1 && i < PROP_VAL_SEPS.length; ++i) {
                    sepIdx = p.indexOf(PROP_VAL_SEPS[i]);
                }
            }
            if (sepIdx == -1) continue;
            String key = p.substring(0, sepIdx);
            String value = p.substring(sepIdx + 1).trim();
            if (isComment) {
                if (keywordIdx != 0 || !key.endsWith(".level")) continue;
                props.put(key, "INHERIT");
                continue;
            }
            props.put(key, value);
        }
        return props;
    }
}

