/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.audit.jms.interceptor;

import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Session;
import org.objectweb.joram.client.jms.MessageInterceptor;
import org.ow2.util.auditreport.api.IAuditID;
import org.ow2.util.auditreport.api.ICurrentInvocationID;
import org.ow2.util.auditreport.impl.CurrentInvocationID;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

public class JMSClientInterceptor
implements MessageInterceptor {
    private Log logger = LogFactory.getLog(JMSClientInterceptor.class);

    public void handle(Message msg, Session session) {
        ICurrentInvocationID currentInvocationID = CurrentInvocationID.getInstance();
        IAuditID localID = currentInvocationID.getAuditID();
        if (localID != null) {
            localID.increment();
            try {
                msg.setStringProperty(IAuditID.class.getName(), localID.getID());
            }
            catch (JMSException e) {
                this.logger.warn((Object)"Unable to set the property ''{0}'' on the message", new Object[]{IAuditID.class.getName(), e});
            }
        }
    }
}

