/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.services.bootstrap;

import java.io.File;
import java.io.FilenameFilter;
import java.util.Set;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.Pojo;
import org.ow2.jonas.configuration.ConfigurationManager;
import org.ow2.jonas.configuration.DeploymentPlanDeployer;
import org.ow2.jonas.lib.bootstrap.JProp;
import org.ow2.util.archive.api.IArchive;
import org.ow2.util.archive.impl.ArchiveManager;
import org.ow2.util.ee.deploy.api.deployable.IDeployable;
import org.ow2.util.ee.deploy.api.deployer.DeployerException;
import org.ow2.util.ee.deploy.impl.helper.DeployableHelper;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;
import org.ow2.util.plan.deployer.api.IDeploymentPlanDeployer;

public class JOnASDeploymentPlanDeployer
implements DeploymentPlanDeployer,
Pojo {
    private InstanceManager __IM;
    private boolean __FdeploymentPlanDeployer;
    private IDeploymentPlanDeployer deploymentPlanDeployer;
    private boolean __FconfigurationManager;
    private ConfigurationManager configurationManager;
    private boolean __Flogger;
    private Log logger;
    private static final String URL_INTERNAL_REPOSITORY = JProp.getRepositoriesRootDir() + File.separator + "url-internal";
    private boolean __Mdeploy$java_lang_String;
    private boolean __Mundeploy$java_lang_String;
    private boolean __MdeployDeploymentPlan$java_io_File;
    private boolean __MundeployDeploymentPlan$java_io_File;
    private boolean __MsetDeploymentPlanDeployer$org_ow2_util_plan_deployer_api_IDeploymentPlanDeployer;
    private boolean __MsetConfigurationManager$org_ow2_jonas_configuration_ConfigurationManager;
    private boolean __MgetImplementationName$java_lang_String;
    private boolean __MgetBaseName$java_lang_String;

    IDeploymentPlanDeployer __getdeploymentPlanDeployer() {
        if (!this.__FdeploymentPlanDeployer) {
            return this.deploymentPlanDeployer;
        }
        return (IDeploymentPlanDeployer)this.__IM.onGet((Object)this, "deploymentPlanDeployer");
    }

    void __setdeploymentPlanDeployer(IDeploymentPlanDeployer iDeploymentPlanDeployer) {
        if (!this.__FdeploymentPlanDeployer) {
            this.deploymentPlanDeployer = iDeploymentPlanDeployer;
            return;
        }
        this.__IM.onSet((Object)this, "deploymentPlanDeployer", (Object)iDeploymentPlanDeployer);
    }

    ConfigurationManager __getconfigurationManager() {
        if (!this.__FconfigurationManager) {
            return this.configurationManager;
        }
        return (ConfigurationManager)this.__IM.onGet((Object)this, "configurationManager");
    }

    void __setconfigurationManager(ConfigurationManager configurationManager) {
        if (!this.__FconfigurationManager) {
            this.configurationManager = configurationManager;
            return;
        }
        this.__IM.onSet((Object)this, "configurationManager", (Object)configurationManager);
    }

    Log __getlogger() {
        if (!this.__Flogger) {
            return this.logger;
        }
        return (Log)this.__IM.onGet((Object)this, "logger");
    }

    void __setlogger(Log log) {
        if (!this.__Flogger) {
            this.logger = log;
            return;
        }
        this.__IM.onSet((Object)this, "logger", (Object)log);
    }

    public JOnASDeploymentPlanDeployer() {
        this(null);
    }

    private JOnASDeploymentPlanDeployer(InstanceManager _manager) {
        this._setInstanceManager(_manager);
        this.__setdeploymentPlanDeployer(null);
        this.__setconfigurationManager(null);
        this.__setlogger(LogFactory.getLog(JOnASDeploymentPlanDeployer.class));
    }

    public void deploy(String string) throws DeployerException {
        if (!this.__Mdeploy$java_lang_String) {
            this.__deploy(string);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "deploy$java_lang_String", new Object[]{string});
            this.__deploy(string);
            this.__IM.onExit((Object)this, "deploy$java_lang_String", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "deploy$java_lang_String", throwable);
            throw throwable;
        }
    }

    private void __deploy(String name) throws DeployerException {
        File file;
        String service = name;
        String baseName = this.getBaseName(service);
        if (baseName != null) {
            this.deploy(baseName);
            service = this.getImplementationName(service);
        }
        if (!(file = new File(URL_INTERNAL_REPOSITORY, service + ".xml")).exists()) {
            throw new DeployerException("Cannot deploy the deployment plan '" + name + "', file '" + file + "' not found");
        }
        this.deployDeploymentPlan(file);
    }

    public void undeploy(String string) throws DeployerException {
        if (!this.__Mundeploy$java_lang_String) {
            this.__undeploy(string);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "undeploy$java_lang_String", new Object[]{string});
            this.__undeploy(string);
            this.__IM.onExit((Object)this, "undeploy$java_lang_String", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "undeploy$java_lang_String", throwable);
            throw throwable;
        }
    }

    private void __undeploy(String name) throws DeployerException {
        File file;
        String service = name;
        String baseName = this.getBaseName(service);
        if (baseName != null) {
            this.undeploy(baseName);
            service = this.getImplementationName(service);
        }
        if (!(file = new File(URL_INTERNAL_REPOSITORY, service + ".xml")).exists()) {
            throw new DeployerException("Cannot undeploy the deployment plan '" + name + "', file '" + file + "' not found");
        }
        this.undeployDeploymentPlan(file);
    }

    private void deployDeploymentPlan(File file) throws DeployerException {
        if (!this.__MdeployDeploymentPlan$java_io_File) {
            this.__deployDeploymentPlan(file);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "deployDeploymentPlan$java_io_File", new Object[]{file});
            this.__deployDeploymentPlan(file);
            this.__IM.onExit((Object)this, "deployDeploymentPlan$java_io_File", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "deployDeploymentPlan$java_io_File", throwable);
            throw throwable;
        }
    }

    private void __deployDeploymentPlan(File file) throws DeployerException {
        this.__getlogger().debug((Object)"Deploying the deployment plan for ''{0}''", new Object[]{file});
        IArchive archive = ArchiveManager.getInstance().getArchive((Object)file);
        if (archive == null) {
            throw new DeployerException("Ignoring invalid file '" + file + "'");
        }
        IDeployable deployable = null;
        try {
            deployable = DeployableHelper.getDeployable((IArchive)archive);
            this.__getdeploymentPlanDeployer().deploy(deployable);
        }
        catch (Exception e) {
            throw new DeployerException("Cannot deploy the deployment plan for '" + file + "'", (Throwable)e);
        }
    }

    private void undeployDeploymentPlan(File file) throws DeployerException {
        if (!this.__MundeployDeploymentPlan$java_io_File) {
            this.__undeployDeploymentPlan(file);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "undeployDeploymentPlan$java_io_File", new Object[]{file});
            this.__undeployDeploymentPlan(file);
            this.__IM.onExit((Object)this, "undeployDeploymentPlan$java_io_File", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "undeployDeploymentPlan$java_io_File", throwable);
            throw throwable;
        }
    }

    private void __undeployDeploymentPlan(File file) throws DeployerException {
        this.__getlogger().debug((Object)"Undeploying the deployment plan for ''{0}''", new Object[]{file});
        IArchive archive = ArchiveManager.getInstance().getArchive((Object)file);
        if (archive == null) {
            throw new DeployerException("Ignoring invalid file '" + file + "'");
        }
        IDeployable deployable = null;
        try {
            deployable = DeployableHelper.getDeployable((IArchive)archive);
            this.__getdeploymentPlanDeployer().undeploy(deployable);
        }
        catch (Exception e) {
            throw new DeployerException("Cannot undeploy the deployment plan for '" + file + "'", (Throwable)e);
        }
    }

    public void setDeploymentPlanDeployer(IDeploymentPlanDeployer iDeploymentPlanDeployer) {
        if (!this.__MsetDeploymentPlanDeployer$org_ow2_util_plan_deployer_api_IDeploymentPlanDeployer) {
            this.__setDeploymentPlanDeployer(iDeploymentPlanDeployer);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "setDeploymentPlanDeployer$org_ow2_util_plan_deployer_api_IDeploymentPlanDeployer", new Object[]{iDeploymentPlanDeployer});
            this.__setDeploymentPlanDeployer(iDeploymentPlanDeployer);
            this.__IM.onExit((Object)this, "setDeploymentPlanDeployer$org_ow2_util_plan_deployer_api_IDeploymentPlanDeployer", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "setDeploymentPlanDeployer$org_ow2_util_plan_deployer_api_IDeploymentPlanDeployer", throwable);
            throw throwable;
        }
    }

    private void __setDeploymentPlanDeployer(IDeploymentPlanDeployer deploymentPlanDeployer) {
        this.__setdeploymentPlanDeployer(deploymentPlanDeployer);
    }

    public void setConfigurationManager(ConfigurationManager configurationManager) {
        if (!this.__MsetConfigurationManager$org_ow2_jonas_configuration_ConfigurationManager) {
            this.__setConfigurationManager(configurationManager);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "setConfigurationManager$org_ow2_jonas_configuration_ConfigurationManager", new Object[]{configurationManager});
            this.__setConfigurationManager(configurationManager);
            this.__IM.onExit((Object)this, "setConfigurationManager$org_ow2_jonas_configuration_ConfigurationManager", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "setConfigurationManager$org_ow2_jonas_configuration_ConfigurationManager", throwable);
            throw throwable;
        }
    }

    private void __setConfigurationManager(ConfigurationManager configurationManager) {
        this.__setconfigurationManager(configurationManager);
    }

    private String getImplementationName(String string) {
        String string2;
        if (!this.__MgetImplementationName$java_lang_String) {
            return this.__getImplementationName(string);
        }
        try {
            this.__IM.onEntry((Object)this, "getImplementationName$java_lang_String", new Object[]{string});
            string2 = this.__getImplementationName(string);
            this.__IM.onExit((Object)this, "getImplementationName$java_lang_String", (Object)string2);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getImplementationName$java_lang_String", throwable);
            throw throwable;
        }
        return string2;
    }

    private String __getImplementationName(String service) {
        String serviceClass = (String)this.__getconfigurationManager().getServiceProperties(service).get("class");
        String implementationName = serviceClass.split("\\.")[4];
        return service + "-" + implementationName;
    }

    private String getBaseName(String string) {
        String string2;
        if (!this.__MgetBaseName$java_lang_String) {
            return this.__getBaseName(string);
        }
        try {
            this.__IM.onEntry((Object)this, "getBaseName$java_lang_String", new Object[]{string});
            string2 = this.__getBaseName(string);
            this.__IM.onExit((Object)this, "getBaseName$java_lang_String", (Object)string2);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getBaseName$java_lang_String", throwable);
            throw throwable;
        }
        return string2;
    }

    private String __getBaseName(String service) {
        File configDir = new File(URL_INTERNAL_REPOSITORY);
        final String baseName = service + "-base";
        File[] base = configDir.listFiles(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.equalsIgnoreCase(baseName.concat(".xml"));
            }
        });
        if (base != null && base.length == 1) {
            return baseName;
        }
        return null;
    }

    private void _setInstanceManager(InstanceManager instanceManager) {
        if (instanceManager == null) {
            return;
        }
        this.__IM = instanceManager;
        Set set = this.__IM.getRegistredFields();
        if (set != null) {
            if (set.contains("deploymentPlanDeployer")) {
                this.__FdeploymentPlanDeployer = true;
            }
            if (set.contains("logger")) {
                this.__Flogger = true;
            }
            if (set.contains("configurationManager")) {
                this.__FconfigurationManager = true;
            }
        }
        if ((set = this.__IM.getRegistredMethods()) != null) {
            if (set.contains("deploy$java_lang_String")) {
                this.__Mdeploy$java_lang_String = true;
            }
            if (set.contains("undeploy$java_lang_String")) {
                this.__Mundeploy$java_lang_String = true;
            }
            if (set.contains("deployDeploymentPlan$java_io_File")) {
                this.__MdeployDeploymentPlan$java_io_File = true;
            }
            if (set.contains("undeployDeploymentPlan$java_io_File")) {
                this.__MundeployDeploymentPlan$java_io_File = true;
            }
            if (set.contains("setDeploymentPlanDeployer$org_ow2_util_plan_deployer_api_IDeploymentPlanDeployer")) {
                this.__MsetDeploymentPlanDeployer$org_ow2_util_plan_deployer_api_IDeploymentPlanDeployer = true;
            }
            if (set.contains("setConfigurationManager$org_ow2_jonas_configuration_ConfigurationManager")) {
                this.__MsetConfigurationManager$org_ow2_jonas_configuration_ConfigurationManager = true;
            }
            if (set.contains("getImplementationName$java_lang_String")) {
                this.__MgetImplementationName$java_lang_String = true;
            }
            if (set.contains("getBaseName$java_lang_String")) {
                this.__MgetBaseName$java_lang_String = true;
            }
        }
    }

    public ComponentInstance getComponentInstance() {
        return this.__IM;
    }
}

