/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.lib.management.reconfig.actuator;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import org.objectweb.util.monolog.api.BasicLevel;
import org.ow2.jonas.lib.management.reconfig.ReconfigException;
import org.ow2.jonas.lib.management.reconfig.actuator.BaseConfigurationActuator;

public class XMLConfigurationActuator
extends BaseConfigurationActuator {
    private String xml = null;

    public XMLConfigurationActuator(String name, String configFileName, String xml) {
        super(name, configFileName);
        this.xml = xml;
    }

    public void updateConfig(String xml, long sequence) {
        if (sequence > this.lastSequence) {
            this.xml = xml;
            this.lastSequence = sequence;
        } else {
            logger.log(BasicLevel.WARN, (Object)"Received out of order reconfiguration message !");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void saveConfig(long sequence) throws ReconfigException {
        if (sequence > this.lastSequence) {
            try {
                BufferedWriter out = new BufferedWriter(new FileWriter(new File(this.configFileName)));
                out.write(this.xml);
                out.flush();
                out.close();
                this.lastSequence = sequence;
                if (!logger.isLoggable(BasicLevel.DEBUG)) return;
                logger.log(BasicLevel.DEBUG, (Object)("Configuration file " + this.configFileName + " updated"));
                return;
            }
            catch (FileNotFoundException e) {
                throw new ReconfigException("Cant' save configuration file: " + e.toString());
            }
            catch (IOException ioe) {
                throw new ReconfigException("Cant' save configuration file: " + ioe.toString());
            }
        } else {
            logger.log(BasicLevel.WARN, (Object)("Received out of order save reconfiguration message for " + this.name + " !"));
            logger.log(BasicLevel.WARN, (Object)"Can not save !!");
            logger.log(BasicLevel.WARN, (Object)"Please reconfigure and than save !!");
        }
    }
}

