/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.naming.NamingException;
import javax.servlet.AsyncContext;
import javax.servlet.AsyncEvent;
import javax.servlet.AsyncListener;
import javax.servlet.DispatcherType;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.Context;
import org.apache.catalina.Globals;
import org.apache.catalina.connector.Request;
import org.apache.catalina.core.AsyncListenerWrapper;
import org.apache.catalina.core.DefaultInstanceManager;
import org.apache.catalina.core.StandardContext;
import org.apache.coyote.ActionCode;
import org.apache.coyote.AsyncContextCallback;
import org.apache.coyote.RequestInfo;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.InstanceManager;
import org.apache.tomcat.util.res.StringManager;

public class AsyncContextImpl
implements AsyncContext,
AsyncContextCallback {
    private static final Log log = LogFactory.getLog(AsyncContextImpl.class);
    protected static final StringManager sm = StringManager.getManager("org.apache.catalina.core");
    private ServletRequest servletRequest = null;
    private ServletResponse servletResponse = null;
    private List<AsyncListenerWrapper> listeners = new ArrayList<AsyncListenerWrapper>();
    private boolean hasOriginalRequestAndResponse = true;
    private volatile Runnable dispatch = null;
    private Context context = null;
    private long timeout = -1L;
    private AsyncEvent event = null;
    private Request request;
    private volatile InstanceManager instanceManager;

    public AsyncContextImpl(Request request) {
        if (log.isDebugEnabled()) {
            this.logDebug("Constructor");
        }
        this.request = request;
    }

    public void complete() {
        if (log.isDebugEnabled()) {
            this.logDebug("complete   ");
        }
        this.check();
        this.request.getCoyoteRequest().action(ActionCode.COMMIT, null);
        this.request.getCoyoteRequest().action(ActionCode.ASYNC_COMPLETE, null);
    }

    @Override
    public void fireOnComplete() {
        ArrayList<AsyncListenerWrapper> listenersCopy = new ArrayList<AsyncListenerWrapper>();
        listenersCopy.addAll(this.listeners);
        for (AsyncListenerWrapper listener : listenersCopy) {
            try {
                listener.fireOnComplete(this.event);
            }
            catch (IOException ioe) {
                log.warn("onComplete() failed for listener of type [" + listener.getClass().getName() + "]", ioe);
            }
        }
    }

    public boolean timeout() throws IOException {
        AtomicBoolean result = new AtomicBoolean();
        this.request.getCoyoteRequest().action(ActionCode.ASYNC_TIMEOUT, result);
        if (result.get()) {
            boolean listenerInvoked = false;
            ArrayList<AsyncListenerWrapper> listenersCopy = new ArrayList<AsyncListenerWrapper>();
            listenersCopy.addAll(this.listeners);
            for (AsyncListenerWrapper listener : listenersCopy) {
                listener.fireOnTimeout(this.event);
                listenerInvoked = true;
            }
            if (listenerInvoked) {
                this.request.getCoyoteRequest().action(ActionCode.ASYNC_IS_TIMINGOUT, result);
                return !result.get();
            }
            this.complete();
        }
        return true;
    }

    public void dispatch() {
        this.check();
        HttpServletRequest sr = (HttpServletRequest)this.getRequest();
        String path = sr.getRequestURI();
        String cpath = sr.getContextPath();
        if (cpath.length() > 1) {
            path = path.substring(cpath.length());
        }
        this.dispatch(path);
    }

    public void dispatch(String path) {
        this.check();
        this.dispatch(this.request.getServletContext(), path);
    }

    public void dispatch(ServletContext context, String path) {
        Runnable run;
        if (log.isDebugEnabled()) {
            this.logDebug("dispatch   ");
        }
        this.check();
        if (this.request.getAttribute("javax.servlet.async.request_uri") == null) {
            this.request.setAttribute("javax.servlet.async.request_uri", this.request.getRequestURI() + "?" + this.request.getQueryString());
            this.request.setAttribute("javax.servlet.async.context_path", this.request.getContextPath());
            this.request.setAttribute("javax.servlet.async.servlet_path", this.request.getServletPath());
            this.request.setAttribute("javax.servlet.async.query_string", this.request.getQueryString());
        }
        final RequestDispatcher requestDispatcher = context.getRequestDispatcher(path);
        final HttpServletRequest servletRequest = (HttpServletRequest)this.getRequest();
        final HttpServletResponse servletResponse = (HttpServletResponse)this.getResponse();
        this.dispatch = run = new Runnable(){

            @Override
            public void run() {
                AsyncContextImpl.this.request.getCoyoteRequest().action(ActionCode.ASYNC_DISPATCHED, null);
                DispatcherType type = (DispatcherType)AsyncContextImpl.this.request.getAttribute("org.apache.catalina.core.DISPATCHER_TYPE");
                try {
                    AsyncContextImpl.this.request.setAttribute("org.apache.catalina.core.DISPATCHER_TYPE", DispatcherType.ASYNC);
                    requestDispatcher.include((ServletRequest)servletRequest, (ServletResponse)servletResponse);
                }
                catch (Exception x) {
                    throw new RuntimeException(x);
                }
                finally {
                    AsyncContextImpl.this.request.setAttribute("org.apache.catalina.core.DISPATCHER_TYPE", type);
                }
            }
        };
        this.request.getCoyoteRequest().action(ActionCode.ASYNC_DISPATCH, null);
    }

    public ServletRequest getRequest() {
        this.check();
        return this.servletRequest;
    }

    public ServletResponse getResponse() {
        this.check();
        return this.servletResponse;
    }

    public void start(Runnable run) {
        if (log.isDebugEnabled()) {
            this.logDebug("start      ");
        }
        this.check();
        RunnableWrapper wrapper = new RunnableWrapper(run, this.context);
        this.request.getCoyoteRequest().action(ActionCode.ASYNC_RUN, wrapper);
    }

    public void addListener(AsyncListener listener) {
        this.check();
        AsyncListenerWrapper wrapper = new AsyncListenerWrapper();
        wrapper.setListener(listener);
        this.listeners.add(wrapper);
    }

    public void addListener(AsyncListener listener, ServletRequest servletRequest, ServletResponse servletResponse) {
        this.check();
        AsyncListenerWrapper wrapper = new AsyncListenerWrapper();
        wrapper.setListener(listener);
        this.listeners.add(wrapper);
    }

    public <T extends AsyncListener> T createListener(Class<T> clazz) throws ServletException {
        this.check();
        AsyncListener listener = null;
        try {
            listener = (AsyncListener)this.getInstanceManager().newInstance(clazz.getName(), clazz.getClassLoader());
        }
        catch (InstantiationException e) {
            ServletException se = new ServletException((Throwable)e);
            throw se;
        }
        catch (IllegalAccessException e) {
            ServletException se = new ServletException((Throwable)e);
            throw se;
        }
        catch (InvocationTargetException e) {
            ServletException se = new ServletException((Throwable)e);
            throw se;
        }
        catch (NamingException e) {
            ServletException se = new ServletException((Throwable)e);
            throw se;
        }
        catch (ClassNotFoundException e) {
            ServletException se = new ServletException((Throwable)e);
            throw se;
        }
        return (T)listener;
    }

    public void recycle() {
        if (log.isDebugEnabled()) {
            this.logDebug("recycle    ");
        }
        this.context = null;
        this.dispatch = null;
        this.event = null;
        this.hasOriginalRequestAndResponse = true;
        this.instanceManager = null;
        this.listeners.clear();
        this.request = null;
        this.servletRequest = null;
        this.servletResponse = null;
        this.timeout = -1L;
    }

    public boolean isStarted() {
        AtomicBoolean result = new AtomicBoolean(false);
        this.request.getCoyoteRequest().action(ActionCode.ASYNC_IS_STARTED, result);
        return result.get();
    }

    public void setStarted(Context context, ServletRequest request, ServletResponse response, boolean originalRequestResponse) {
        this.request.getCoyoteRequest().action(ActionCode.ASYNC_START, this);
        this.context = context;
        this.servletRequest = request;
        this.servletResponse = response;
        this.hasOriginalRequestAndResponse = originalRequestResponse;
        this.event = new AsyncEvent((AsyncContext)this, request, response);
        ArrayList<AsyncListenerWrapper> listenersCopy = new ArrayList<AsyncListenerWrapper>();
        listenersCopy.addAll(this.listeners);
        for (AsyncListenerWrapper listener : listenersCopy) {
            try {
                listener.fireOnStartAsync(this.event);
            }
            catch (IOException ioe) {
                log.warn("onStartAsync() failed for listener of type [" + listener.getClass().getName() + "]", ioe);
            }
        }
        this.listeners.clear();
    }

    public boolean hasOriginalRequestAndResponse() {
        this.check();
        return this.hasOriginalRequestAndResponse;
    }

    protected void doInternalDispatch() throws ServletException, IOException {
        if (log.isDebugEnabled()) {
            this.logDebug("intDispatch");
        }
        try {
            this.dispatch.run();
            if (!this.request.isAsync()) {
                this.fireOnComplete();
            }
        }
        catch (RuntimeException x) {
            if (x.getCause() instanceof ServletException) {
                throw (ServletException)x.getCause();
            }
            if (x.getCause() instanceof IOException) {
                throw (IOException)x.getCause();
            }
            throw new ServletException((Throwable)x);
        }
    }

    public long getTimeout() {
        this.check();
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.check();
        this.timeout = timeout;
        this.request.getCoyoteRequest().action(ActionCode.ASYNC_SETTIMEOUT, timeout);
    }

    public void setErrorState(Throwable t) {
        if (t != null) {
            this.request.setAttribute("javax.servlet.error.exception", t);
        }
        this.request.getCoyoteRequest().action(ActionCode.ASYNC_ERROR, null);
        AsyncEvent errorEvent = new AsyncEvent(this.event.getAsyncContext(), this.event.getSuppliedRequest(), this.event.getSuppliedResponse(), t);
        ArrayList<AsyncListenerWrapper> listenersCopy = new ArrayList<AsyncListenerWrapper>();
        listenersCopy.addAll(this.listeners);
        for (AsyncListenerWrapper listener : listenersCopy) {
            try {
                listener.fireOnError(errorEvent);
            }
            catch (IOException ioe) {
                log.warn("onStartAsync() failed for listener of type [" + listener.getClass().getName() + "]", ioe);
            }
        }
    }

    private void logDebug(String method) {
        String stage;
        String rpHashCode;
        String crHashCode;
        String rHashCode;
        StringBuilder uri = new StringBuilder();
        if (this.request == null) {
            rHashCode = "null";
            crHashCode = "null";
            rpHashCode = "null";
            stage = "-";
            uri.append("N/A");
        } else {
            rHashCode = Integer.toHexString(this.request.hashCode());
            org.apache.coyote.Request coyoteRequest = this.request.getCoyoteRequest();
            if (coyoteRequest == null) {
                crHashCode = "null";
                rpHashCode = "null";
                stage = "-";
            } else {
                crHashCode = Integer.toHexString(coyoteRequest.hashCode());
                RequestInfo rp = coyoteRequest.getRequestProcessor();
                if (rp == null) {
                    rpHashCode = "null";
                    stage = "-";
                } else {
                    rpHashCode = Integer.toHexString(rp.hashCode());
                    stage = Integer.toString(rp.getStage());
                }
            }
            uri.append(this.request.getRequestURI());
            if (this.request.getQueryString() != null) {
                uri.append('?');
                uri.append(this.request.getQueryString());
            }
        }
        String threadName = Thread.currentThread().getName();
        int len = threadName.length();
        if (len > 20) {
            threadName = threadName.substring(len - 20, len);
        }
        String msg = String.format("Req: %1$8s  CReq: %2$8s  RP: %3$8s  Stage: %4$s  Thread: %5$20s  State: %6$20s  Method: %7$11s  URI: %8$s", rHashCode, crHashCode, rpHashCode, stage, threadName, "N/A", method, uri);
        if (log.isTraceEnabled()) {
            log.trace(msg, new DebugException());
        } else {
            log.debug(msg);
        }
    }

    private InstanceManager getInstanceManager() {
        if (this.instanceManager == null) {
            this.instanceManager = this.context instanceof StandardContext ? ((StandardContext)this.context).getInstanceManager() : new DefaultInstanceManager(null, new HashMap<String, Map<String, String>>(), this.context, this.getClass().getClassLoader());
        }
        return this.instanceManager;
    }

    private void check() {
        if (this.request == null) {
            throw new IllegalStateException(sm.getString("asyncContextImpl.requestEnded"));
        }
    }

    private static class PrivilegedGetTccl
    implements PrivilegedAction<ClassLoader> {
        private PrivilegedGetTccl() {
        }

        @Override
        public ClassLoader run() {
            return Thread.currentThread().getContextClassLoader();
        }
    }

    private static class PrivilegedSetTccl
    implements PrivilegedAction<Void> {
        private ClassLoader cl;

        PrivilegedSetTccl(ClassLoader cl) {
            this.cl = cl;
        }

        @Override
        public Void run() {
            Thread.currentThread().setContextClassLoader(this.cl);
            return null;
        }
    }

    private static class RunnableWrapper
    implements Runnable {
        private Runnable wrapped = null;
        private Context context = null;

        public RunnableWrapper(Runnable wrapped, Context ctxt) {
            this.wrapped = wrapped;
            this.context = ctxt;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ClassLoader oldCL;
            PrivilegedAction<ClassLoader> pa;
            if (Globals.IS_SECURITY_ENABLED) {
                pa = new PrivilegedGetTccl();
                oldCL = AccessController.doPrivileged(pa);
            } else {
                oldCL = Thread.currentThread().getContextClassLoader();
            }
            try {
                if (Globals.IS_SECURITY_ENABLED) {
                    pa = new PrivilegedSetTccl(this.context.getLoader().getClassLoader());
                    AccessController.doPrivileged(pa);
                } else {
                    Thread.currentThread().setContextClassLoader(this.context.getLoader().getClassLoader());
                }
                this.wrapped.run();
            }
            finally {
                if (Globals.IS_SECURITY_ENABLED) {
                    pa = new PrivilegedSetTccl(oldCL);
                    AccessController.doPrivileged(pa);
                } else {
                    Thread.currentThread().setContextClassLoader(oldCL);
                }
            }
        }
    }

    private static class DebugException
    extends Exception {
        private static final long serialVersionUID = 1L;

        private DebugException() {
        }
    }
}

