/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.ha.session;

import java.io.IOException;
import javax.servlet.ServletException;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Engine;
import org.apache.catalina.Host;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.Manager;
import org.apache.catalina.Session;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.ha.CatalinaCluster;
import org.apache.catalina.ha.ClusterManager;
import org.apache.catalina.ha.ClusterValve;
import org.apache.catalina.ha.session.DeltaSession;
import org.apache.catalina.ha.session.SessionIDMessage;
import org.apache.catalina.session.ManagerBase;
import org.apache.catalina.session.PersistentManager;
import org.apache.catalina.valves.ValveBase;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.res.StringManager;

public class JvmRouteBinderValve
extends ValveBase
implements ClusterValve {
    public static final Log log = LogFactory.getLog(JvmRouteBinderValve.class);
    protected static final String info = "org.apache.catalina.ha.session.JvmRouteBinderValve/1.2";
    protected CatalinaCluster cluster;
    protected static final StringManager sm = StringManager.getManager("org.apache.catalina.ha.session");
    protected boolean enabled = true;
    protected long numberOfSessions = 0L;
    protected String sessionIdAttribute = "org.apache.catalina.ha.session.JvmRouteOrignalSessionID";

    public JvmRouteBinderValve() {
        super(true);
    }

    @Override
    public String getInfo() {
        return info;
    }

    public String getSessionIdAttribute() {
        return this.sessionIdAttribute;
    }

    public void setSessionIdAttribute(String sessionIdAttribute) {
        this.sessionIdAttribute = sessionIdAttribute;
    }

    public long getNumberOfSessions() {
        return this.numberOfSessions;
    }

    public boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public void invoke(Request request, Response response) throws IOException, ServletException {
        Manager manager;
        if (this.getEnabled() && request.getContext() != null && request.getContext().getDistributable() && !request.isAsyncDispatching() && (manager = request.getContext().getManager()) != null && (manager instanceof ClusterManager && this.getCluster() != null && this.getCluster().getManager(((ClusterManager)manager).getName()) != null || manager instanceof PersistentManager)) {
            this.handlePossibleTurnover(request);
        }
        this.getNext().invoke(request, response);
    }

    protected void handlePossibleTurnover(Request request) {
        String sessionID = request.getRequestedSessionId();
        if (sessionID != null) {
            long t1 = System.currentTimeMillis();
            String jvmRoute = this.getLocalJvmRoute(request);
            if (jvmRoute == null) {
                if (log.isDebugEnabled()) {
                    log.debug(sm.getString("jvmRoute.missingJvmRouteAttribute"));
                }
                return;
            }
            this.handleJvmRoute(request, sessionID, jvmRoute);
            if (log.isDebugEnabled()) {
                long t2 = System.currentTimeMillis();
                long time = t2 - t1;
                log.debug(sm.getString("jvmRoute.turnoverInfo", time));
            }
        }
    }

    protected String getLocalJvmRoute(Request request) {
        Manager manager = this.getManager(request);
        if (manager instanceof ManagerBase) {
            return ((ManagerBase)manager).getJvmRoute();
        }
        return null;
    }

    protected Manager getManager(Request request) {
        Manager manager = request.getContext().getManager();
        if (log.isDebugEnabled()) {
            if (manager != null) {
                log.debug(sm.getString("jvmRoute.foundManager", manager, request.getContext().getName()));
            } else {
                log.debug(sm.getString("jvmRoute.notFoundManager", request.getContext().getName()));
            }
        }
        return manager;
    }

    @Override
    public CatalinaCluster getCluster() {
        return this.cluster;
    }

    @Override
    public void setCluster(CatalinaCluster cluster) {
        this.cluster = cluster;
    }

    protected void handleJvmRoute(Request request, String sessionId, String localJvmRoute) {
        String requestJvmRoute = null;
        int index = sessionId.indexOf(".");
        if (index > 0) {
            requestJvmRoute = sessionId.substring(index + 1, sessionId.length());
        }
        if (requestJvmRoute != null && !requestJvmRoute.equals(localJvmRoute)) {
            if (log.isDebugEnabled()) {
                log.debug(sm.getString("jvmRoute.failover", requestJvmRoute, localJvmRoute, sessionId));
            }
            Session catalinaSession = null;
            try {
                catalinaSession = this.getManager(request).findSession(sessionId);
            }
            catch (IOException e) {
                // empty catch block
            }
            String id = sessionId.substring(0, index);
            String newSessionID = id + "." + localJvmRoute;
            if (catalinaSession != null) {
                this.changeSessionID(request, sessionId, newSessionID, catalinaSession);
                ++this.numberOfSessions;
            } else {
                try {
                    catalinaSession = this.getManager(request).findSession(newSessionID);
                }
                catch (IOException e) {
                    // empty catch block
                }
                if (catalinaSession != null) {
                    this.changeRequestSessionID(request, sessionId, newSessionID);
                } else if (log.isDebugEnabled()) {
                    log.debug(sm.getString("jvmRoute.cannotFindSession", sessionId));
                }
            }
        }
    }

    protected void changeSessionID(Request request, String sessionId, String newSessionID, Session catalinaSession) {
        this.fireLifecycleEvent("Before session migration", catalinaSession);
        catalinaSession.setId(newSessionID, false);
        if (catalinaSession instanceof DeltaSession) {
            ((DeltaSession)catalinaSession).resetDeltaRequest();
        }
        this.changeRequestSessionID(request, sessionId, newSessionID);
        this.sendSessionIDClusterBackup(request, sessionId, newSessionID);
        this.fireLifecycleEvent("After session migration", catalinaSession);
        if (log.isDebugEnabled()) {
            log.debug(sm.getString("jvmRoute.changeSession", sessionId, newSessionID));
        }
    }

    protected void changeRequestSessionID(Request request, String sessionId, String newSessionID) {
        request.changeSessionId(newSessionID);
        if (this.sessionIdAttribute != null && !"".equals(this.sessionIdAttribute)) {
            if (log.isDebugEnabled()) {
                log.debug(sm.getString("jvmRoute.set.orignalsessionid", this.sessionIdAttribute, sessionId));
            }
            request.setAttribute(this.sessionIdAttribute, sessionId);
        }
    }

    protected void sendSessionIDClusterBackup(Request request, String sessionId, String newSessionID) {
        CatalinaCluster c = this.getCluster();
        if (c != null) {
            SessionIDMessage msg = new SessionIDMessage();
            msg.setOrignalSessionID(sessionId);
            msg.setBackupSessionID(newSessionID);
            Context context = request.getContext();
            msg.setContextName(context.getName());
            msg.setHost(context.getParent().getName());
            c.send(msg);
        }
    }

    @Override
    protected synchronized void startInternal() throws LifecycleException {
        if (this.cluster == null) {
            Container hostContainer = this.getContainer();
            if (!(hostContainer instanceof Host)) {
                if (log.isWarnEnabled()) {
                    log.warn(sm.getString("jvmRoute.configure.warn"));
                }
                hostContainer = hostContainer.getParent();
            }
            if (hostContainer instanceof Host && ((Host)hostContainer).getCluster() != null) {
                this.cluster = (CatalinaCluster)((Host)hostContainer).getCluster();
            } else {
                Container engine = hostContainer.getParent();
                if (engine instanceof Engine && ((Engine)engine).getCluster() != null) {
                    this.cluster = (CatalinaCluster)((Engine)engine).getCluster();
                }
            }
        }
        if (log.isInfoEnabled()) {
            log.info(sm.getString("jvmRoute.valve.started"));
            if (this.cluster == null) {
                log.info(sm.getString("jvmRoute.noCluster"));
            }
        }
        super.startInternal();
    }

    @Override
    protected synchronized void stopInternal() throws LifecycleException {
        super.stopInternal();
        this.cluster = null;
        this.numberOfSessions = 0L;
        if (log.isInfoEnabled()) {
            log.info(sm.getString("jvmRoute.valve.stopped"));
        }
    }
}

