/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.ajp;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.Socket;
import org.apache.coyote.ActionCode;
import org.apache.coyote.OutputBuffer;
import org.apache.coyote.RequestInfo;
import org.apache.coyote.Response;
import org.apache.coyote.ajp.AbstractAjpProcessor;
import org.apache.coyote.ajp.AjpMessage;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.ExceptionUtils;
import org.apache.tomcat.util.buf.ByteChunk;
import org.apache.tomcat.util.net.AbstractEndpoint;
import org.apache.tomcat.util.net.JIoEndpoint;
import org.apache.tomcat.util.net.SocketStatus;
import org.apache.tomcat.util.net.SocketWrapper;

public class AjpProcessor
extends AbstractAjpProcessor<Socket> {
    private static final Log log = LogFactory.getLog(AjpProcessor.class);
    protected SocketWrapper<Socket> socket;
    protected InputStream input;
    protected OutputStream output;

    @Override
    protected Log getLog() {
        return log;
    }

    public AjpProcessor(int packetSize, JIoEndpoint endpoint) {
        super(packetSize, endpoint);
        this.response.setOutputBuffer(new SocketOutputBuffer());
    }

    @Override
    public AbstractEndpoint.Handler.SocketState process(SocketWrapper<Socket> socket) throws IOException {
        RequestInfo rp = this.request.getRequestProcessor();
        rp.setStage(1);
        this.socket = socket;
        this.input = socket.getSocket().getInputStream();
        this.output = socket.getSocket().getOutputStream();
        int soTimeout = -1;
        if (this.keepAliveTimeout > 0) {
            soTimeout = socket.getSocket().getSoTimeout();
        }
        this.error = false;
        while (!this.error && !this.endpoint.isPaused()) {
            try {
                byte type;
                if (this.keepAliveTimeout > 0) {
                    socket.getSocket().setSoTimeout(this.keepAliveTimeout);
                }
                if (!this.readMessage(this.requestHeaderMessage)) {
                    rp.setStage(7);
                    break;
                }
                if (this.keepAliveTimeout > 0) {
                    socket.getSocket().setSoTimeout(soTimeout);
                }
                if ((type = this.requestHeaderMessage.getByte()) == 10) {
                    try {
                        this.output.write(pongMessageArray);
                    }
                    catch (IOException e) {
                        this.error = true;
                    }
                    continue;
                }
                if (type != 2) {
                    if (!log.isDebugEnabled()) continue;
                    log.debug("Unexpected message: " + type);
                    continue;
                }
                this.request.setStartTime(System.currentTimeMillis());
            }
            catch (IOException e) {
                this.error = true;
                break;
            }
            catch (Throwable t) {
                ExceptionUtils.handleThrowable(t);
                log.debug(sm.getString("ajpprocessor.header.error"), t);
                this.response.setStatus(400);
                this.adapter.log(this.request, this.response, 0L);
                this.error = true;
            }
            if (!this.error) {
                rp.setStage(2);
                try {
                    this.prepareRequest();
                }
                catch (Throwable t) {
                    ExceptionUtils.handleThrowable(t);
                    log.debug(sm.getString("ajpprocessor.request.prepare"), t);
                    this.response.setStatus(400);
                    this.adapter.log(this.request, this.response, 0L);
                    this.error = true;
                }
            }
            if (this.endpoint.isPaused()) {
                this.response.setStatus(503);
                this.adapter.log(this.request, this.response, 0L);
                this.error = true;
            }
            if (!this.error) {
                try {
                    rp.setStage(3);
                    this.adapter.service(this.request, this.response);
                }
                catch (InterruptedIOException e) {
                    this.error = true;
                }
                catch (Throwable t) {
                    ExceptionUtils.handleThrowable(t);
                    log.error(sm.getString("ajpprocessor.request.process"), t);
                    this.response.setStatus(500);
                    this.adapter.log(this.request, this.response, 0L);
                    this.error = true;
                }
            }
            if (this.isAsync() && !this.error) break;
            if (!this.finished) {
                try {
                    this.finish();
                }
                catch (Throwable t) {
                    ExceptionUtils.handleThrowable(t);
                    this.error = true;
                }
            }
            if (this.error) {
                this.response.setStatus(500);
            }
            this.request.updateCounters();
            rp.setStage(6);
            this.recycle(false);
        }
        rp.setStage(7);
        if (this.isAsync() && !this.error && !this.endpoint.isPaused()) {
            return AbstractEndpoint.Handler.SocketState.LONG;
        }
        this.input = null;
        this.output = null;
        return AbstractEndpoint.Handler.SocketState.CLOSED;
    }

    @Override
    public void recycle(boolean socketClosing) {
        super.recycle(socketClosing);
        if (socketClosing) {
            this.input = null;
            this.output = null;
        }
    }

    @Override
    protected void actionInternal(ActionCode actionCode, Object param) {
        if (actionCode == ActionCode.ASYNC_COMPLETE) {
            if (this.asyncStateMachine.asyncComplete()) {
                ((JIoEndpoint)this.endpoint).processSocketAsync(this.socket, SocketStatus.OPEN);
            }
        } else if (actionCode == ActionCode.ASYNC_SETTIMEOUT) {
            if (param == null) {
                return;
            }
            long timeout = (Long)param;
            this.socket.setTimeout(timeout);
        } else if (actionCode == ActionCode.ASYNC_DISPATCH && this.asyncStateMachine.asyncDispatch()) {
            ((JIoEndpoint)this.endpoint).processSocketAsync(this.socket, SocketStatus.OPEN);
        }
    }

    @Override
    protected void output(byte[] src, int offset, int length) throws IOException {
        this.output.write(src, offset, length);
    }

    @Override
    protected void finish() throws IOException {
        if (!this.response.isCommitted()) {
            try {
                this.prepareResponse();
            }
            catch (IOException e) {
                this.error = true;
            }
        }
        if (this.finished) {
            return;
        }
        this.finished = true;
        this.output.write(this.error ? endAndCloseMessageArray : endMessageArray);
    }

    protected boolean read(byte[] buf, int pos, int n) throws IOException {
        int res = 0;
        for (int read = 0; read < n; read += res) {
            res = this.input.read(buf, read + pos, n - read);
            if (res > 0) {
                continue;
            }
            throw new IOException(sm.getString("ajpprotocol.failedread"));
        }
        return true;
    }

    @Override
    public boolean receive() throws IOException {
        this.first = false;
        this.bodyMessage.reset();
        if (!this.readMessage(this.bodyMessage)) {
            return false;
        }
        if (this.bodyMessage.getLen() == 0) {
            return false;
        }
        int blen = this.bodyMessage.peekInt();
        if (blen == 0) {
            return false;
        }
        this.bodyMessage.getBytes(this.bodyBytes);
        this.empty = false;
        return true;
    }

    @Override
    protected boolean refillReadBuffer() throws IOException {
        if (this.replay) {
            this.endOfStream = true;
        }
        if (this.endOfStream) {
            return false;
        }
        this.output.write(this.getBodyMessageArray);
        boolean moreData = this.receive();
        if (!moreData) {
            this.endOfStream = true;
        }
        return moreData;
    }

    protected boolean readMessage(AjpMessage message) throws IOException {
        byte[] buf = message.getBuffer();
        int headerLength = message.getHeaderLength();
        this.read(buf, 0, headerLength);
        int messageLength = message.processHeader();
        if (messageLength < 0) {
            return false;
        }
        if (messageLength == 0) {
            return true;
        }
        if (messageLength > buf.length) {
            throw new IllegalArgumentException(sm.getString("ajpprocessor.header.tooLong", messageLength, buf.length));
        }
        this.read(buf, headerLength, messageLength);
        return true;
    }

    @Override
    protected void flush(boolean explicit) throws IOException {
        if (explicit && !this.finished) {
            this.output.write(flushMessageArray);
        }
    }

    protected class SocketOutputBuffer
    implements OutputBuffer {
        protected SocketOutputBuffer() {
        }

        @Override
        public int doWrite(ByteChunk chunk, Response res) throws IOException {
            if (!AjpProcessor.this.response.isCommitted()) {
                try {
                    AjpProcessor.this.prepareResponse();
                }
                catch (IOException e) {
                    AjpProcessor.this.error = true;
                }
            }
            int len = chunk.getLength();
            int chunkSize = 8184 + AjpProcessor.this.packetSize - 8192;
            int off = 0;
            while (len > 0) {
                int thisTime = len;
                if (thisTime > chunkSize) {
                    thisTime = chunkSize;
                }
                len -= thisTime;
                AjpProcessor.this.responseHeaderMessage.reset();
                AjpProcessor.this.responseHeaderMessage.appendByte(3);
                AjpProcessor.this.responseHeaderMessage.appendBytes(chunk.getBytes(), chunk.getOffset() + off, thisTime);
                AjpProcessor.this.responseHeaderMessage.end();
                AjpProcessor.this.output.write(AjpProcessor.this.responseHeaderMessage.getBuffer(), 0, AjpProcessor.this.responseHeaderMessage.getLen());
                off += thisTime;
            }
            AjpProcessor.this.byteCount += (long)chunk.getLength();
            return chunk.getLength();
        }

        @Override
        public long getBytesWritten() {
            return AjpProcessor.this.byteCount;
        }
    }
}

