/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.web.tomcat7.ws;

import java.util.Map;
import org.apache.catalina.Container;
import org.apache.catalina.Host;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Wrapper;
import org.apache.catalina.core.StandardContext;
import org.ow2.jonas.web.tomcat7.ws.EndpointInstanceListener;
import org.ow2.jonas.web.tomcat7.ws.URLUtils;
import org.ow2.jonas.web.tomcat7.ws.WebServiceEndpointStandardWrapper;
import org.ow2.jonas.ws.jaxws.IJAXWSService;
import org.ow2.jonas.ws.jaxws.IWebServiceEndpoint;
import org.ow2.jonas.ws.jaxws.PortMetaData;
import org.ow2.jonas.ws.jaxws.WSException;
import org.ow2.jonas.ws.jaxws.http.servlet.JAXWSServlet;
import org.ow2.util.ee.metadata.war.api.IWarClassMetadata;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSContextLifecycleListener
implements LifecycleListener {
    private Map<String, IWarClassMetadata> services;
    private IJAXWSService jaxwsService;

    public WSContextLifecycleListener(Map<String, IWarClassMetadata> services, IJAXWSService jaxws) {
        this.services = services;
        this.jaxwsService = jaxws;
    }

    @Override
    public void lifecycleEvent(LifecycleEvent event) {
        if ("configure_start".equals(event.getType())) {
            this.onContextStart((StandardContext)event.getLifecycle());
        } else if ("after_start".equals(event.getType())) {
            this.onAfterContextStart((StandardContext)event.getLifecycle());
        } else if ("after_stop".equals(event.getType())) {
            this.onAfterContextStop((StandardContext)event.getLifecycle());
        }
    }

    private void onContextStart(StandardContext context) {
        if (this.services.isEmpty()) {
            return;
        }
        Container[] childs = context.findChildren();
        if (childs != null) {
            for (Container child : childs) {
                Wrapper wrapper = (Wrapper)child;
                String servletClass = wrapper.getServletClass();
                IWarClassMetadata metadata = this.findWebServiceMetadata(servletClass);
                if (metadata == null) continue;
                wrapper.setServletClass(JAXWSServlet.class.getName());
                wrapper.addInstanceListener(new EndpointInstanceListener(metadata, this.jaxwsService));
                this.services.remove(servletClass);
                int loadOnStartup = wrapper.getLoadOnStartup();
                if (loadOnStartup >= 0) continue;
                wrapper.setLoadOnStartup(0);
            }
        }
    }

    private void onAfterContextStart(StandardContext context) {
        for (Map.Entry<String, IWarClassMetadata> entry : this.services.entrySet()) {
            ClassLoader loader = context.getLoader().getClassLoader();
            IWebServiceEndpoint endpoint = null;
            IWarClassMetadata metadata = entry.getValue();
            try {
                endpoint = this.jaxwsService.createPOJOWebServiceEndpoint(metadata, loader, context.getServletContext());
            }
            catch (WSException e) {
                throw new RuntimeException("WebServiceEndpoint creation failed", e);
            }
            PortMetaData pmd = endpoint.getPortMetaData();
            pmd.setContextRoot(context.getName());
            String url = URLUtils.getEndpointURL(pmd, (Host)context.getParent());
            pmd.setEndpointURL(url);
            WebServiceEndpointStandardWrapper wrapper = null;
            String name = metadata.getJClass().getName().replace('/', '.');
            wrapper = new WebServiceEndpointStandardWrapper(endpoint, name);
            context.addChild(wrapper);
            String pattern = pmd.getUrlPattern();
            context.addServletMapping(pattern, wrapper.getServletName());
            endpoint.displayInfos();
        }
    }

    private void onAfterContextStop(StandardContext context) {
        this.jaxwsService.undeployPOJOEndpoints(context.getServletContext());
    }

    private IWarClassMetadata findWebServiceMetadata(String servletClass) {
        for (Map.Entry<String, IWarClassMetadata> entry : this.services.entrySet()) {
            if (!servletClass.equals(entry.getKey())) continue;
            return entry.getValue();
        }
        return null;
    }
}

