/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.dbm.internal.osgi;

import java.sql.Driver;
import java.sql.SQLException;
import java.util.Properties;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.DataSource;
import javax.sql.XADataSource;
import org.osgi.service.jdbc.DataSourceFactory;
import org.ow2.jonas.dbm.internal.cm.ConnectionManager;
import org.ow2.jonas.tm.TransactionService;

public class JOnASDataSourceFactory
implements DataSourceFactory {
    private Class driverClass = null;
    private TransactionService txService = null;
    private String name = null;

    public JOnASDataSourceFactory(Class driverClass, TransactionService txService) {
        this.driverClass = driverClass;
        this.txService = txService;
    }

    public ConnectionPoolDataSource createConnectionPoolDataSource(Properties props) throws SQLException {
        return this.getConnectionManager(props);
    }

    public DataSource createDataSource(Properties props) throws SQLException {
        return this.getConnectionManager(props);
    }

    public XADataSource createXADataSource(Properties props) throws SQLException {
        return this.getConnectionManager(props);
    }

    protected String getProperty(Properties props, String key, boolean mandatory) throws SQLException {
        return this.getProperty(props, key, mandatory, null);
    }

    protected String getProperty(Properties props, String key, String defaultValue) throws SQLException {
        return this.getProperty(props, key, false, defaultValue);
    }

    protected String getProperty(Properties props, String key, boolean mandatory, String defaultValue) throws SQLException {
        Object val = props.get(key);
        if (val != null && !(val instanceof String)) {
            throw new SQLException("Property value for the '" + key + "' is not a String. Found '" + val + "'.");
        }
        String value = (String)val;
        if (value == null) {
            if (mandatory) {
                throw new SQLException("Property value for the '" + key + "' is missing and it is mandatory.");
            }
            value = defaultValue;
        }
        return value;
    }

    protected ConnectionManager getConnectionManager(Properties props) throws SQLException {
        ConnectionManager datasource;
        String name = "OSGi/" + this.driverClass.getName();
        try {
            datasource = new ConnectionManager(this.txService);
        }
        catch (Exception e) {
            throw new SQLException("Unable to create datasource", e);
        }
        String url = this.getProperty(props, "url", true);
        String user = this.getProperty(props, "user", true);
        String password = this.getProperty(props, "password", true);
        name = this.getProperty(props, "password", true);
        String description = this.getProperty(props, "description", "");
        String dataSourceName = this.getProperty(props, "dataSourceName", name);
        String databaseName = this.getProperty(props, "databaseName", name);
        String maxPoolSize = this.getProperty(props, "maxPoolSize", "-1");
        String initPoolSize = this.getProperty(props, "initialPoolSize", "0");
        String minPoolSize = this.getProperty(props, "minPoolSize", initPoolSize);
        String maxIdletime = this.getProperty(props, "maxIdleTime", "10");
        String maxStatements = this.getProperty(props, "maxStatements", "12");
        String connCheckLevel = this.getProperty(props, "jdbc.connchecklevel", "1");
        String connMaxAge = this.getProperty(props, "jdbc.connmaxage", "1440");
        String maxOpenTime = this.getProperty(props, "jdbc.maxopentime", "1440");
        String maxwaiters = this.getProperty(props, "jdbc.maxwaiters", "1000");
        String samplingperiod = this.getProperty(props, "jdbc.samplingperiod", "30");
        String adjustperiod = this.getProperty(props, "jdbc.adjustperiod", "30");
        String defaultStatement = this.getProperty(props, "jdbc.connteststmt", "SELECT 1");
        datasource.setDatasourceName(dataSourceName);
        datasource.setDSName(databaseName);
        datasource.setUrl(url);
        datasource.setDriverClass(this.driverClass);
        datasource.setUserName(user);
        datasource.setPassword(password);
        datasource.setDataSourceDescription(description);
        datasource.poolConfigure(connCheckLevel, connMaxAge, maxOpenTime, defaultStatement, maxStatements, minPoolSize, maxPoolSize, maxIdletime, maxwaiters, samplingperiod, adjustperiod);
        return datasource;
    }

    public Driver createDriver(Properties props) throws SQLException {
        Driver driver;
        try {
            driver = (Driver)this.driverClass.newInstance();
        }
        catch (InstantiationException e) {
            throw new SQLException("Unable to build a driver instance", e);
        }
        catch (IllegalAccessException e) {
            throw new SQLException("Unable to build a driver instance", e);
        }
        return driver;
    }
}

