/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.descriptors;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import org.eclipse.persistence.descriptors.FieldsLockingPolicy;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.DatabaseTable;
import org.eclipse.persistence.internal.helper.NonSynchronizedVector;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.queries.ObjectLevelModifyQuery;

public class SelectedFieldsLockingPolicy
extends FieldsLockingPolicy {
    protected Map lockFieldsByTable = new HashMap(5);
    protected Vector lockFields = NonSynchronizedVector.newInstance();

    public void addLockFieldName(String fieldName) {
        this.getLockFields().addElement(new DatabaseField(fieldName));
    }

    public void addLockValuesToTranslationRow(ObjectLevelModifyQuery query) throws DatabaseException {
        this.verifyUsage(query.getSession());
        Object object = query.isDeleteObjectQuery() ? query.getObject() : query.getBackupClone();
        Iterator vectors = this.getLockFieldsByTable().values().iterator();
        while (vectors.hasNext()) {
            Enumeration fields = ((Vector)vectors.next()).elements();
            while (fields.hasMoreElements()) {
                DatabaseField field = (DatabaseField)fields.nextElement();
                DatabaseMapping mapping = this.descriptor.getObjectBuilder().getMappingForField(field);
                if (mapping == null) {
                    throw DatabaseException.specifiedLockingFieldsNotFoundInDatabase(field.getQualifiedName());
                }
                mapping.writeFromObjectIntoRow(object, query.getTranslationRow(), query.getSession());
            }
        }
    }

    protected Vector getFieldsToCompare(DatabaseTable table, AbstractRecord transRow, AbstractRecord modifyRow) {
        return this.getLockFields(table);
    }

    public Vector getLockFields() {
        return this.lockFields;
    }

    protected Vector getLockFields(DatabaseTable table) {
        Vector tempVector = (Vector)this.lockFieldsByTable.get(table);
        if (tempVector == null) {
            return new Vector();
        }
        return tempVector;
    }

    protected Map getLockFieldsByTable() {
        return this.lockFieldsByTable;
    }

    public void initialize(AbstractSession session) {
        super.initialize(session);
        Vector lockFields = this.getLockFields();
        int size = lockFields.size();
        for (int index = 0; index < size; ++index) {
            DatabaseField field = (DatabaseField)lockFields.get(index);
            field = this.descriptor.buildField(field);
            lockFields.set(index, field);
            Vector fieldsForTable = (Vector)this.getLockFieldsByTable().get(field.getTable());
            if (fieldsForTable == null) {
                fieldsForTable = NonSynchronizedVector.newInstance();
                this.getLockFieldsByTable().put(field.getTable(), fieldsForTable);
            }
            fieldsForTable.addElement(field);
        }
    }

    public void setLockFieldNames(Vector lockFieldNames) {
        Enumeration enumtr = lockFieldNames.elements();
        while (enumtr.hasMoreElements()) {
            this.addLockFieldName((String)enumtr.nextElement());
        }
    }

    public void setLockFields(Map lockFieldsByTable) {
        this.lockFieldsByTable = lockFieldsByTable;
    }

    protected void setLockFields(Vector lockFields) {
        this.lockFields = lockFields;
    }

    protected void setLockFieldsByTable(Map lockFieldsByTable) {
        this.lockFieldsByTable = lockFieldsByTable;
    }
}

