/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.persistence.annotations.IdValidation;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.jpa.metadata.MetadataDescriptor;
import org.eclipse.persistence.internal.jpa.metadata.MetadataHelper;
import org.eclipse.persistence.internal.jpa.metadata.ORMetadata;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;
import org.eclipse.persistence.internal.jpa.metadata.columns.ColumnMetadata;

public class PrimaryKeyMetadata
extends ORMetadata {
    private Enum m_validation;
    private List<ColumnMetadata> m_columns = new ArrayList<ColumnMetadata>();

    public PrimaryKeyMetadata() {
        super("<primary-key>");
    }

    public PrimaryKeyMetadata(Annotation primaryKey, MetadataAccessibleObject accessibleObject) {
        super(primaryKey, accessibleObject);
        this.m_validation = (Enum)MetadataHelper.invokeMethod("validation", primaryKey);
        for (Annotation selectedColumn : (Annotation[])MetadataHelper.invokeMethod("columns", primaryKey)) {
            this.m_columns.add(new ColumnMetadata(selectedColumn, accessibleObject));
        }
    }

    public boolean hasColumns() {
        return !this.m_columns.isEmpty();
    }

    public void process(MetadataDescriptor descriptor) {
        descriptor.getClassDescriptor().setIdValidation(IdValidation.valueOf(this.m_validation.name()));
        if (this.hasColumns()) {
            ArrayList<DatabaseField> fields = new ArrayList<DatabaseField>(this.m_columns.size());
            for (ColumnMetadata column : this.m_columns) {
                if (column.getName().equals("")) {
                    throw ValidationException.optimisticLockingSelectedColumnNamesNotSpecified(descriptor.getJavaClass());
                }
                fields.add(column.getDatabaseField());
            }
            descriptor.getClassDescriptor().setPrimaryKeyFields(fields);
        }
    }
}

