/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.blocks;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.jgroups.Address;
import org.jgroups.Channel;
import org.jgroups.ChannelException;
import org.jgroups.MembershipListener;
import org.jgroups.Message;
import org.jgroups.MessageListener;
import org.jgroups.View;
import org.jgroups.blocks.MethodCall;
import org.jgroups.blocks.PullPushAdapter;
import org.jgroups.blocks.RpcDispatcher;
import org.jgroups.blocks.VoteException;
import org.jgroups.blocks.VoteResponseProcessor;
import org.jgroups.blocks.VotingListener;
import org.jgroups.logging.Log;
import org.jgroups.logging.LogFactory;
import org.jgroups.util.Rsp;
import org.jgroups.util.RspList;

public class VotingAdapter
implements MessageListener,
MembershipListener,
VoteResponseProcessor {
    public static final int VOTE_ANY = 0;
    public static final int VOTE_ALL = 1;
    public static final int VOTE_MAJORITY = 2;
    private static final int PROCESS_CONTINUE = 0;
    private static final int PROCESS_SKIP = 1;
    private static final int PROCESS_BREAK = 2;
    private final RpcDispatcher rpcDispatcher;
    protected final Log log = LogFactory.getLog(this.getClass());
    private final HashSet suspectedNodes = new HashSet();
    private boolean closed;
    private final List membership_listeners = new LinkedList();
    private final Set voteListeners = new HashSet();
    private VotingListener[] listeners;

    public VotingAdapter(Channel channel) {
        this.rpcDispatcher = new RpcDispatcher(channel, (MessageListener)this, (MembershipListener)this, (Object)this);
    }

    public VotingAdapter(PullPushAdapter adapter, Serializable id) {
        this.rpcDispatcher = new RpcDispatcher(adapter, id, (MessageListener)this, (MembershipListener)this, this);
    }

    public Collection getMembers() {
        return this.rpcDispatcher != null ? this.rpcDispatcher.getMembers() : null;
    }

    public void addMembershipListener(MembershipListener l) {
        if (l != null && !this.membership_listeners.contains(l)) {
            this.membership_listeners.add(l);
        }
    }

    public void removeMembershipListener(MembershipListener l) {
        if (l != null) {
            this.membership_listeners.remove(l);
        }
    }

    public boolean vote(Object decree, int consensusType, long timeout) throws ChannelException {
        return this.vote(decree, consensusType, timeout, null);
    }

    public boolean vote(Object decree, int consensusType, long timeout, VoteResponseProcessor voteResponseProcessor) throws ChannelException {
        if (this.closed) {
            throw new ChannelException("Channel was closed.");
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Conducting voting on decree " + decree + ", consensus type " + VotingAdapter.getConsensusStr(consensusType) + ", timeout " + timeout);
        }
        int mode = 2;
        switch (consensusType) {
            case 1: {
                mode = 2;
                break;
            }
            case 0: {
                mode = 1;
                break;
            }
            case 2: {
                mode = 3;
                break;
            }
            default: {
                mode = 2;
            }
        }
        try {
            Method method = this.getClass().getMethod("localVote", Object.class);
            MethodCall methodCall = new MethodCall(method, decree);
            if (this.log.isDebugEnabled()) {
                this.log.debug("Calling remote methods...");
            }
            RspList responses = this.rpcDispatcher.callRemoteMethods(null, methodCall, mode, timeout);
            if (this.log.isDebugEnabled()) {
                this.log.debug("Checking responses.");
            }
            if (voteResponseProcessor == null) {
                voteResponseProcessor = this;
            }
            return voteResponseProcessor.processResponses(responses, consensusType, decree);
        }
        catch (NoSuchMethodException nsmex) {
            if (this.log.isErrorEnabled()) {
                this.log.error("Could not find method localVote(Object). " + nsmex.toString());
            }
            throw new UnsupportedOperationException("Cannot execute voting because of absence of " + this.getClass().getName() + ".localVote(Object) method.");
        }
    }

    @Override
    public boolean processResponses(RspList responses, int consensusType, Object decree) throws ChannelException {
        if (responses == null) {
            return false;
        }
        boolean voteResult = false;
        int totalPositiveVotes = 0;
        int totalNegativeVotes = 0;
        block9: for (Rsp response : responses.values()) {
            switch (this.checkResponse(response)) {
                case 1: {
                    continue block9;
                }
                case 2: {
                    return false;
                }
            }
            VoteResult result = (VoteResult)response.getValue();
            totalPositiveVotes += result.getPositiveVotes();
            totalNegativeVotes += result.getNegativeVotes();
        }
        switch (consensusType) {
            case 1: {
                voteResult = totalNegativeVotes == 0 && totalPositiveVotes > 0;
                break;
            }
            case 0: {
                voteResult = totalPositiveVotes > 0;
                break;
            }
            case 2: {
                voteResult = totalPositiveVotes > totalNegativeVotes;
            }
        }
        return voteResult;
    }

    private int checkResponse(Rsp response) throws ChannelException {
        if (!response.wasReceived()) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Response from node " + response.getSender() + " was not received.");
            }
            return 2;
        }
        if (response.wasSuspected()) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Node " + response.getSender() + " was suspected.");
            }
            return 1;
        }
        Object object = response.getValue();
        if (object instanceof Throwable) {
            throw new ChannelException("Node " + response.getSender() + " is faulty.");
        }
        if (object == null) {
            return 1;
        }
        if (!(object instanceof VoteResult)) {
            String faultClass = object.getClass().getName();
            throw new ChannelException("Node " + response.getSender() + " generated fault (class " + faultClass + ')');
        }
        if (object instanceof FailureVoteResult) {
            if (this.log.isErrorEnabled()) {
                this.log.error(((FailureVoteResult)object).getReason());
            }
            return 2;
        }
        return 0;
    }

    @Override
    public void viewAccepted(View newView) {
        Iterator iterator = this.suspectedNodes.iterator();
        while (iterator.hasNext()) {
            Address suspectedNode = (Address)iterator.next();
            if (!newView.containsMember(suspectedNode)) continue;
            iterator.remove();
        }
        for (MembershipListener listener : this.membership_listeners) {
            try {
                listener.viewAccepted(newView);
            }
            catch (Throwable t) {
                if (!this.log.isErrorEnabled()) continue;
                this.log.error("failed calling viewAccepted() on " + listener, t);
            }
        }
    }

    @Override
    public void suspect(Address suspected) {
        this.suspectedNodes.add(suspected);
        for (MembershipListener listener : this.membership_listeners) {
            try {
                listener.suspect(suspected);
            }
            catch (Throwable t) {
                if (!this.log.isErrorEnabled()) continue;
                this.log.error("failed calling suspect() on " + listener, t);
            }
        }
    }

    @Override
    public void block() {
        for (MembershipListener listener : this.membership_listeners) {
            try {
                listener.block();
            }
            catch (Throwable t) {
                if (!this.log.isErrorEnabled()) continue;
                this.log.error("failed calling block() on " + listener, t);
            }
        }
    }

    @Override
    public byte[] getState() {
        return null;
    }

    @Override
    public void receive(Message msg) {
    }

    @Override
    public void setState(byte[] state) {
    }

    public boolean vote(Object decree, long timeout) throws ChannelException {
        return this.vote(decree, timeout, null);
    }

    public boolean vote(Object decree, long timeout, VoteResponseProcessor voteResponseProcessor) throws ChannelException {
        return this.vote(decree, 1, timeout, voteResponseProcessor);
    }

    public void addVoteListener(VotingListener listener) {
        this.voteListeners.add(listener);
        this.listeners = this.voteListeners.toArray(new VotingListener[this.voteListeners.size()]);
    }

    public void removeVoteListener(VotingListener listener) {
        this.voteListeners.remove(listener);
        this.listeners = this.voteListeners.toArray(new VotingListener[this.voteListeners.size()]);
    }

    public VoteResult localVote(Object decree) {
        VoteResult voteResult = new VoteResult();
        for (int i = 0; i < this.listeners.length; ++i) {
            VotingListener listener = this.listeners[i];
            try {
                voteResult.addVote(listener.vote(decree));
                continue;
            }
            catch (VoteException vex) {
                continue;
            }
            catch (RuntimeException ex) {
                if (this.log.isErrorEnabled()) {
                    this.log.error(ex.toString());
                }
                return new FailureVoteResult(ex.getMessage());
            }
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Voting on decree " + decree.toString() + " : " + voteResult.toString());
        }
        return voteResult;
    }

    public static String getConsensusStr(int consensusType) {
        switch (consensusType) {
            case 1: {
                return "VOTE_ALL";
            }
            case 0: {
                return "VOTE_ANY";
            }
            case 2: {
                return "VOTE_MAJORITY";
            }
        }
        return "UNKNOWN";
    }

    public static class FailureVoteResult
    extends VoteResult {
        private final String reason;

        public FailureVoteResult(String reason) {
            this.reason = reason;
        }

        public String getReason() {
            return this.reason;
        }
    }

    public static class VoteResult
    implements Serializable {
        private int positiveVotes = 0;
        private int negativeVotes = 0;
        private static final long serialVersionUID = 2868605599965196746L;

        public void addVote(boolean vote) {
            if (vote) {
                ++this.positiveVotes;
            } else {
                ++this.negativeVotes;
            }
        }

        public int getPositiveVotes() {
            return this.positiveVotes;
        }

        public int getNegativeVotes() {
            return this.negativeVotes;
        }

        public String toString() {
            return "VoteResult: up=" + this.positiveVotes + ", down=" + this.negativeVotes;
        }
    }
}

