/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.jgroups.Address;
import org.jgroups.View;
import org.jgroups.annotations.Experimental;
import org.jgroups.blocks.locking.Owner;
import org.jgroups.protocols.Locking;

@Experimental
public class PEER_LOCK
extends Locking {
    @Override
    protected void sendGrantLockRequest(String lock_name, Owner owner, long timeout, boolean is_trylock) {
        this.sendRequest(null, Locking.Type.GRANT_LOCK, lock_name, owner, timeout, is_trylock);
    }

    @Override
    protected void sendReleaseLockRequest(String lock_name, Owner owner) {
        this.sendRequest(null, Locking.Type.RELEASE_LOCK, lock_name, owner, 0L, false);
    }

    @Override
    protected void sendAwaitConditionRequest(String lock_name, Owner owner) {
        this.sendRequest(null, Locking.Type.LOCK_AWAIT, lock_name, owner, 0L, false);
    }

    @Override
    protected void sendSignalConditionRequest(String lock_name, boolean all) {
        this.sendRequest(null, all ? Locking.Type.COND_SIG_ALL : Locking.Type.COND_SIG, lock_name, null, 0L, false);
    }

    @Override
    protected void sendDeleteAwaitConditionRequest(String lock_name, Owner owner) {
        this.sendRequest(null, Locking.Type.DELETE_LOCK_AWAIT, lock_name, owner, 0L, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleView(View view) {
        super.handleView(view);
        Vector<Address> members = view.getMembers();
        Map map = this.client_locks;
        synchronized (map) {
            for (Map map2 : this.client_locks.values()) {
                for (Locking.ClientLock lock : map2.values()) {
                    ((PeerLock)lock).retainAll(members);
                }
            }
        }
    }

    @Override
    protected Locking.ClientLock createLock(String lock_name) {
        return new PeerLock(lock_name);
    }

    protected class PeerLock
    extends Locking.ClientLock {
        protected final List<Address> grants;

        public PeerLock(String name) {
            super(name);
            this.grants = new ArrayList<Address>(PEER_LOCK.this.view.getMembers());
        }

        protected synchronized void retainAll(List<Address> members) {
            if (this.grants.isEmpty()) {
                return;
            }
            this.grants.retainAll(members);
            if (this.grants.isEmpty()) {
                this.lockGranted();
            }
        }

        @Override
        protected synchronized void handleLockGrantedResponse(Owner owner, Address sender) {
            if (this.grants.isEmpty()) {
                return;
            }
            this.grants.remove(sender);
            if (this.grants.isEmpty()) {
                this.lockGranted();
            }
        }
    }
}

