/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.util;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.jgroups.Address;
import org.jgroups.util.Util;

public class SeqnoTable {
    private long next_to_receive = 0L;
    private final ConcurrentMap<Address, Entry> map = Util.createConcurrentMap();

    public SeqnoTable(long next_to_receive) {
        this.next_to_receive = next_to_receive;
    }

    public long getHighestReceived(Address member) {
        Entry entry = (Entry)this.map.get(member);
        return entry != null ? entry.getHighestReceived() : -1L;
    }

    public long getNextToReceive(Address member) {
        Entry entry = (Entry)this.map.get(member);
        return entry != null ? entry.getNextToReceive() : -1L;
    }

    public boolean add(Address member, long seqno) {
        Entry entry2;
        Entry entry = (Entry)this.map.get(member);
        if (entry == null && (entry2 = this.map.putIfAbsent(member, entry = new Entry(this.next_to_receive))) != null) {
            entry = entry2;
        }
        return entry.add(seqno);
    }

    public void remove(Address member) {
        this.map.remove(member);
    }

    public boolean retainAll(Collection<Address> members) {
        return this.map.keySet().retainAll(members);
    }

    public void clear() {
        this.map.clear();
    }

    public String toString() {
        return this.map.toString();
    }

    private static class Entry {
        long highest_received;
        long next_to_receive;
        final Set<Long> seqnos = new HashSet<Long>();

        private Entry(long initial_seqno) {
            this.next_to_receive = this.highest_received = initial_seqno;
        }

        public synchronized long getHighestReceived() {
            return this.highest_received;
        }

        public synchronized long getNextToReceive() {
            return this.next_to_receive;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized boolean add(long seqno) {
            try {
                if (seqno == this.next_to_receive) {
                    ++this.next_to_receive;
                    while (this.seqnos.remove(this.next_to_receive)) {
                        ++this.next_to_receive;
                    }
                    boolean bl = true;
                    return bl;
                }
                if (seqno < this.next_to_receive) {
                    boolean bl = false;
                    return bl;
                }
                this.seqnos.add(seqno);
                boolean bl = true;
                return bl;
            }
            finally {
                this.highest_received = Math.max(this.highest_received, seqno);
            }
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.next_to_receive).append(" - ").append(this.highest_received);
            if (!this.seqnos.isEmpty()) {
                sb.append(" ").append(this.seqnos);
            }
            return sb.toString();
        }
    }
}

