/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.jorm.generator.lib;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.objectweb.jorm.api.PException;
import org.objectweb.jorm.compiler.api.PExceptionCompiler;
import org.objectweb.jorm.metainfo.api.Class;
import org.objectweb.jorm.metainfo.api.ClassRef;
import org.objectweb.jorm.metainfo.api.CompositeName;
import org.objectweb.jorm.metainfo.api.FieldName;
import org.objectweb.jorm.metainfo.api.GenClassRef;
import org.objectweb.jorm.metainfo.api.Manager;
import org.objectweb.jorm.metainfo.api.Mapping;
import org.objectweb.jorm.metainfo.api.MetaObject;
import org.objectweb.jorm.metainfo.api.NameDef;
import org.objectweb.jorm.metainfo.api.NameRef;
import org.objectweb.jorm.metainfo.api.Package;
import org.objectweb.jorm.metainfo.api.PrimitiveElement;
import org.objectweb.jorm.metainfo.api.PrimitiveElementMapping;
import org.objectweb.jorm.metainfo.api.Reference;
import org.objectweb.jorm.metainfo.api.ReferenceMapping;
import org.objectweb.jorm.metainfo.api.TypedElement;
import org.objectweb.jorm.type.api.PExceptionTyping;
import org.objectweb.jorm.type.api.PType;
import org.objectweb.jorm.type.api.PTypeSpace;
import org.objectweb.jorm.type.lib.TypeHelper;
import org.objectweb.jorm.util.api.Loggable;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;
import org.objectweb.util.monolog.api.LoggerFactory;

public class CommonHelper
extends TypeHelper
implements Loggable {
    protected LoggerFactory loggerFactory = null;
    protected Logger logger = null;
    protected boolean debug = false;
    public static final PType[] PN_GET_TYPES = new PType[]{PTypeSpace.BYTE, PTypeSpace.CHAR, PTypeSpace.DATE, PTypeSpace.INT, PTypeSpace.LONG, PTypeSpace.OBJBYTE, PTypeSpace.OBJCHAR, PTypeSpace.OBJINT, PTypeSpace.OBJLONG, PTypeSpace.OBJSHORT, PTypeSpace.SHORT, PTypeSpace.STRING, PTypeSpace.BYTEARRAY, PTypeSpace.CHARARRAY, PTypeSpace.BIGDECIMAL, PTypeSpace.BIGINTEGER};

    public String upperFL(String word) {
        if (word != null && word.length() > 0) {
            return word.substring(0, 1).toUpperCase() + word.substring(1);
        }
        return word;
    }

    public PrimitiveElement getPrimitiveElement(Object mo, Class c, boolean canBeFieldName) throws PException {
        if (mo instanceof PrimitiveElement) {
            return (PrimitiveElement)mo;
        }
        if (mo instanceof NameDef) {
            NameDef nd = (NameDef)mo;
            if (nd.isFieldName()) {
                return (PrimitiveElement)c.getTypedElement(nd.getFieldName());
            }
            throw new PException("This is composite name !" + mo);
        }
        throw new PException("impossible to obtain a PrimitiveElement with " + mo);
    }

    public boolean containsReference(Class co) {
        Iterator it = co.getAllFields().iterator();
        while (it.hasNext()) {
            if (!(it.next() instanceof Reference)) continue;
            return true;
        }
        return false;
    }

    public ArrayList getCompositeReferences(Mapping mo) throws Exception {
        ArrayList<NameRef> res = new ArrayList<NameRef>();
        Iterator it = mo.getClassMapping().getReferenceMappings().iterator();
        while (it.hasNext()) {
            ReferenceMapping rm = (ReferenceMapping)it.next();
            if (!((NameDef)rm.getLinkedMO()).isNameRef()) continue;
            res.add(((NameDef)rm.getLinkedMO()).getNameRef());
        }
        return res;
    }

    public String getCNPackageName(MetaObject mo) {
        if (mo instanceof Manager) {
            return null;
        }
        while (!(mo instanceof Package)) {
            mo = mo.getParent();
        }
        if (mo instanceof Package) {
            return ((Package)mo).getName();
        }
        return null;
    }

    public boolean containsSerializedField(Class co) {
        Iterator it = co.getAllFields().iterator();
        while (it.hasNext()) {
            if (((TypedElement)it.next()).getType().getTypeCode() != 20) continue;
            return true;
        }
        return false;
    }

    public boolean containsCharArrayField(Mapping m) {
        Class co = (Class)m.getClassMapping().getLinkedMO();
        Iterator it = co.getAllFields().iterator();
        while (it.hasNext()) {
            TypedElement te = (TypedElement)it.next();
            if (te == null) {
                throw new NullPointerException("A field of the class '" + co.getFQName() + "' is null.");
            }
            if (te.getType() == null) {
                throw new NullPointerException("the type of field '" + te.getName() + "' of the class '" + co.getFQName() + "' is null.");
            }
            if (te.getType().getTypeCode() != 18) continue;
            return true;
        }
        it = co.getAllHiddenFields().iterator();
        while (it.hasNext()) {
            if (((TypedElement)it.next()).getType().getTypeCode() != 18) continue;
            return true;
        }
        NameDef nd = (NameDef)m.getClassMapping().getIdentifierMapping().getLinkedMO();
        if (nd.isNameRef()) {
            it = nd.getNameRef().getCompositeName().getAllFields().iterator();
            while (it.hasNext()) {
                if (((TypedElement)it.next()).getType().getTypeCode() != 18) continue;
                return true;
            }
        }
        return false;
    }

    public boolean containsFieldWhichCanBeNull(Class co) throws PException {
        Iterator it = co.getAllFields().iterator();
        while (it.hasNext()) {
            if (!this.canBeNullValue(((TypedElement)it.next()).getType())) continue;
            return true;
        }
        it = co.getAllHiddenFields().iterator();
        while (it.hasNext()) {
            if (!this.canBeNullValue(((TypedElement)it.next()).getType())) continue;
            return true;
        }
        return false;
    }

    public boolean isValidString(String str) {
        return str != null && str.length() > 0;
    }

    public boolean containsGenClassRef(Class co) {
        Iterator it = co.getAllFields().iterator();
        while (it.hasNext()) {
            if (!(it.next() instanceof GenClassRef)) continue;
            return true;
        }
        return false;
    }

    public boolean isCompositeName(NameDef nd) {
        return nd.isNameRef();
    }

    public Collection getCompositeNameDefEntries(NameDef mo) throws Exception {
        if (mo == null) {
            throw new PException("Null NameDef Parameter");
        }
        if (mo.isNameRef()) {
            return mo.getNameRef().getProjection().entrySet();
        }
        if (mo.isFieldName()) {
            throw new PException("The NameDef is a FieldName (" + mo.getFieldName() + ")");
        }
        if (mo.isSystem()) {
            throw new PException("System identifier unmanaged");
        }
        throw new PException("Unknown NameDef: " + mo);
    }

    public String getFQNOfCompositeName(Object o) {
        CompositeName cn = null;
        if (o instanceof CompositeName) {
            cn = (CompositeName)o;
        } else if (o instanceof NameDef) {
            cn = ((NameDef)o).getNameRef().getCompositeName();
        } else {
            return "";
        }
        String packName = ((Package)cn.getParent()).getName();
        if (packName == null || packName.length() == 0) {
            return cn.getName();
        }
        return packName + "." + cn.getName();
    }

    public boolean containsCompositeName(Mapping mo) {
        if (mo == null) {
            return false;
        }
        NameDef nd = (NameDef)mo.getClassMapping().getIdentifierMapping().getLinkedMO();
        if (nd.isNameRef()) {
            return true;
        }
        if (this.logger != null) {
            this.logger.log(BasicLevel.DEBUG, (Object)"PName class has a single field");
        }
        Iterator it = mo.getClassMapping().getReferenceMappings().iterator();
        while (it.hasNext()) {
            ReferenceMapping rm = (ReferenceMapping)it.next();
            nd = (NameDef)rm.getLinkedMO();
            if (!nd.isNameRef()) continue;
            return true;
        }
        return false;
    }

    public boolean isClass(Object o) {
        return o instanceof Class;
    }

    public boolean isReference(TypedElement te) {
        return te instanceof Reference;
    }

    public boolean isClassRef(TypedElement te) {
        return te instanceof ClassRef;
    }

    public boolean isGenClassRef(TypedElement te) {
        return te instanceof GenClassRef;
    }

    public boolean isPrimitiveElement(Object o) {
        return o instanceof PrimitiveElement;
    }

    public String comparePE(String val1, String val2, PType type) {
        if (this.isObjectType(type)) {
            return "((" + val1 + " == null && " + val2 + " == null) || (" + val1 + " !=null && " + val1 + ".equals(" + val2 + ")))";
        }
        return val1 + " == " + val2;
    }

    public boolean isNull(Object o) {
        return o == null;
    }

    public boolean isHiddenField(PrimitiveElement pe) {
        return ((Class)pe.getParent()).getHiddenField(pe.getName()) != null;
    }

    public boolean isFieldName(Object o) {
        return o instanceof FieldName;
    }

    public boolean isSerializedField(Object o) {
        return o instanceof PrimitiveElement && ((PrimitiveElement)o).getType().getTypeCode() == 20;
    }

    public boolean isSerializedType(PType t) {
        return t.getTypeCode() == 20;
    }

    public boolean isCharArrayType(PType t) {
        return t.getTypeCode() == 18;
    }

    public PrimitiveElementMapping[] buildPemList(Collection pemcoll) {
        return pemcoll.toArray(new PrimitiveElementMapping[0]);
    }

    public int getPemPos(PrimitiveElementMapping[] pemlist, PrimitiveElement pe) throws PExceptionCompiler {
        for (int i = 0; i < pemlist.length; ++i) {
            if (pemlist[i].getLinkedMO() != pe) continue;
            return i + 1;
        }
        throw new PExceptionCompiler("Cannot find a mapping for field: " + pe.getName());
    }

    public PrimitiveElement getPrimitiveElement(String fn, Class cl) throws PExceptionCompiler {
        TypedElement res = cl.getTypedElement(fn);
        if (res == null) {
            throw new PExceptionCompiler("NameDef with field name does not correspond to any field - searched field: " + fn);
        }
        if (!(res instanceof PrimitiveElement)) {
            throw new PExceptionCompiler("NameDef with field name does not correspond to any primitive field - searched field: " + fn);
        }
        return (PrimitiveElement)res;
    }

    public NameDef getRefNameDef(Mapping mo, Reference field) throws PException {
        if (field == null) {
            return null;
        }
        if (mo == null) {
            return null;
        }
        ReferenceMapping rm = mo.getClassMapping().getReferenceMapping(field.getName());
        NameDef nd = null;
        if (rm != null) {
            nd = (NameDef)rm.getLinkedMO();
        }
        if (nd == null) {
            throw new PException("No NameDef found for the reference field '" + field.getName() + "' of the persistent class '" + ((Class)mo.getClassMapping().getLinkedMO()).getFQName() + "'.");
        }
        return nd;
    }

    public String getTupleDecoding(String fn, PType pt, String value) throws PException {
        if (pt == null) {
            throw new PException("Unauthorized null PType");
        }
        StringBuffer sb = new StringBuffer();
        sb.append(fn);
        sb.append("Pnc.");
        sb.append(this.getPNameDecodeFunction(pt));
        sb.append("((");
        sb.append(pt.getJavaName());
        sb.append(") ");
        sb.append(value);
        sb.append(")");
        return sb.toString();
    }

    public String getTupleDecoding(String tmpv, String fn, String tuplevn, PType pt, int pos) throws PException {
        if (pt == null) {
            throw new PException("Unauthorized null PType");
        }
        StringBuffer sb = new StringBuffer();
        if (this.isObjectType(pt)) {
            sb.append("(((");
            sb.append(tmpv);
            sb.append(" = ");
            sb.append(this.getTupleGetter(tuplevn, pt, pos));
            sb.append(") == null) ? ");
            sb.append(fn);
            sb.append("Pnc.getNull() : ");
            sb.append(fn);
            sb.append("Pnc.");
            sb.append(this.getPNameDecodeFunction(pt));
            sb.append("((");
            sb.append(pt.getJavaName());
            sb.append(") ");
            sb.append(tmpv);
            sb.append("))");
        } else {
            sb.append(fn);
            sb.append("Pnc.");
            sb.append(this.getPNameDecodeFunction(pt));
            sb.append("(");
            sb.append(this.getTupleGetter(tuplevn, pt, pos));
            sb.append(")");
        }
        return sb.toString();
    }

    public String getTupleGetter(String tuplevn, PType pt, int pos) throws PException {
        if (pt == null) {
            throw new PException("Unauthorized null PType");
        }
        StringBuffer sb = new StringBuffer();
        switch (pt.getTypeCode()) {
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                sb.append("((").append(pt.getJavaName()).append(") ");
                sb.append("TupleAdapter.getObject(");
                sb.append(tuplevn);
                sb.append(", ").append(pos);
                sb.append(", ").append(pt.getProgName());
                sb.append("))");
                break;
            }
            case 20: {
                sb.append("(Serializable) ");
            }
            default: {
                sb.append(tuplevn).append(".");
                sb.append(this.getTupleGetterAsString(pt));
                sb.append("(").append(pos).append(")");
            }
        }
        return sb.toString();
    }

    public String getPaGetMethod(PType pt) throws PException {
        if (pt == null) {
            throw new PException("Unauthorized null PType");
        }
        return "paGet" + this.getGenPaMethodPart(pt) + "Field";
    }

    public String getPaSetMethod(PType pt) throws PException {
        if (pt == null) {
            throw new PException("Unauthorized null PType");
        }
        return "paSet" + this.getGenPaMethodPart(pt) + "Field";
    }

    public String getPNameDecodeFunction(PType pt) throws PException {
        if (pt == null) {
            throw new PExceptionTyping("The parameter must be not null");
        }
        return "decode" + this.getPNameCodingMethodPart(pt);
    }

    public String getCoderName(PType t) {
        return t.getCodingName();
    }

    public String getPNameGetterGetFunction(PType pt) throws PException {
        if (pt == null) {
            throw new PExceptionTyping("The parameter must be not null");
        }
        return "pnget" + pt.getCodingName() + "Field";
    }

    public String getPNameEncodeFunction(PType pt) throws PException {
        if (pt == null) {
            throw new PExceptionTyping("The parameter must be not null");
        }
        return "encode" + this.getPNameCodingMethodPart(pt);
    }

    public String getCTDeclaration(PType t) {
        return this.getCodingTypeAsString(t.getTypeCode());
    }

    public String getCTDeclaration(int typecode) {
        return this.getCodingTypeAsString(typecode);
    }

    public String getProjectionField(NameDef nd, String cfn) throws Exception {
        if (nd.isNameRef()) {
            NameRef nr = nd.getNameRef();
            Iterator it = nr.getProjection().entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry me = it.next();
                if (!me.getValue().equals(cfn)) continue;
                return (String)me.getKey();
            }
        }
        throw new PException("impossible to obtain field " + cfn + " of " + nd);
    }

    public PType getPType(String ptn) {
        if (ptn.equals("boolean")) {
            return PTypeSpace.BOOLEAN;
        }
        if (ptn.equals("Boolean")) {
            return PTypeSpace.OBJBOOLEAN;
        }
        if (ptn.equals("char")) {
            return PTypeSpace.CHAR;
        }
        if (ptn.equals("Character")) {
            return PTypeSpace.OBJCHAR;
        }
        if (ptn.equals("byte")) {
            return PTypeSpace.BYTE;
        }
        if (ptn.equals("Byte")) {
            return PTypeSpace.OBJBYTE;
        }
        if (ptn.equals("short")) {
            return PTypeSpace.SHORT;
        }
        if (ptn.equals("Short")) {
            return PTypeSpace.OBJSHORT;
        }
        if (ptn.equals("int")) {
            return PTypeSpace.INT;
        }
        if (ptn.equals("Integer")) {
            return PTypeSpace.OBJINT;
        }
        if (ptn.equals("long")) {
            return PTypeSpace.LONG;
        }
        if (ptn.equals("Long")) {
            return PTypeSpace.OBJLONG;
        }
        if (ptn.equals("float")) {
            return PTypeSpace.FLOAT;
        }
        if (ptn.equals("Float")) {
            return PTypeSpace.OBJFLOAT;
        }
        if (ptn.equals("double")) {
            return PTypeSpace.DOUBLE;
        }
        if (ptn.equals("Double")) {
            return PTypeSpace.OBJDOUBLE;
        }
        if (ptn.equals("string")) {
            return PTypeSpace.STRING;
        }
        if (ptn.equals("date")) {
            return PTypeSpace.DATE;
        }
        if (ptn.equals("serialized")) {
            return PTypeSpace.SERIALIZED;
        }
        if (ptn.equals("BigInteger")) {
            return PTypeSpace.BIGINTEGER;
        }
        if (ptn.equals("BigDecimal")) {
            return PTypeSpace.BIGDECIMAL;
        }
        if (ptn.equals("byte[]")) {
            return PTypeSpace.BYTEARRAY;
        }
        if (ptn.equals("char[]")) {
            return PTypeSpace.CHARARRAY;
        }
        if (ptn.equals("reference")) {
            return PTypeSpace.REFTOP;
        }
        return null;
    }

    public PType getPTypeBoolean() {
        return PTypeSpace.BOOLEAN;
    }

    public PType getPTypeOboolean() {
        return PTypeSpace.OBJBOOLEAN;
    }

    public PType getPTypeChar() {
        return PTypeSpace.CHAR;
    }

    public PType getPTypeOchar() {
        return PTypeSpace.OBJCHAR;
    }

    public PType getPTypeByte() {
        return PTypeSpace.BYTE;
    }

    public PType getPTypeObyte() {
        return PTypeSpace.OBJBYTE;
    }

    public PType getPTypeShort() {
        return PTypeSpace.SHORT;
    }

    public PType getPTypeOshort() {
        return PTypeSpace.OBJSHORT;
    }

    public PType getPTypeInt() {
        return PTypeSpace.INT;
    }

    public PType getPTypeOint() {
        return PTypeSpace.OBJINT;
    }

    public PType getPTypeLong() {
        return PTypeSpace.LONG;
    }

    public PType getPTypeOlong() {
        return PTypeSpace.OBJLONG;
    }

    public PType getPTypeFloat() {
        return PTypeSpace.FLOAT;
    }

    public PType getPTypeOfloat() {
        return PTypeSpace.OBJFLOAT;
    }

    public PType getPTypeDouble() {
        return PTypeSpace.DOUBLE;
    }

    public PType getPTypeOdouble() {
        return PTypeSpace.OBJDOUBLE;
    }

    public PType getPTypeString() {
        return PTypeSpace.STRING;
    }

    public PType getPTypeDate() {
        return PTypeSpace.DATE;
    }

    public PType getPTypeCharArray() {
        return PTypeSpace.CHARARRAY;
    }

    public PType getPTypeByteArray() {
        return PTypeSpace.BYTEARRAY;
    }

    public PType getPTypeSerialized() {
        return PTypeSpace.SERIALIZED;
    }

    public PType getPTypeBigInteger() {
        return PTypeSpace.BIGINTEGER;
    }

    public PType getPTypeBigDecimal() {
        return PTypeSpace.BIGDECIMAL;
    }

    public PType getPTypeReference() {
        return PTypeSpace.REFTOP;
    }

    public PType[] getPNGTypes() {
        return PN_GET_TYPES;
    }

    public boolean not(boolean b) {
        return !b;
    }

    public boolean canBeNullValue(PType type) throws PException {
        return this.isObjectType(type);
    }

    public String getInheritedClasses(Class c) {
        HashMap m = this.getInheritedClasses(c, new HashMap(), false);
        StringBuffer sb = new StringBuffer();
        sb.append('{');
        Iterator it = m.entrySet().iterator();
        String sep = "";
        while (it.hasNext()) {
            Map.Entry me = it.next();
            String child = (String)me.getKey();
            String[] parents = (String[])me.getValue();
            for (int i = 0; i < parents.length; ++i) {
                sb.append(sep);
                sb.append("{\"");
                sb.append(child);
                sb.append("\", \"");
                sb.append(parents[i]);
                sb.append("\"}");
                sep = ", ";
            }
        }
        sb.append('}');
        return sb.toString();
    }

    private HashMap getInheritedClasses(Class current, HashMap calculated, boolean addCurrent) {
        int i;
        int parentNumber = current.getInheritedClassNumber();
        if (parentNumber == 0) {
            return calculated;
        }
        int addcurrent = addCurrent ? 1 : 0;
        String[] list = new String[parentNumber + addcurrent];
        if (addCurrent) {
            list[0] = current.getFQName();
        }
        calculated.put(current.getFQName(), list);
        Iterator it = current.getSuperClasses().iterator();
        for (i = addcurrent; it.hasNext() && i < list.length; ++i) {
            Class parent = (Class)it.next();
            list[i] = parent.getFQName();
            if (calculated.containsKey(parent.getFQName())) continue;
            this.getInheritedClasses(parent, calculated, false);
        }
        if (it.hasNext() || i < list.length) {
            throw new RuntimeException("MalFormed JMI");
        }
        return calculated;
    }

    public String log(String msg) {
        System.out.println(msg);
        return msg;
    }

    public String debug(String msg) {
        if (this.logger != null && this.logger.isLoggable(BasicLevel.DEBUG)) {
            this.logger.log(BasicLevel.DEBUG, (Object)msg);
            return "//" + msg;
        }
        return "";
    }

    public String getPTypeSpaceFieldName(PType pt) {
        return pt.getProgName().substring("PTypeSpace.".length());
    }

    public void setLoggerFactory(LoggerFactory lf) {
        if (this.logger == null && lf != null) {
            this.setLogger(lf.getLogger(((Object)((Object)this)).getClass().getName()));
        }
        this.loggerFactory = lf;
    }

    public void setLogger(Logger l) {
        this.logger = l;
        this.debug = this.logger != null && this.logger.isLoggable(BasicLevel.DEBUG);
    }

    public Logger getLogger() {
        return this.logger;
    }

    public LoggerFactory getLoggerFactory() {
        return this.loggerFactory;
    }
}

