/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.jorm.generator.lib;

import java.io.File;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.velocity.app.VelocityEngine;
import org.objectweb.jorm.api.PException;
import org.objectweb.jorm.compiler.api.JormCompilerConfigurator;
import org.objectweb.jorm.compiler.api.JormCompilerParameter;
import org.objectweb.jorm.compiler.api.PExceptionCompiler;
import org.objectweb.jorm.generator.api.Generator;
import org.objectweb.jorm.generator.api.MOPFactory;
import org.objectweb.jorm.generator.lib.AbstractMappingGenerator;
import org.objectweb.jorm.generator.lib.AccessorGenerator;
import org.objectweb.jorm.generator.lib.BinderGenerator;
import org.objectweb.jorm.generator.lib.BindingGenerator;
import org.objectweb.jorm.generator.lib.CommonGenerator;
import org.objectweb.jorm.generator.lib.FPNCGenerator;
import org.objectweb.jorm.generator.lib.KFPNCGenerator;
import org.objectweb.jorm.generator.lib.MappingGenerator;
import org.objectweb.jorm.generator.lib.PNameGenerator;
import org.objectweb.jorm.generator.lib.PNameGetterGenerator;
import org.objectweb.jorm.generator.lib.SerializableGenerator;
import org.objectweb.jorm.generator.lib.StateGenerator;
import org.objectweb.jorm.metainfo.api.Class;
import org.objectweb.jorm.metainfo.api.CompositeName;
import org.objectweb.jorm.metainfo.api.Manager;
import org.objectweb.jorm.util.api.Loggable;
import org.objectweb.jorm.util.io.api.PathExplorer;
import org.objectweb.jorm.util.io.api.TargetHolder;
import org.objectweb.jorm.util.io.lib.DirJavaExplorer;
import org.objectweb.medor.expression.api.ExpressionException;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;
import org.objectweb.util.monolog.api.LoggerFactory;
import org.objectweb.util.monolog.wrapper.velocity.VelocityLogger;

public class JormGenerator
implements Generator,
Loggable {
    private static final String CLASS_RESOURCE_LOADER_DESCRIPTION_PROP = "class.resource.loader.description";
    private static final String CLASS_RESOURCE_LOADER_DESCRIPTION_VALUE = "Velocity Classpath Resource Loader";
    private static final String CLASS_RESOURCE_LOADER_CLASS_PROP = "class.resource.loader.class";
    private static final String CLASS_RESOURCE_LOADER_CLASS_VALUE = "org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader";
    private Manager metaInfoManager = null;
    private Logger logger = null;
    private LoggerFactory loggerFactory = null;
    private HashMap mopFactories = new HashMap();
    private PathExplorer pathExplorer = null;
    private AccessorGenerator accessorGenerator = null;
    private BindingGenerator bindingGenerator = null;
    private MappingGenerator mappingGenerator = null;
    private AbstractMappingGenerator abstractMappingGenerator = null;
    private SerializableGenerator serializableGenerator = null;
    private StateGenerator stateGenerator = null;
    private PNameGetterGenerator pNameGetterGenerator = null;
    private PNameGenerator pNameGenerator = null;
    private BinderGenerator binderGenerator = null;
    private FPNCGenerator fpncGenerator = null;
    private KFPNCGenerator kfpncGenerator = null;
    private VelocityEngine velocityEngine = null;
    private JormCompilerParameter compilerParameter = null;
    private JormCompilerConfigurator compilerConfigurator = null;

    public void init() throws PException {
        int k;
        int j;
        int i;
        this.velocityEngine = new VelocityEngine();
        this.velocityEngine.setProperty("resource.loader", "class");
        this.velocityEngine.setProperty(CLASS_RESOURCE_LOADER_DESCRIPTION_PROP, CLASS_RESOURCE_LOADER_DESCRIPTION_VALUE);
        this.velocityEngine.setProperty(CLASS_RESOURCE_LOADER_CLASS_PROP, CLASS_RESOURCE_LOADER_CLASS_VALUE);
        this.velocityEngine.setProperty("runtime.log.logsystem", new VelocityLogger(this.loggerFactory == null ? this.logger : this.loggerFactory.getLogger(this.logger.getName() + ".velocity")));
        StringBuffer strlibs = new StringBuffer();
        String[][][] libs = this.setupClassGenerators(this.compilerConfigurator, this.compilerParameter);
        String sep = "";
        for (i = 0; i < libs.length; ++i) {
            for (j = 0; j < libs[i].length; ++j) {
                for (k = 0; k < libs[i][j].length; ++k) {
                    strlibs.append(sep);
                    sep = ",";
                    strlibs.append(libs[i][j][k]);
                    this.logger.log(BasicLevel.DEBUG, (Object)("VM Library: " + libs[i][j][k]));
                }
            }
        }
        libs = this.setupCompositeNameGenerators();
        for (i = 0; i < libs.length; ++i) {
            for (j = 0; j < libs[i].length; ++j) {
                for (k = 0; k < libs[i][j].length; ++k) {
                    strlibs.append(sep);
                    sep = ",";
                    strlibs.append(libs[i][j][k]);
                    this.logger.log(BasicLevel.DEBUG, (Object)("VM Library: " + libs[i][j][k]));
                }
            }
        }
        this.velocityEngine.setProperty("velocimacro.library", strlibs.toString());
        try {
            this.logger.log(BasicLevel.DEBUG, (Object)"initializes the velocity engine");
            this.velocityEngine.init();
        }
        catch (Exception e) {
            throw new PExceptionCompiler(e, "Problem while initializing velocity");
        }
    }

    private String[][][] setupClassGenerators(JormCompilerConfigurator jcc, JormCompilerParameter cp) throws PException {
        this.logger.log(BasicLevel.DEBUG, (Object)"setupClassGenerators");
        HashMap<String, CommonGenerator> generators = new HashMap<String, CommonGenerator>();
        if (this.accessorGenerator == null) {
            this.accessorGenerator = new AccessorGenerator();
            generators.put("accessor", this.accessorGenerator);
        }
        if (this.bindingGenerator == null) {
            this.bindingGenerator = new BindingGenerator();
            generators.put("binding", this.bindingGenerator);
        }
        if (this.mappingGenerator == null) {
            this.mappingGenerator = new MappingGenerator(jcc, cp);
            generators.put("mapping", this.mappingGenerator);
        }
        if (this.serializableGenerator == null) {
            this.serializableGenerator = new SerializableGenerator();
            generators.put("serializable", this.serializableGenerator);
        }
        if (this.stateGenerator == null) {
            this.stateGenerator = new StateGenerator();
            generators.put("state", this.stateGenerator);
        }
        if (this.fpncGenerator == null) {
            this.fpncGenerator = new FPNCGenerator();
            generators.put("fpnc", this.fpncGenerator);
        }
        if (this.kfpncGenerator == null) {
            this.kfpncGenerator = new KFPNCGenerator();
            generators.put("kfpnc", this.kfpncGenerator);
        }
        if (this.abstractMappingGenerator == null) {
            this.abstractMappingGenerator = new AbstractMappingGenerator(jcc, cp);
            generators.put("abstractmapping", this.abstractMappingGenerator);
        }
        return this.setupGenerators(generators);
    }

    private String[][][] setupCompositeNameGenerators() {
        this.logger.log(BasicLevel.DEBUG, (Object)"setupCompositeNameGenerators");
        HashMap<String, CommonGenerator> generators = new HashMap<String, CommonGenerator>();
        if (this.pNameGetterGenerator == null) {
            this.pNameGetterGenerator = new PNameGetterGenerator();
            generators.put("pnamegetter", this.pNameGetterGenerator);
        }
        if (this.pNameGenerator == null) {
            this.pNameGenerator = new PNameGenerator();
            generators.put("pname", this.pNameGenerator);
        }
        if (this.binderGenerator == null) {
            this.binderGenerator = new BinderGenerator();
            generators.put("binder", this.binderGenerator);
        }
        return this.setupGenerators(generators);
    }

    private String[][][] setupGenerators(Map generators) {
        int size = generators.size();
        String[][][] templateLibs = new String[size][][];
        Iterator it = generators.entrySet().iterator();
        int i = 0;
        while (it.hasNext()) {
            Map.Entry me = it.next();
            CommonGenerator gen = (CommonGenerator)me.getValue();
            gen.setVelocityEngine(this.velocityEngine);
            if (this.loggerFactory != null) {
                gen.setLogger(this.loggerFactory.getLogger(this.logger.getName() + "." + me.getKey()));
                gen.setLoggerFactory(this.loggerFactory);
            } else {
                gen.setLogger(this.logger);
            }
            templateLibs[i] = gen.getTemplateLibraries();
            ++i;
        }
        return templateLibs;
    }

    private JormCompilerParameter overloadCompilerParameter(String filename, JormCompilerParameter jcp) {
        JormCompilerParameter res;
        this.logger.log(BasicLevel.DEBUG, (Object)"overloadCompilerParameter");
        File fn = new File(filename);
        try {
            this.logger.log(BasicLevel.DEBUG, (Object)("look for parameter file: " + fn.getParent() + File.separator + "jormcOpts.properties"));
            res = (JormCompilerParameter)jcp.clone();
            InputStream is = this.pathExplorer.getInputStream(fn.getParent() + File.separator + "jormcOpts.properties");
            if (is == null) {
                this.logger.log(BasicLevel.DEBUG, (Object)"no overloading");
                res = jcp;
            } else {
                res.loadConfFile(is, this.compilerConfigurator.knownMappers());
                this.logger.log(BasicLevel.DEBUG, (Object)"parameter overloaded");
            }
        }
        catch (PException e) {
            this.logger.log(BasicLevel.DEBUG, (Object)"no overloading");
            res = jcp;
        }
        return res;
    }

    public void setCompilerParameter(JormCompilerParameter jcp) {
        this.compilerParameter = jcp;
    }

    public void setCompilerConfigurator(JormCompilerConfigurator jcc) {
        this.compilerConfigurator = jcc;
    }

    public void setMetaInfoManager(Manager mim) {
        this.metaInfoManager = mim;
    }

    public void setPathExplorer(PathExplorer pathexpl) {
        this.pathExplorer = pathexpl;
        if (this.pathExplorer == null) {
            this.pathExplorer = new DirJavaExplorer();
        }
        this.logger.log(BasicLevel.DEBUG, (Object)("jorm classpath=" + this.pathExplorer.getClassPath()));
    }

    public void addMappingGenerator(String mappername, MOPFactory mappinggenerator) {
        this.mopFactories.put(mappername, mappinggenerator);
    }

    public void generate(Class mo, TargetHolder holder, JormCompilerParameter cp, JormCompilerConfigurator jcc) throws PException {
        boolean debug = this.logger.isLoggable(BasicLevel.DEBUG);
        JormCompilerParameter ocp = this.overloadCompilerParameter(mo.getFileName(), cp);
        if (debug) {
            this.logger.log(BasicLevel.DEBUG, (Object)("class generation: " + mo.getFQName() + "\nfilename=[" + mo.getFileName() + "]" + "\nClassMappingInheritance = " + ocp.getClassMappingInheritance() + "\nBindingInheritance = " + ocp.getBindingInheritance() + "\nProject Name = " + ocp.getProjectName()));
        }
        if (cp.isGenerateBinding()) {
            this.bindingGenerator.generate(mo, holder, ocp, jcc);
            if (debug) {
                this.logger.log(BasicLevel.DEBUG, (Object)(mo.getName() + "Bindings generated"));
            }
        }
        this.mappingGenerator.generate(mo, holder, ocp, jcc);
        if (debug) {
            this.logger.log(BasicLevel.DEBUG, (Object)(mo.getName() + "Mappings generated"));
        }
        this.fpncGenerator.generate(mo, holder, ocp);
        if (debug) {
            this.logger.log(BasicLevel.DEBUG, (Object)(mo.getName() + "FPNCs generated"));
        }
        try {
            if (mo.generateKFPNC()) {
                this.kfpncGenerator.generate(mo, holder, ocp);
                if (debug) {
                    this.logger.log(BasicLevel.DEBUG, (Object)(mo.getName() + "KFPNCs generated"));
                }
            }
        }
        catch (ExpressionException e) {
            throw new PException("Problem with call to generateKFNC() method." + e.getMessage());
        }
        this.accessorGenerator.generate(mo, holder, ocp);
        if (debug) {
            this.logger.log(BasicLevel.DEBUG, (Object)(mo.getName() + "Accessor generated"));
        }
        this.serializableGenerator.generate(mo, holder, ocp);
        if (debug) {
            this.logger.log(BasicLevel.DEBUG, (Object)(mo.getName() + "SerializableData generated"));
        }
        if (ocp.isStateGenerated()) {
            this.stateGenerator.generate(mo, holder, ocp);
            if (debug) {
                this.logger.log(BasicLevel.DEBUG, (Object)(mo.getName() + " state implementation generated"));
            }
        }
    }

    public void generate(CompositeName mo, TargetHolder holder, JormCompilerParameter cp) throws PException {
        if (this.logger.isLoggable(BasicLevel.DEBUG)) {
            this.logger.log(BasicLevel.DEBUG, (Object)("composite name generation: " + mo.getFQName()));
        }
        this.pNameGetterGenerator.generate(mo, holder, cp);
        if (this.logger.isLoggable(BasicLevel.DEBUG)) {
            this.logger.log(BasicLevel.DEBUG, (Object)"XXXpnamegetter generated");
        }
        this.pNameGenerator.generate(mo, holder, cp);
        if (this.logger.isLoggable(BasicLevel.DEBUG)) {
            this.logger.log(BasicLevel.DEBUG, (Object)"XXXpname generated");
        }
        this.binderGenerator.generate(mo, holder, cp);
        if (this.logger.isLoggable(BasicLevel.DEBUG)) {
            this.logger.log(BasicLevel.DEBUG, (Object)"XXXbinder generated");
        }
    }

    public void setLogger(Logger l) {
        this.logger = l;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public LoggerFactory getLoggerFactory() {
        return this.loggerFactory;
    }

    public void setLoggerFactory(LoggerFactory lf) {
        this.loggerFactory = lf;
    }
}

