/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.authenticator;

import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Random;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import org.apache.catalina.Authenticator;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Manager;
import org.apache.catalina.Pipeline;
import org.apache.catalina.Realm;
import org.apache.catalina.Session;
import org.apache.catalina.Valve;
import org.apache.catalina.authenticator.Constants;
import org.apache.catalina.authenticator.SingleSignOn;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.deploy.LoginConfig;
import org.apache.catalina.deploy.SecurityConstraint;
import org.apache.catalina.util.LifecycleSupport;
import org.apache.catalina.util.StringManager;
import org.apache.catalina.valves.ValveBase;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;

public abstract class AuthenticatorBase
extends ValveBase
implements Authenticator,
Lifecycle {
    private static Log log = LogFactory.getLog(AuthenticatorBase.class);
    protected static final String DEFAULT_ALGORITHM = "MD5";
    protected static final int SESSION_ID_BYTES = 16;
    protected static final String REALM_NAME = "Authentication required";
    protected String algorithm = "MD5";
    protected boolean cache = true;
    protected boolean changeSessionIdOnAuthentication = true;
    protected Context context = null;
    protected MessageDigest digest = null;
    protected String entropy = null;
    protected static final String info = "org.apache.catalina.authenticator.AuthenticatorBase/1.0";
    protected boolean disableProxyCaching = true;
    protected boolean securePagesWithPragma = true;
    protected LifecycleSupport lifecycle = new LifecycleSupport(this);
    protected Random random = null;
    protected String randomClass = "java.security.SecureRandom";
    protected static final StringManager sm = StringManager.getManager("org.apache.catalina.authenticator");
    protected SingleSignOn sso = null;
    protected boolean started = false;
    private static final String DATE_ONE = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.US).format(new Date(1L));

    public String getAlgorithm() {
        return this.algorithm;
    }

    public void setAlgorithm(String algorithm) {
        this.algorithm = algorithm;
    }

    public boolean getCache() {
        return this.cache;
    }

    public void setCache(boolean cache) {
        this.cache = cache;
    }

    public Container getContainer() {
        return this.context;
    }

    public void setContainer(Container container) {
        if (!(container instanceof Context)) {
            throw new IllegalArgumentException(sm.getString("authenticator.notContext"));
        }
        super.setContainer(container);
        this.context = (Context)container;
    }

    public String getEntropy() {
        if (this.entropy == null) {
            this.setEntropy(this.toString());
        }
        return this.entropy;
    }

    public void setEntropy(String entropy) {
        this.entropy = entropy;
    }

    public String getInfo() {
        return info;
    }

    public String getRandomClass() {
        return this.randomClass;
    }

    public void setRandomClass(String randomClass) {
        this.randomClass = randomClass;
    }

    public boolean getDisableProxyCaching() {
        return this.disableProxyCaching;
    }

    public void setDisableProxyCaching(boolean nocache) {
        this.disableProxyCaching = nocache;
    }

    public boolean getSecurePagesWithPragma() {
        return this.securePagesWithPragma;
    }

    public void setSecurePagesWithPragma(boolean securePagesWithPragma) {
        this.securePagesWithPragma = securePagesWithPragma;
    }

    public boolean getChangeSessionIdOnAuthentication() {
        return this.changeSessionIdOnAuthentication;
    }

    public void setChangeSessionIdOnAuthentication(boolean changeSessionIdOnAuthentication) {
        this.changeSessionIdOnAuthentication = changeSessionIdOnAuthentication;
    }

    public void invoke(Request request, Response response) throws IOException, ServletException {
        Session session;
        Principal principal;
        if (log.isDebugEnabled()) {
            log.debug("Security checking request " + request.getMethod() + " " + request.getRequestURI());
        }
        LoginConfig config = this.context.getLoginConfig();
        if (this.cache && (principal = request.getUserPrincipal()) == null && (session = request.getSessionInternal(false)) != null && (principal = session.getPrincipal()) != null) {
            if (log.isDebugEnabled()) {
                log.debug("We have cached auth type " + session.getAuthType() + " for principal " + session.getPrincipal());
            }
            request.setAuthType(session.getAuthType());
            request.setUserPrincipal(principal);
        }
        String contextPath = this.context.getPath();
        String requestURI = request.getDecodedRequestURI();
        if (requestURI.startsWith(contextPath) && requestURI.endsWith("/j_security_check") && !this.authenticate(request, response, config)) {
            if (log.isDebugEnabled()) {
                log.debug(" Failed authenticate() test ??" + requestURI);
            }
            return;
        }
        Realm realm = this.context.getRealm();
        SecurityConstraint[] constraints = realm.findSecurityConstraints(request, this.context);
        if (constraints == null) {
            if (log.isDebugEnabled()) {
                log.debug(" Not subject to any constraint");
            }
            this.getNext().invoke(request, response);
            return;
        }
        if (this.disableProxyCaching && !"POST".equalsIgnoreCase(request.getMethod())) {
            if (this.securePagesWithPragma) {
                response.setHeader("Pragma", "No-cache");
                response.setHeader("Cache-Control", "no-cache");
            } else {
                response.setHeader("Cache-Control", "private");
            }
            response.setHeader("Expires", DATE_ONE);
        }
        if (log.isDebugEnabled()) {
            log.debug(" Calling hasUserDataPermission()");
        }
        if (!realm.hasUserDataPermission(request, response, constraints)) {
            if (log.isDebugEnabled()) {
                log.debug(" Failed hasUserDataPermission() test");
            }
            return;
        }
        boolean authRequired = true;
        for (int i = 0; i < constraints.length && authRequired; ++i) {
            String[] roles;
            if (!constraints[i].getAuthConstraint()) {
                authRequired = false;
                continue;
            }
            if (constraints[i].getAllRoles() || (roles = constraints[i].findAuthRoles()) != null && roles.length != 0) continue;
            authRequired = false;
        }
        if (authRequired) {
            if (log.isDebugEnabled()) {
                log.debug(" Calling authenticate()");
            }
            if (!this.authenticate(request, response, config)) {
                if (log.isDebugEnabled()) {
                    log.debug(" Failed authenticate() test");
                }
                return;
            }
        }
        if (log.isDebugEnabled()) {
            log.debug(" Calling accessControl()");
        }
        if (!realm.hasResourcePermission(request, response, constraints, this.context)) {
            if (log.isDebugEnabled()) {
                log.debug(" Failed accessControl() test");
            }
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(" Successfully passed all security constraints");
        }
        this.getNext().invoke(request, response);
    }

    protected void associate(String ssoId, Session session) {
        if (this.sso == null) {
            return;
        }
        this.sso.associate(ssoId, session);
    }

    protected abstract boolean authenticate(Request var1, Response var2, LoginConfig var3) throws IOException;

    protected synchronized String generateSessionId() {
        byte[] bytes = new byte[16];
        this.getRandom().nextBytes(bytes);
        bytes = this.getDigest().digest(bytes);
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < bytes.length; ++i) {
            byte b1 = (byte)((bytes[i] & 0xF0) >> 4);
            byte b2 = (byte)(bytes[i] & 0xF);
            if (b1 < 10) {
                result.append((char)(48 + b1));
            } else {
                result.append((char)(65 + (b1 - 10)));
            }
            if (b2 < 10) {
                result.append((char)(48 + b2));
                continue;
            }
            result.append((char)(65 + (b2 - 10)));
        }
        return result.toString();
    }

    protected synchronized MessageDigest getDigest() {
        if (this.digest == null) {
            try {
                this.digest = MessageDigest.getInstance(this.algorithm);
            }
            catch (NoSuchAlgorithmException e) {
                try {
                    this.digest = MessageDigest.getInstance(DEFAULT_ALGORITHM);
                }
                catch (NoSuchAlgorithmException f) {
                    this.digest = null;
                }
            }
        }
        return this.digest;
    }

    protected synchronized Random getRandom() {
        if (this.random == null) {
            try {
                Class<?> clazz = Class.forName(this.randomClass);
                this.random = (Random)clazz.newInstance();
                long seed = System.currentTimeMillis();
                char[] entropy = this.getEntropy().toCharArray();
                for (int i = 0; i < entropy.length; ++i) {
                    long update = (byte)entropy[i] << i % 8 * 8;
                    seed ^= update;
                }
                this.random.setSeed(seed);
            }
            catch (Exception e) {
                this.random = new Random();
            }
        }
        return this.random;
    }

    protected boolean reauthenticateFromSSO(String ssoId, Request request) {
        Realm realm;
        if (this.sso == null || ssoId == null) {
            return false;
        }
        boolean reauthenticated = false;
        Container parent = this.getContainer();
        if (parent != null && (realm = parent.getRealm()) != null) {
            reauthenticated = this.sso.reauthenticate(ssoId, realm, request);
        }
        if (reauthenticated) {
            this.associate(ssoId, request.getSessionInternal(true));
            if (log.isDebugEnabled()) {
                log.debug(" Reauthenticated cached principal '" + request.getUserPrincipal().getName() + "' with auth type '" + request.getAuthType() + "'");
            }
        }
        return reauthenticated;
    }

    protected void register(Request request, Response response, Principal principal, String authType, String username, String password) {
        if (log.isDebugEnabled()) {
            log.debug("Authenticated '" + principal.getName() + "' with type '" + authType + "'");
        }
        request.setAuthType(authType);
        request.setUserPrincipal(principal);
        Session session = request.getSessionInternal(false);
        if (session != null && this.changeSessionIdOnAuthentication) {
            Manager manager = request.getContext().getManager();
            manager.changeSessionId(session);
            request.changeSessionId(session.getId());
        }
        if (this.cache && session != null) {
            session.setAuthType(authType);
            session.setPrincipal(principal);
            if (username != null) {
                session.setNote("org.apache.catalina.session.USERNAME", username);
            } else {
                session.removeNote("org.apache.catalina.session.USERNAME");
            }
            if (password != null) {
                session.setNote("org.apache.catalina.session.PASSWORD", password);
            } else {
                session.removeNote("org.apache.catalina.session.PASSWORD");
            }
        }
        if (this.sso == null) {
            return;
        }
        String ssoId = (String)request.getNote("org.apache.catalina.request.SSOID");
        if (ssoId == null) {
            ssoId = this.generateSessionId();
            Cookie cookie = new Cookie(Constants.SINGLE_SIGN_ON_COOKIE, ssoId);
            cookie.setMaxAge(-1);
            cookie.setPath("/");
            cookie.setSecure(request.isSecure());
            String ssoDomain = this.sso.getCookieDomain();
            if (ssoDomain != null) {
                cookie.setDomain(ssoDomain);
            }
            response.addCookieInternal(cookie, this.context.getUseHttpOnly());
            this.sso.register(ssoId, principal, authType, username, password);
            request.setNote("org.apache.catalina.request.SSOID", ssoId);
        } else {
            this.sso.update(ssoId, principal, authType, username, password);
        }
        if (session == null) {
            session = request.getSessionInternal(true);
        }
        this.sso.associate(ssoId, session);
    }

    public void addLifecycleListener(LifecycleListener listener) {
        this.lifecycle.addLifecycleListener(listener);
    }

    public LifecycleListener[] findLifecycleListeners() {
        return this.lifecycle.findLifecycleListeners();
    }

    public void removeLifecycleListener(LifecycleListener listener) {
        this.lifecycle.removeLifecycleListener(listener);
    }

    public void start() throws LifecycleException {
        if (this.started) {
            throw new LifecycleException(sm.getString("authenticator.alreadyStarted"));
        }
        this.lifecycle.fireLifecycleEvent("start", null);
        this.started = true;
        Container parent = this.context.getParent();
        while (this.sso == null && parent != null) {
            if (!(parent instanceof Pipeline)) {
                parent = parent.getParent();
                continue;
            }
            Valve[] valves = ((Pipeline)((Object)parent)).getValves();
            for (int i = 0; i < valves.length; ++i) {
                if (!(valves[i] instanceof SingleSignOn)) continue;
                this.sso = (SingleSignOn)valves[i];
                break;
            }
            if (this.sso != null) continue;
            parent = parent.getParent();
        }
        if (log.isDebugEnabled()) {
            if (this.sso != null) {
                log.debug("Found SingleSignOn Valve at " + this.sso);
            } else {
                log.debug("No SingleSignOn Valve is present");
            }
        }
    }

    public void stop() throws LifecycleException {
        if (!this.started) {
            throw new LifecycleException(sm.getString("authenticator.notStarted"));
        }
        this.lifecycle.fireLifecycleEvent("stop", null);
        this.started = false;
        this.sso = null;
    }
}

