/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.mail.internal.factory.mbean;

import java.util.Properties;
import org.ow2.jonas.lib.management.javaee.J2EEResource;
import org.ow2.jonas.lib.management.reconfig.PropertiesConfigurationData;
import org.ow2.jonas.mail.factory.JavaMail;

public abstract class JavaMailResource
extends J2EEResource {
    protected JavaMail mailFactory = null;

    public JavaMailResource(String objectName, boolean stateManageable, boolean statisticsProvider, boolean eventProvider, JavaMail mailFactory) {
        super(objectName, stateManageable, statisticsProvider, eventProvider);
        this.mailFactory = mailFactory;
    }

    public String getFactoryName() {
        return this.mailFactory.getFactoryName();
    }

    public String getName() {
        return this.mailFactory.getName();
    }

    public void setName(String name) {
        this.mailFactory.setName(name);
    }

    public String getFactoryType() {
        return this.mailFactory.getType();
    }

    public Properties getAuthenticationProperties() {
        return this.mailFactory.getAuthenticationProperties();
    }

    public void setAuthenticationProperties(Properties props) {
        this.mailFactory.setAuthenticationProperties(props);
        this.notifyReconfiguration(props);
    }

    public Properties getSessionProperties() {
        return this.mailFactory.getSessionProperties();
    }

    public void setSessionProperties(Properties props) {
        this.mailFactory.setSessionProperties(props);
        this.notifyReconfiguration(props);
    }

    protected abstract long getSequenceNumber();

    public void saveConfig() {
        this.sendSaveNotification(this.getSequenceNumber(), this.getFactoryName());
    }

    protected void notifyReconfiguration(Properties props) {
        PropertiesConfigurationData data = new PropertiesConfigurationData("", null);
        data.setProps(props);
        this.sendReconfigNotification(this.getSequenceNumber(), this.getFactoryName(), data);
    }
}

