/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.generators.genclientstub.wrapper;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.ow2.jonas.lib.bootstrap.LoaderManager;
import org.ow2.jonas.lib.bootstrap.loader.JClassLoader;

public class ClientGenStubWrapper {
    private static final String GENSTUB_CLASSNAME = "org.ow2.jonas.generators.genclientstub.ClientStubGen";
    private static final int ARGS_NUMBER = 3;
    private static Method executeMethod = null;
    private static Method isInputModifiedMethod = null;
    private Object clientGenStub = null;

    public String callClientGenStubExecute(String fileName) throws Exception {
        LoaderManager lm = LoaderManager.getInstance();
        ClassLoader old = null;
        try {
            Class<?> clazz;
            JClassLoader ext = lm.getExternalLoader();
            old = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader((ClassLoader)ext);
            if (executeMethod == null) {
                clazz = ext.loadClass(GENSTUB_CLASSNAME);
                executeMethod = clazz.getDeclaredMethod("execute", String[].class);
            }
            if (this.clientGenStub == null) {
                clazz = ext.loadClass(GENSTUB_CLASSNAME);
                this.clientGenStub = clazz.newInstance();
            }
            String[] args = new String[]{"-d", System.getProperty("java.io.tmpdir"), fileName};
            String string = (String)executeMethod.invoke(this.clientGenStub, new Object[]{args});
            return string;
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof Error) {
                throw (Error)e.getTargetException();
            }
            throw new Exception("Exception when executing ClientstubGen.execute(String[])", e.getTargetException());
        }
        catch (Exception e) {
            throw new Exception("Problems when invoking method ClientstubGen.execute(String[])", e);
        }
        finally {
            if (old != null) {
                Thread.currentThread().setContextClassLoader(old);
            }
        }
    }

    public boolean callClientGenStubIsInputModifed() throws Exception {
        LoaderManager lm = LoaderManager.getInstance();
        ClassLoader old = null;
        try {
            Class<?> clazz;
            JClassLoader ext = lm.getExternalLoader();
            old = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader((ClassLoader)ext);
            if (isInputModifiedMethod == null) {
                clazz = ext.loadClass(GENSTUB_CLASSNAME);
                isInputModifiedMethod = clazz.getDeclaredMethod("isInputModified", new Class[0]);
            }
            if (this.clientGenStub == null) {
                clazz = ext.loadClass(GENSTUB_CLASSNAME);
                this.clientGenStub = clazz.newInstance();
            }
            boolean bl = (Boolean)isInputModifiedMethod.invoke(this.clientGenStub, (Object[])null);
            return bl;
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof Error) {
                throw (Error)e.getTargetException();
            }
            throw new Exception("Exception when executing clientGenStub.isInputModified()", e.getTargetException());
        }
        catch (Exception e) {
            throw new Exception("Problems when invoking method clientGenStub.isInputModified()", e);
        }
        finally {
            if (old != null) {
                Thread.currentThread().setContextClassLoader(old);
            }
        }
    }
}

