/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.resource.internal.cm;

import java.util.Vector;
import javax.resource.ResourceException;
import javax.resource.spi.ManagedConnection;
import javax.transaction.Synchronization;
import javax.transaction.xa.XAResource;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;
import org.ow2.jonas.resource.internal.cm.jta.JResourceManagerEvent;
import org.ow2.jonas.resource.internal.cm.jta.LocalXAResource;
import org.ow2.jonas.resource.internal.cm.sql.cache.PreparedStatementCache;
import org.ow2.jonas.resource.internal.cm.sql.cache.PreparedStatementCacheStatistics;
import org.ow2.jonas.resource.internal.cm.sql.cache.PreparedStatementListCacheImpl;
import org.ow2.jonas.resource.internal.cm.sql.cache.PreparedStatementMapCacheImpl;

public class ManagedConnectionInfo {
    public ManagedConnection mc;
    public Vector usedCs = null;
    public JResourceManagerEvent rme = null;
    public boolean rmeCalled = false;
    public boolean localTransaction = false;
    public LocalXAResource lw = null;
    private Object globaltx;
    public Synchronization synchro = null;
    public PreparedStatementCache pStmts = null;
    private boolean cacheEnabled = false;
    protected static Logger myLogger = null;
    public boolean connectionEventListener = false;

    public ManagedConnectionInfo(ManagedConnection mc, int maxCacheSize, String pstmtCachePolicy, PreparedStatementCacheStatistics pstmtStats, Logger logger) {
        this.mc = mc;
        this.localTransaction = false;
        this.usedCs = new Vector();
        if (maxCacheSize >= 0) {
            this.cacheEnabled = true;
        }
        myLogger = logger;
        String cachePolicy = pstmtCachePolicy;
        if (cachePolicy == null || cachePolicy.equals("")) {
            cachePolicy = System.getProperty("org.ow2.jonas.resource.pstmt.cache.policy");
        }
        if (cachePolicy == null || cachePolicy.equals("")) {
            myLogger.log(BasicLevel.DEBUG, (Object)"Cache policy not set - take the default one : list");
            this.pStmts = new PreparedStatementListCacheImpl(maxCacheSize, pstmtStats, logger);
        } else if (cachePolicy.equalsIgnoreCase("list")) {
            myLogger.log(BasicLevel.DEBUG, (Object)"Cache policy set to list");
            this.pStmts = new PreparedStatementListCacheImpl(maxCacheSize, pstmtStats, logger);
        } else if (cachePolicy.equalsIgnoreCase("map")) {
            myLogger.log(BasicLevel.DEBUG, (Object)"Cache policy set to map");
            this.pStmts = new PreparedStatementMapCacheImpl(maxCacheSize, pstmtStats, logger);
        }
    }

    public void setGlobalTx(Object tx) {
        this.globaltx = tx;
    }

    public Object getGlobalTx() {
        return this.globaltx;
    }

    public String getState(String prefix) {
        String res = prefix + "* mc=" + this.mc + "\n";
        res = res + prefix + "Context=" + this.globaltx + "\n";
        res = res + prefix + "size of usedCs:" + this.usedCs.size() + "\n";
        for (int i = 0; i < this.usedCs.size(); ++i) {
            res = res + prefix + "\t" + this.usedCs.elementAt(i).toString() + "\n";
        }
        res = res + this.pStmts.getState(prefix);
        return res;
    }

    public String getState() {
        return this.getState("");
    }

    public void destroy() throws Exception {
        this.mc.destroy();
    }

    public XAResource getXAResource() throws ResourceException {
        if (this.lw != null) {
            return this.lw;
        }
        return this.mc.getXAResource();
    }

    public JResourceManagerEvent getResourceManagementEvent() {
        return this.rme;
    }

    public boolean isCacheEnabled() {
        return this.cacheEnabled;
    }
}

