/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.component.jdbcpool;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.Map;
import org.ow2.easybeans.component.jdbcpool.JManagedConnection;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JConnection
implements Connection {
    private static Log logger = LogFactory.getLog(JConnection.class);
    private Connection physicalConnection = null;
    private JManagedConnection xaConnection = null;

    public JConnection(JManagedConnection xaConnection, Connection physicalConnection) {
        this.xaConnection = xaConnection;
        this.physicalConnection = physicalConnection;
    }

    public Connection getConnection() {
        return this.physicalConnection;
    }

    @Override
    public Statement createStatement() throws SQLException {
        try {
            return this.physicalConnection.createStatement();
        }
        catch (SQLException e) {
            this.xaConnection.notifyError(e);
            throw e;
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        try {
            return this.xaConnection.prepareStatement(sql);
        }
        catch (SQLException e) {
            this.xaConnection.notifyError(e);
            throw e;
        }
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        try {
            return this.physicalConnection.prepareCall(sql);
        }
        catch (SQLException e) {
            this.xaConnection.notifyError(e);
            throw e;
        }
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        try {
            return this.physicalConnection.nativeSQL(sql);
        }
        catch (SQLException e) {
            this.xaConnection.notifyError(e);
            throw e;
        }
    }

    public boolean isPhysicallyClosed() throws SQLException {
        return this.physicalConnection.isClosed();
    }

    @Override
    public boolean isClosed() throws SQLException {
        try {
            return this.physicalConnection.isClosed();
        }
        catch (SQLException e) {
            this.xaConnection.notifyError(e);
            throw e;
        }
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        try {
            return this.physicalConnection.getMetaData();
        }
        catch (SQLException e) {
            this.xaConnection.notifyError(e);
            throw e;
        }
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        try {
            this.physicalConnection.setReadOnly(readOnly);
        }
        catch (SQLException e) {
            this.xaConnection.notifyError(e);
            throw e;
        }
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        try {
            return this.physicalConnection.isReadOnly();
        }
        catch (SQLException e) {
            this.xaConnection.notifyError(e);
            throw e;
        }
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        try {
            this.physicalConnection.setCatalog(catalog);
        }
        catch (SQLException e) {
            this.xaConnection.notifyError(e);
            throw e;
        }
    }

    @Override
    public String getCatalog() throws SQLException {
        try {
            return this.physicalConnection.getCatalog();
        }
        catch (SQLException e) {
            this.xaConnection.notifyError(e);
            throw e;
        }
    }

    @Override
    public void close() throws SQLException {
        this.xaConnection.notifyClose();
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        try {
            this.physicalConnection.setTransactionIsolation(level);
        }
        catch (SQLException e) {
            this.xaConnection.notifyError(e);
            throw e;
        }
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        try {
            return this.physicalConnection.getTransactionIsolation();
        }
        catch (SQLException e) {
            this.xaConnection.notifyError(e);
            throw e;
        }
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        try {
            return this.physicalConnection.getWarnings();
        }
        catch (SQLException e) {
            this.xaConnection.notifyError(e);
            throw e;
        }
    }

    @Override
    public void clearWarnings() throws SQLException {
        try {
            this.physicalConnection.clearWarnings();
        }
        catch (SQLException e) {
            this.xaConnection.notifyError(e);
            throw e;
        }
    }

    @Override
    public void commit() throws SQLException {
        try {
            this.physicalConnection.commit();
        }
        catch (SQLException e) {
            this.xaConnection.notifyError(e);
            throw e;
        }
    }

    @Override
    public void rollback() throws SQLException {
        try {
            this.physicalConnection.rollback();
        }
        catch (SQLException e) {
            this.xaConnection.notifyError(e);
            throw e;
        }
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        try {
            this.physicalConnection.setAutoCommit(autoCommit);
        }
        catch (SQLException e) {
            logger.error((Object)"setAutoCommit( {0} ) failed: ", new Object[]{autoCommit, e});
            this.xaConnection.notifyError(e);
            throw e;
        }
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        try {
            return this.physicalConnection.getAutoCommit();
        }
        catch (SQLException e) {
            this.xaConnection.notifyError(e);
            throw e;
        }
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        try {
            return this.physicalConnection.createStatement(resultSetType, resultSetConcurrency);
        }
        catch (SQLException e) {
            this.xaConnection.notifyError(e);
            throw e;
        }
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        try {
            return this.physicalConnection.getTypeMap();
        }
        catch (SQLException e) {
            this.xaConnection.notifyError(e);
            throw e;
        }
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        try {
            this.physicalConnection.setTypeMap(map);
        }
        catch (SQLException e) {
            this.xaConnection.notifyError(e);
            throw e;
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        try {
            return this.xaConnection.prepareStatement(sql, resultSetType, resultSetConcurrency);
        }
        catch (SQLException e) {
            this.xaConnection.notifyError(e);
            throw e;
        }
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        try {
            return this.physicalConnection.prepareCall(sql, resultSetType, resultSetConcurrency);
        }
        catch (SQLException e) {
            this.xaConnection.notifyError(e);
            throw e;
        }
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        try {
            return this.physicalConnection.createStatement(resultSetType, resultSetConcurrency, resultSetHoldability);
        }
        catch (SQLException e) {
            this.xaConnection.notifyError(e);
            throw e;
        }
    }

    @Override
    public int getHoldability() throws SQLException {
        try {
            return this.physicalConnection.getHoldability();
        }
        catch (SQLException e) {
            this.xaConnection.notifyError(e);
            throw e;
        }
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        try {
            return this.physicalConnection.prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
        }
        catch (SQLException e) {
            this.xaConnection.notifyError(e);
            throw e;
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        try {
            return this.physicalConnection.prepareStatement(sql, autoGeneratedKeys);
        }
        catch (SQLException e) {
            this.xaConnection.notifyError(e);
            throw e;
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        try {
            return this.physicalConnection.prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
        }
        catch (SQLException e) {
            this.xaConnection.notifyError(e);
            throw e;
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        try {
            return this.physicalConnection.prepareStatement(sql, columnIndexes);
        }
        catch (SQLException e) {
            this.xaConnection.notifyError(e);
            throw e;
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        try {
            return this.physicalConnection.prepareStatement(sql, columnNames);
        }
        catch (SQLException e) {
            this.xaConnection.notifyError(e);
            throw e;
        }
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        try {
            this.physicalConnection.releaseSavepoint(savepoint);
        }
        catch (SQLException e) {
            this.xaConnection.notifyError(e);
            throw e;
        }
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        try {
            this.physicalConnection.rollback(savepoint);
        }
        catch (SQLException e) {
            this.xaConnection.notifyError(e);
            throw e;
        }
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        try {
            this.physicalConnection.setHoldability(holdability);
        }
        catch (SQLException e) {
            this.xaConnection.notifyError(e);
            throw e;
        }
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        try {
            return this.physicalConnection.setSavepoint();
        }
        catch (SQLException e) {
            this.xaConnection.notifyError(e);
            throw e;
        }
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        try {
            return this.physicalConnection.setSavepoint(name);
        }
        catch (SQLException e) {
            this.xaConnection.notifyError(e);
            throw e;
        }
    }
}

