/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.component.statistic;

import org.ow2.easybeans.api.statistic.EZBStatistic;
import org.ow2.easybeans.component.itf.EZBStatisticComponent;
import org.ow2.easybeans.component.statistic.ManagedStatisticFactory;
import org.ow2.easybeans.component.statistic.ManagedStatisticProvider;

public class ManagedStatistic {
    private static final EZBStatisticComponent.STATISTIC_MODE DEFAULT_STATISTIC_MODE = EZBStatisticComponent.STATISTIC_MODE.AUTO;
    private EZBStatistic statistic;
    private ManagedStatisticProvider managedStatisticProvider = null;
    private ManagedStatisticFactory managedStatisticFactory = null;
    private boolean managedStatisticState;
    private EZBStatisticComponent.STATISTIC_MODE managedStatisticMode;

    public ManagedStatistic(ManagedStatisticProvider managedStatisticProvider, ManagedStatisticFactory managedStatisticFactory) {
        this.statistic = managedStatisticFactory.getStatisticFactory().createStatistic(managedStatisticProvider.getStatisticProvider().getStatisticProviderId());
        this.managedStatisticProvider = managedStatisticProvider;
        this.managedStatisticProvider.getManagedStatistics().add(this);
        this.managedStatisticFactory = managedStatisticFactory;
        this.managedStatisticFactory.getManagedStatistics().add(this);
        this.setManagedStatisticMode(DEFAULT_STATISTIC_MODE);
    }

    public void destroy() {
        this.statistic.deactivate();
        this.managedStatisticProvider.getManagedStatistics().remove(this);
        this.managedStatisticFactory.getManagedStatistics().remove(this);
    }

    public void update() {
        this.managedStatisticState = this.getManagedStatisticState();
        if (this.getManagedStatisticState()) {
            this.statistic.activate();
        } else {
            this.statistic.deactivate();
        }
    }

    public EZBStatistic getStatistic() {
        return this.statistic;
    }

    public EZBStatisticComponent.STATISTIC_MODE getManagedStatisticMode() {
        return this.managedStatisticMode;
    }

    public void setManagedStatisticMode(EZBStatisticComponent.STATISTIC_MODE managedStatisticMode) {
        boolean oldManagedStatisticState = this.getManagedStatisticState();
        this.managedStatisticMode = managedStatisticMode;
        if (this.getManagedStatisticState() != oldManagedStatisticState) {
            this.update();
        }
    }

    public boolean getManagedStatisticState() {
        if (this.getManagedStatisticMode() == EZBStatisticComponent.STATISTIC_MODE.MANUAL) {
            return this.managedStatisticState;
        }
        return this.managedStatisticFactory.getManagedStatisticFactoryState() && this.managedStatisticProvider.getManagedStatisticProviderState();
    }

    public void setManagedStatisticState(boolean managedStatisticState) {
        boolean oldManagedStatisticState = this.getManagedStatisticState();
        this.managedStatisticState = managedStatisticState;
        if (this.getManagedStatisticMode() == EZBStatisticComponent.STATISTIC_MODE.AUTO) {
            this.setManagedStatisticMode(EZBStatisticComponent.STATISTIC_MODE.MANUAL);
        }
        if (this.getManagedStatisticState() != oldManagedStatisticState) {
            this.update();
        }
    }
}

