/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.container.info;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.ow2.easybeans.api.bean.info.IMethodInfo;
import org.ow2.easybeans.asm.Type;
import org.ow2.easybeans.deployment.metadata.ejbjar.EasyBeansEjbJarMethodMetadata;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodInfo
implements IMethodInfo {
    private String name = null;
    private List<String> parameterList = new ArrayList<String>();
    private String returnType = null;
    private List<String> exceptionList = null;
    private String descriptor = null;
    private boolean transacted = false;

    public MethodInfo(EasyBeansEjbJarMethodMetadata methodMetadata) {
        this.name = methodMetadata.getMethodName();
        String descriptor = methodMetadata.getJMethod().getDescriptor();
        this.returnType = Type.getReturnType(descriptor).getDescriptor();
        String[] exceptions = methodMetadata.getJMethod().getExceptions();
        this.exceptionList = exceptions != null ? Arrays.asList(exceptions) : new ArrayList<String>();
        Type[] argumentTypes = Type.getArgumentTypes(descriptor);
        if (argumentTypes != null) {
            for (Type argumentType : argumentTypes) {
                String className = argumentType.getClassName();
                if (9 == argumentType.getSort()) {
                    className = argumentType.getDescriptor().replace('/', '.');
                }
                this.parameterList.add(className);
            }
        }
        this.descriptor = methodMetadata.getJMethod().getDescriptor();
        this.transacted = methodMetadata.isTransacted();
    }

    public String getDescriptor() {
        return this.descriptor;
    }

    public String getName() {
        return this.name;
    }

    public List<String> getParameters() {
        return this.parameterList;
    }

    public String getReturnType() {
        return this.returnType;
    }

    public List<String> getExceptions() {
        return this.exceptionList;
    }

    public boolean isTransacted() {
        return this.transacted;
    }
}

