/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.injection;

import java.net.URL;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.LinkRef;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import org.ow2.easybeans.naming.url.URLFactory;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

public final class JNDIBinderHelper {
    private static final String JAVA_COMP = "java:comp/";
    private static final String JAVA_COMP_ENV = "java:comp/env";
    private static Log logger = LogFactory.getLog(JNDIBinderHelper.class);

    private JNDIBinderHelper() {
    }

    public static Context getContext(String name) {
        InitialContext ictx;
        try {
            ictx = new InitialContext();
        }
        catch (NamingException e) {
            logger.error((Object)"Cannot instantiate an initial context", new Object[]{e});
            return null;
        }
        Object o = null;
        try {
            o = ictx.lookup(name);
        }
        catch (NamingException e) {
            logger.error((Object)"Cannot find the JNDI name {0}", new Object[]{name, e});
        }
        if (o == null) {
            logger.error((Object)"No object was found for JNDI name {0}", new Object[]{name});
        }
        Context ctx = null;
        if (o instanceof Context) {
            ctx = (Context)o;
        } else {
            logger.error((Object)"Object not instance of context. Object = {0}", new Object[]{o});
        }
        return ctx;
    }

    public static void bindLinkRefEnvJndiName(String encName, String jndiName) {
        try {
            JNDIBinderHelper.getContext(JAVA_COMP_ENV).rebind(encName, (Object)new LinkRef(jndiName));
        }
        catch (NamingException e) {
            logger.error((Object)"Cannot do a LinkRef between jndiName {0} with ENC name {1}", new Object[]{jndiName, encName, e});
        }
    }

    public static void bindEnvJndiName(String name, Object object) {
        if (object == null) {
            logger.error((Object)"Cannot bind a null object with name {0}", new Object[]{name});
            return;
        }
        try {
            JNDIBinderHelper.getContext(JAVA_COMP_ENV).rebind(name, object);
        }
        catch (NamingException e) {
            logger.error((Object)"Cannot bind object {0} with name {1}", new Object[]{object, name, e});
        }
    }

    public static void bindLinkRefEnvURL(String encName, String url) {
        Reference ref = new Reference(URL.class.getName(), URLFactory.class.getName(), null);
        StringRefAddr refAddr = new StringRefAddr("url", url);
        ref.add(refAddr);
        try {
            JNDIBinderHelper.getContext(JAVA_COMP_ENV).rebind(encName, (Object)ref);
        }
        catch (NamingException e) {
            logger.error((Object)"Cannot bind an URL with name {0} with ENC name {1}", new Object[]{url, encName, e});
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum JndiType {
        JAVA_COMP_ENV;

    }
}

