/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.security.jacc.provider;

import java.security.SecurityPermission;
import java.util.HashMap;
import java.util.Map;
import javax.security.jacc.PolicyConfiguration;
import javax.security.jacc.PolicyConfigurationFactory;
import javax.security.jacc.PolicyContextException;
import org.ow2.easybeans.security.jacc.provider.JPolicyConfiguration;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

public class JPolicyConfigurationFactory
extends PolicyConfigurationFactory {
    private Map<String, PolicyConfiguration> policyConfigurations = new HashMap<String, PolicyConfiguration>();
    private static Log logger = LogFactory.getLog(JPolicyConfigurationFactory.class);

    public PolicyConfiguration getPolicyConfiguration(String contextID, boolean remove) throws PolicyContextException, SecurityException {
        this.checkSetPolicy();
        PolicyConfiguration policyConfiguration = this.getInternalPolicyConfiguration(contextID);
        if (policyConfiguration != null) {
            if (remove) {
                policyConfiguration.delete();
                ((JPolicyConfiguration)policyConfiguration).resetState();
            }
            return policyConfiguration;
        }
        policyConfiguration = new JPolicyConfiguration(contextID);
        this.policyConfigurations.put(contextID, policyConfiguration);
        return policyConfiguration;
    }

    private synchronized PolicyConfiguration getInternalPolicyConfiguration(String contextID) {
        return this.policyConfigurations.get(contextID);
    }

    public boolean inService(String contextID) throws PolicyContextException, SecurityException {
        logger.debug((Object)"Check setpolicy...", new Object[0]);
        this.checkSetPolicy();
        if (this.policyConfigurations.containsKey(contextID)) {
            logger.debug((Object)"Existing config for contextID ''{0}'', gets internal config...", new Object[]{contextID});
            return this.getInternalPolicyConfiguration(contextID).inService();
        }
        logger.debug((Object)"Config for contextID ''{0}'' not found, return false", new Object[]{contextID});
        return false;
    }

    private void checkSetPolicy() throws SecurityException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new SecurityPermission("setPolicy"));
        }
    }
}

