/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.util.jmx.impl;

import java.util.HashSet;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.ReflectionException;
import javax.management.RuntimeOperationsException;
import javax.management.modelmbean.ModelMBeanInfo;
import org.apache.commons.modeler.BaseModelMBean;
import org.apache.commons.modeler.modules.ModelerSource;
import org.ow2.util.jmx.api.IBaseModelMBeanExt;
import org.ow2.util.jmx.api.IMBeanAttribute;
import org.ow2.util.jmx.api.IMBeanOperation;

public abstract class BaseModelMBeanExt
extends BaseModelMBean
implements IBaseModelMBeanExt {
    private HashSet<IMBeanAttribute> attributes = new HashSet();
    private HashSet<IMBeanOperation> operations = new HashSet();

    public BaseModelMBeanExt() throws RuntimeOperationsException, MBeanException {
    }

    public BaseModelMBeanExt(ModelMBeanInfo info) throws RuntimeOperationsException, MBeanException {
        super(info);
    }

    public BaseModelMBeanExt(String type) throws RuntimeOperationsException, MBeanException {
        super(type);
    }

    public BaseModelMBeanExt(String type, ModelerSource source) throws RuntimeOperationsException, MBeanException {
        super(type, source);
    }

    public synchronized MBeanInfo getMBeanInfo() {
        MBeanAttributeInfo[] attributeInfo1 = new MBeanAttributeInfo[]{};
        if (this.attributes != null) {
            int i = 0;
            attributeInfo1 = new MBeanAttributeInfo[this.attributes.size()];
            for (IMBeanAttribute attribute : this.attributes) {
                attributeInfo1[i++] = attribute.getMBeanAttributeInfo();
            }
        }
        MBeanAttributeInfo[] attributeInfo2 = super.getMBeanInfo().getAttributes();
        MBeanAttributeInfo[] attributeInfo = new MBeanAttributeInfo[attributeInfo1.length + attributeInfo2.length];
        System.arraycopy(attributeInfo1, 0, attributeInfo, 0, attributeInfo1.length);
        System.arraycopy(attributeInfo2, 0, attributeInfo, attributeInfo1.length, attributeInfo2.length);
        MBeanOperationInfo[] operationInfo1 = new MBeanOperationInfo[]{};
        if (this.operations != null) {
            int i = 0;
            operationInfo1 = new MBeanOperationInfo[this.operations.size()];
            for (IMBeanOperation operation : this.operations) {
                operationInfo1[i++] = operation.getMBeanOperationInfo();
            }
        }
        MBeanOperationInfo[] operationInfo2 = super.getMBeanInfo().getOperations();
        MBeanOperationInfo[] operationInfo = new MBeanOperationInfo[operationInfo1.length + operationInfo2.length];
        System.arraycopy(operationInfo1, 0, operationInfo, 0, operationInfo1.length);
        System.arraycopy(operationInfo2, 0, operationInfo, operationInfo1.length, operationInfo2.length);
        return new MBeanInfo(super.getMBeanInfo().getClassName(), super.getMBeanInfo().getDescription(), attributeInfo, super.getMBeanInfo().getConstructors(), operationInfo, super.getMBeanInfo().getNotifications());
    }

    public synchronized void addAttribute(IMBeanAttribute attribute) {
        this.attributes.add(attribute);
    }

    public synchronized void removeAttribute(IMBeanAttribute attribute) {
        this.attributes.remove(attribute);
    }

    public synchronized AttributeList getAttributes(String[] names) {
        AttributeList attributeList = new AttributeList();
        for (String name : names) {
            try {
                attributeList.add(new Attribute(name, this.getAttribute(name)));
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        return attributeList;
    }

    public synchronized Object getAttribute(String name) throws AttributeNotFoundException, MBeanException, ReflectionException {
        try {
            IMBeanAttribute iattribute = null;
            for (IMBeanAttribute temp : this.attributes) {
                if (!temp.getMBeanAttributeInfo().getName().equals(name)) continue;
                iattribute = temp;
                break;
            }
            return iattribute.getValue(this.getBaseModelMBeanExtId());
        }
        catch (Exception ex) {
            return super.getAttribute(name);
        }
    }

    public synchronized AttributeList setAttributes(AttributeList attributes) {
        AttributeList attributeList = new AttributeList();
        for (Object object : attributes) {
            try {
                this.setAttribute((Attribute)object);
                attributeList.add((Attribute)object);
            }
            catch (Exception ex) {}
        }
        return attributeList;
    }

    public synchronized void setAttribute(Attribute attribute) throws AttributeNotFoundException, MBeanException, ReflectionException {
        try {
            IMBeanAttribute iattribute = null;
            for (IMBeanAttribute temp : this.attributes) {
                if (!temp.getMBeanAttributeInfo().getName().equals(attribute.getName())) continue;
                iattribute = temp;
                break;
            }
            iattribute.setValue(this.getBaseModelMBeanExtId(), attribute.getValue());
        }
        catch (Exception ex) {
            super.setAttribute(attribute);
        }
    }

    public synchronized void addOperation(IMBeanOperation operation) {
        this.operations.add(operation);
    }

    public synchronized void removeOperation(IMBeanOperation operation) {
        this.operations.remove(operation);
    }

    public synchronized Object invoke(String name, Object[] params, String[] signature) throws MBeanException, ReflectionException {
        try {
            IMBeanOperation ioperation = null;
            for (IMBeanOperation temp : this.operations) {
                MBeanParameterInfo[] tempSignature = temp.getMBeanOperationInfo().getSignature();
                if (signature.length != tempSignature.length) continue;
                boolean ok = true;
                for (int i = 0; ok && i < tempSignature.length; ++i) {
                    if (tempSignature[i].getType().equals(signature[i])) continue;
                    try {
                        ok = Class.forName(tempSignature[i].getType()).equals(Class.forName(signature[i]));
                        continue;
                    }
                    catch (ClassNotFoundException e) {
                        ok = false;
                    }
                }
                if (!ok) continue;
                ioperation = temp;
                break;
            }
            return ioperation.invoke(this.getBaseModelMBeanExtId(), params);
        }
        catch (Exception ex) {
            return super.invoke(name, params, signature);
        }
    }

    public abstract String getBaseModelMBeanExtId();
}

